/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.startup.impl;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.metrics.Metric;
import org.merlyn.desktopapp.metrics.MetricName;
import org.merlyn.desktopapp.startup.Hook;
import oshi.SystemInfo;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.SoundCard;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020 H\u0094@\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020 H\u0002J$\u0010$\u001a\u00020\t2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0002J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010(\u001a\u00020\u0003H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0016\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001a\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/merlyn/desktopapp/startup/impl/ResourceUsageHook;", "Lorg/merlyn/desktopapp/startup/Hook;", "scheduleInMs", "", "<init>", "(J)V", "metricInstance", "Lorg/merlyn/desktopapp/metrics/Metric;", "enableMetrics", "", "memoryUsage", "Ljava/lang/management/MemoryUsage;", "hardware", "Loshi/hardware/HardwareAbstractionLayer;", "os", "Loshi/software/os/OperatingSystem;", "process", "Loshi/software/os/OSProcess;", "heapUsedInMB", "Ljava/util/concurrent/atomic/AtomicReference;", "", "kotlin.jvm.PlatformType", "heapFreeInMB", "nativeMemory", "virtualMemory", "hardwareVirtualMaxMemory", "hardwareVirtualInUseMemory", "freeMemory", "soundCards", "", "Loshi/hardware/SoundCard;", "configureAndGetStaticMetrics", "", "internalExecute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateValues", "checkChange", "prevSoundCards", "currentSoundCards", "formatSize", "size", "app"})
@SourceDebugExtension(value={"SMAP\nResourceUsageHook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceUsageHook.kt\norg/merlyn/desktopapp/startup/impl/ResourceUsageHook\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,200:1\n1#2:201\n1869#3,2:202\n*S KotlinDebug\n*F\n+ 1 ResourceUsageHook.kt\norg/merlyn/desktopapp/startup/impl/ResourceUsageHook\n*L\n166#1:202,2\n*E\n"})
public final class ResourceUsageHook
extends Hook {
    @NotNull
    private final Metric metricInstance = Metric.Companion.instance();
    private boolean enableMetrics;
    @Nullable
    private MemoryUsage memoryUsage;
    private HardwareAbstractionLayer hardware;
    private OperatingSystem os;
    @Nullable
    private OSProcess process;
    @NotNull
    private final AtomicReference<Double> heapUsedInMB = new AtomicReference<Double>(0.0);
    @NotNull
    private final AtomicReference<Double> heapFreeInMB = new AtomicReference<Double>(0.0);
    @NotNull
    private final AtomicReference<Double> nativeMemory = new AtomicReference<Double>(0.0);
    @NotNull
    private final AtomicReference<Double> virtualMemory = new AtomicReference<Double>(0.0);
    @NotNull
    private final AtomicReference<Double> hardwareVirtualMaxMemory = new AtomicReference<Double>(0.0);
    @NotNull
    private final AtomicReference<Double> hardwareVirtualInUseMemory = new AtomicReference<Double>(0.0);
    @NotNull
    private final AtomicReference<Double> freeMemory = new AtomicReference<Double>(0.0);
    @NotNull
    private List<? extends SoundCard> soundCards = CollectionsKt.emptyList();

    public ResourceUsageHook(long scheduleInMs) {
        super(scheduleInMs, false, 2, null);
        try {
            this.memoryUsage = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            SystemInfo si = new SystemInfo();
            HardwareAbstractionLayer hardwareAbstractionLayer = si.getHardware();
            Intrinsics.checkNotNullExpressionValue((Object)hardwareAbstractionLayer, (String)"getHardware(...)");
            this.hardware = hardwareAbstractionLayer;
            OperatingSystem operatingSystem = si.getOperatingSystem();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"getOperatingSystem(...)");
            this.os = operatingSystem;
            OperatingSystem operatingSystem2 = this.os;
            if (operatingSystem2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"os");
                operatingSystem2 = null;
            }
            this.process = operatingSystem2.getCurrentProcess();
            this.enableMetrics = true;
        }
        catch (Exception ex) {
            Metric.counterIncrement$default(this.metricInstance, MetricName.RESOURCE_HOOK_INIT_ERROR, null, 2, null);
            this.getLogger().error((Throwable)ex, ResourceUsageHook::_init_$lambda$0);
        }
        if (this.enableMetrics) {
            try {
                this.configureAndGetStaticMetrics();
            }
            catch (Exception ex) {
                this.enableMetrics = false;
                Metric.counterIncrement$default(this.metricInstance, MetricName.RESOURCE_HOOK_INIT_ERROR, null, 2, null);
                this.getLogger().error((Throwable)ex, ResourceUsageHook::_init_$lambda$1);
            }
        }
    }

    private final void configureAndGetStaticMetrics() {
        HardwareAbstractionLayer hardwareAbstractionLayer;
        this.updateValues();
        MemoryUsage memoryUsage = this.memoryUsage;
        if (memoryUsage != null) {
            MemoryUsage it = memoryUsage;
            boolean bl = false;
            Metric.gaugeValue$default(this.metricInstance, MetricName.MEMORY_JVM_MAX, new AtomicReference<Double>(this.formatSize(it.getMax())), null, 4, null);
            Metric.gaugeValue$default(this.metricInstance, MetricName.MEMORY_JVM_COMMITTED, new AtomicReference<Double>(this.formatSize(it.getCommitted())), null, 4, null);
        } else {
            ResourceUsageHook $this$configureAndGetStaticMetrics_u24lambda_u241 = this;
            boolean bl = false;
            $this$configureAndGetStaticMetrics_u24lambda_u241.getLogger().error(ResourceUsageHook::configureAndGetStaticMetrics$lambda$1$0);
        }
        if ((hardwareAbstractionLayer = this.hardware) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer = null;
        }
        Metric.gaugeValue$default(this.metricInstance, MetricName.HW_TOTAL_MEMORY, new AtomicReference<Double>(this.formatSize(hardwareAbstractionLayer.getMemory().getTotal())), null, 4, null);
        Metric.gaugeValue$default(this.metricInstance, MetricName.HW_VIRTUAL_MEMORY_MAX, this.hardwareVirtualMaxMemory, null, 4, null);
        Metric.gaugeValue$default(this.metricInstance, MetricName.HW_VIRTUAL_MEMORY_IN_USE, this.hardwareVirtualInUseMemory, null, 4, null);
        Metric.gaugeValue$default(this.metricInstance, MetricName.HW_AVAILABLE_MEMORY, this.freeMemory, null, 4, null);
        HardwareAbstractionLayer hardwareAbstractionLayer2 = this.hardware;
        if (hardwareAbstractionLayer2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer2 = null;
        }
        String processorName = hardwareAbstractionLayer2.getProcessor().getProcessorIdentifier().getName();
        HardwareAbstractionLayer hardwareAbstractionLayer3 = this.hardware;
        if (hardwareAbstractionLayer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer3 = null;
        }
        String processorId = hardwareAbstractionLayer3.getProcessor().getProcessorIdentifier().getProcessorID();
        HardwareAbstractionLayer hardwareAbstractionLayer4 = this.hardware;
        if (hardwareAbstractionLayer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer4 = null;
        }
        String processorStepping = hardwareAbstractionLayer4.getProcessor().getProcessorIdentifier().getStepping();
        HardwareAbstractionLayer hardwareAbstractionLayer5 = this.hardware;
        if (hardwareAbstractionLayer5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer5 = null;
        }
        String processorFamily = hardwareAbstractionLayer5.getProcessor().getProcessorIdentifier().getFamily();
        HardwareAbstractionLayer hardwareAbstractionLayer6 = this.hardware;
        if (hardwareAbstractionLayer6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer6 = null;
        }
        String processorArchitecture = hardwareAbstractionLayer6.getProcessor().getProcessorIdentifier().getMicroarchitecture();
        this.getLogger().info(() -> ResourceUsageHook.configureAndGetStaticMetrics$lambda$2(processorName, processorId, processorStepping, processorFamily, processorArchitecture));
        HardwareAbstractionLayer hardwareAbstractionLayer7 = this.hardware;
        if (hardwareAbstractionLayer7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer7 = null;
        }
        String systemModel = hardwareAbstractionLayer7.getComputerSystem().getModel();
        HardwareAbstractionLayer hardwareAbstractionLayer8 = this.hardware;
        if (hardwareAbstractionLayer8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer8 = null;
        }
        String systemManufacturer = hardwareAbstractionLayer8.getComputerSystem().getManufacturer();
        HardwareAbstractionLayer hardwareAbstractionLayer9 = this.hardware;
        if (hardwareAbstractionLayer9 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer9 = null;
        }
        String systemSerialNumber = hardwareAbstractionLayer9.getComputerSystem().getSerialNumber();
        HardwareAbstractionLayer hardwareAbstractionLayer10 = this.hardware;
        if (hardwareAbstractionLayer10 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer10 = null;
        }
        String motherBoardManufacturer = hardwareAbstractionLayer10.getComputerSystem().getBaseboard().getManufacturer();
        HardwareAbstractionLayer hardwareAbstractionLayer11 = this.hardware;
        if (hardwareAbstractionLayer11 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer11 = null;
        }
        String motherBoardModel = hardwareAbstractionLayer11.getComputerSystem().getBaseboard().getModel();
        HardwareAbstractionLayer hardwareAbstractionLayer12 = this.hardware;
        if (hardwareAbstractionLayer12 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer12 = null;
        }
        String motherBoardVersion = hardwareAbstractionLayer12.getComputerSystem().getBaseboard().getVersion();
        HardwareAbstractionLayer hardwareAbstractionLayer13 = this.hardware;
        if (hardwareAbstractionLayer13 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer13 = null;
        }
        String motherBoardSerialNumber = hardwareAbstractionLayer13.getComputerSystem().getBaseboard().getSerialNumber();
        HardwareAbstractionLayer hardwareAbstractionLayer14 = this.hardware;
        if (hardwareAbstractionLayer14 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer14 = null;
        }
        String firmwareName = hardwareAbstractionLayer14.getComputerSystem().getFirmware().getName();
        HardwareAbstractionLayer hardwareAbstractionLayer15 = this.hardware;
        if (hardwareAbstractionLayer15 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer15 = null;
        }
        String firmwareVersion = hardwareAbstractionLayer15.getComputerSystem().getFirmware().getVersion();
        HardwareAbstractionLayer hardwareAbstractionLayer16 = this.hardware;
        if (hardwareAbstractionLayer16 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer16 = null;
        }
        String firmwareManufacturer = hardwareAbstractionLayer16.getComputerSystem().getFirmware().getManufacturer();
        HardwareAbstractionLayer hardwareAbstractionLayer17 = this.hardware;
        if (hardwareAbstractionLayer17 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer17 = null;
        }
        String firmwareDescription = hardwareAbstractionLayer17.getComputerSystem().getFirmware().getDescription();
        HardwareAbstractionLayer hardwareAbstractionLayer18 = this.hardware;
        if (hardwareAbstractionLayer18 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer18 = null;
        }
        String firmwareReleaseDate = hardwareAbstractionLayer18.getComputerSystem().getFirmware().getReleaseDate();
        this.metricInstance.counterIncrement(MetricName.HW_SYSTEM, CollectionsKt.listOf((Object)new Pair((Object)"model - manufacturer", (Object)(systemModel + " - " + systemManufacturer))));
        this.getLogger().info(() -> ResourceUsageHook.configureAndGetStaticMetrics$lambda$3(systemModel, systemManufacturer, systemSerialNumber));
        this.getLogger().info(() -> ResourceUsageHook.configureAndGetStaticMetrics$lambda$4(motherBoardModel, motherBoardManufacturer, motherBoardVersion, motherBoardSerialNumber));
        this.getLogger().info(() -> ResourceUsageHook.configureAndGetStaticMetrics$lambda$5(firmwareName, firmwareVersion, firmwareManufacturer, firmwareDescription, firmwareReleaseDate));
        Metric.gaugeValue$default(this.metricInstance, MetricName.MEMORY_JVM_USAGE, this.heapUsedInMB, null, 4, null);
        Metric.gaugeValue$default(this.metricInstance, MetricName.MEMORY_JVM_FREE, this.heapFreeInMB, null, 4, null);
        Metric.gaugeValue$default(this.metricInstance, MetricName.MEMORY_NATIVE_ALLOCATED, this.nativeMemory, null, 4, null);
        Metric.gaugeValue$default(this.metricInstance, MetricName.MEMORY_NATIVE_VIRTUAL, this.virtualMemory, null, 4, null);
    }

    @Override
    @Nullable
    protected Object internalExecute(@NotNull Continuation<? super Unit> $completion) {
        if (this.enableMetrics) {
            try {
                this.updateValues();
            }
            catch (Exception ex) {
                this.enableMetrics = false;
                Metric.counterIncrement$default(this.metricInstance, MetricName.RESOURCE_HOOK_COLLECT_ERROR, null, 2, null);
                this.getLogger().error((Throwable)ex, ResourceUsageHook::internalExecute$lambda$0);
            }
        }
        return Unit.INSTANCE;
    }

    private final void updateValues() {
        HardwareAbstractionLayer hardwareAbstractionLayer;
        HardwareAbstractionLayer hardwareAbstractionLayer2;
        MemoryUsage memoryUsage = this.memoryUsage;
        if (memoryUsage != null) {
            MemoryUsage memoryUsage2 = memoryUsage;
            boolean bl = false;
            long heapUsed = memoryUsage2.getUsed();
            long heapCommitted = memoryUsage2.getCommitted();
            this.heapFreeInMB.set(this.formatSize(heapCommitted - heapUsed));
            this.heapUsedInMB.set(this.formatSize(heapUsed));
        } else {
            ResourceUsageHook $this$updateValues_u24lambda_u241 = this;
            boolean bl = false;
            $this$updateValues_u24lambda_u241.getLogger().error(ResourceUsageHook::updateValues$lambda$1$0);
        }
        OSProcess oSProcess = this.process;
        if (oSProcess != null) {
            OSProcess process2 = oSProcess;
            boolean bl = false;
            process2.updateAttributes();
            this.nativeMemory.set(this.formatSize(process2.getResidentSetSize()));
            this.virtualMemory.set(this.formatSize(process2.getVirtualSize()));
        } else {
            ResourceUsageHook $this$updateValues_u24lambda_u243 = this;
            boolean bl = false;
            $this$updateValues_u24lambda_u243.getLogger().error(ResourceUsageHook::updateValues$lambda$3$0);
        }
        if ((hardwareAbstractionLayer2 = this.hardware) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer2 = null;
        }
        this.freeMemory.set(this.formatSize(hardwareAbstractionLayer2.getMemory().getAvailable()));
        HardwareAbstractionLayer hardwareAbstractionLayer3 = this.hardware;
        if (hardwareAbstractionLayer3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer3 = null;
        }
        this.hardwareVirtualMaxMemory.set(this.formatSize(hardwareAbstractionLayer3.getMemory().getVirtualMemory().getVirtualMax()));
        HardwareAbstractionLayer hardwareAbstractionLayer4 = this.hardware;
        if (hardwareAbstractionLayer4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer4 = null;
        }
        this.hardwareVirtualInUseMemory.set(this.formatSize(hardwareAbstractionLayer4.getMemory().getVirtualMemory().getVirtualInUse()));
        HardwareAbstractionLayer hardwareAbstractionLayer5 = this.hardware;
        if (hardwareAbstractionLayer5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer5 = null;
        }
        List list = hardwareAbstractionLayer5.getSoundCards();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getSoundCards(...)");
        if (this.checkChange(this.soundCards, list)) {
            HardwareAbstractionLayer hardwareAbstractionLayer6 = this.hardware;
            if (hardwareAbstractionLayer6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
                hardwareAbstractionLayer6 = null;
            }
            List list2 = hardwareAbstractionLayer6.getSoundCards();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSoundCards(...)");
            Iterable $this$forEach$iv = list2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SoundCard it = (SoundCard)element$iv;
                boolean bl = false;
                this.metricInstance.counterIncrement(MetricName.HW_SOUNDCARD, CollectionsKt.listOf((Object)new Pair((Object)"name", (Object)it.getName())));
                this.getLogger().info(() -> ResourceUsageHook.updateValues$lambda$4$0(it));
            }
        }
        if ((hardwareAbstractionLayer = this.hardware) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hardware");
            hardwareAbstractionLayer = null;
        }
        List list3 = hardwareAbstractionLayer.getSoundCards();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getSoundCards(...)");
        this.soundCards = list3;
    }

    private final boolean checkChange(List<? extends SoundCard> prevSoundCards, List<? extends SoundCard> currentSoundCards) {
        if (prevSoundCards.size() != currentSoundCards.size()) {
            return true;
        }
        int n = ((Collection)prevSoundCards).size();
        for (int i = 0; i < n; ++i) {
            if (Intrinsics.areEqual((Object)prevSoundCards.get(i).getName(), (Object)currentSoundCards.get(i).getName()) && Intrinsics.areEqual((Object)prevSoundCards.get(i).getDriverVersion(), (Object)currentSoundCards.get(i).getDriverVersion()) && Intrinsics.areEqual((Object)prevSoundCards.get(i).getCodec(), (Object)currentSoundCards.get(i).getCodec())) continue;
            return true;
        }
        return false;
    }

    private final double formatSize(long size) {
        return (double)size / 1048576.0;
    }

    private static final Object _init_$lambda$0() {
        return "Error initializing ResourceUsageHook, disabling collection";
    }

    private static final Object _init_$lambda$1() {
        return "Error collecting initial metrics during initialization of ResourceUsageHook, disabling collection";
    }

    private static final Object configureAndGetStaticMetrics$lambda$1$0() {
        return "Unable to collect JVM metrics";
    }

    private static final Object configureAndGetStaticMetrics$lambda$2(String $processorName, String $processorId, String $processorStepping, String $processorFamily, String $processorArchitecture) {
        return "processor information: name=" + $processorName + ", id=" + $processorId + ", stepping=" + $processorStepping + ", family=" + $processorFamily + ", architecture=" + $processorArchitecture;
    }

    private static final Object configureAndGetStaticMetrics$lambda$3(String $systemModel, String $systemManufacturer, String $systemSerialNumber) {
        return "hardware system information: model=" + $systemModel + ", manufacturer=" + $systemManufacturer + ", serialNumber=" + $systemSerialNumber;
    }

    private static final Object configureAndGetStaticMetrics$lambda$4(String $motherBoardModel, String $motherBoardManufacturer, String $motherBoardVersion, String $motherBoardSerialNumber) {
        return "motherboard information: model=" + $motherBoardModel + ", manufacturer=" + $motherBoardManufacturer + ", version=" + $motherBoardVersion + ", serialNumber=" + $motherBoardSerialNumber;
    }

    private static final Object configureAndGetStaticMetrics$lambda$5(String $firmwareName, String $firmwareVersion, String $firmwareManufacturer, String $firmwareDescription, String $firmwareReleaseDate) {
        return "firmware information: name=" + $firmwareName + ", version=" + $firmwareVersion + ", manufacturer=" + $firmwareManufacturer + ", description=" + $firmwareDescription + ", releaseDate=" + $firmwareReleaseDate;
    }

    private static final Object internalExecute$lambda$0() {
        return "Error collecting periodic metrics, disabling collection";
    }

    private static final Object updateValues$lambda$1$0() {
        return "Unable to collect JVM metrics";
    }

    private static final Object updateValues$lambda$3$0() {
        return "Unable to collect process metrics";
    }

    private static final Object updateValues$lambda$4$0(SoundCard $it) {
        return "sound card information: name=" + $it.getName() + ", driverVersion=" + $it.getDriverVersion() + ", codec=" + $it.getCodec();
    }
}

