/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.storage.database;

import java.lang.invoke.LambdaMetafactory;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.storage.database.FindScreenResult;
import org.merlyn.desktopapp.storage.database.ScreenInformation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u0011\u001a\u00020\u00102\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u0012\u001a\u00020\u00132\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u000eJ\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u000eJ\u0012\u0010\u0018\u001a\u00020\u0019*\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0012\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\f0\u000b*\u00020\u0019H\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/merlyn/desktopapp/storage/database/ScreensConfigurationDatabaseDao;", "", "connection", "Ljava/sql/Connection;", "<init>", "(Ljava/sql/Connection;)V", "logger", "Lmu/KLogger;", "insert", "", "screens", "", "Lorg/merlyn/desktopapp/storage/database/ScreenInformation;", "activeScreen", "", "update", "", "upsert", "find", "Lorg/merlyn/desktopapp/storage/database/FindScreenResult;", "delete", "id", "purge", "getRowCount", "serialize", "", "deserialize", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nScreenConfigurationDatabaseDao.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreenConfigurationDatabaseDao.kt\norg/merlyn/desktopapp/storage/database/ScreensConfigurationDatabaseDao\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,190:1\n1563#2:191\n1634#2,2:192\n1563#2:194\n1634#2,3:195\n1636#2:198\n*S KotlinDebug\n*F\n+ 1 ScreenConfigurationDatabaseDao.kt\norg/merlyn/desktopapp/storage/database/ScreensConfigurationDatabaseDao\n*L\n166#1:191\n166#1:192,2\n167#1:194\n167#1:195,3\n166#1:198\n*E\n"})
public final class ScreensConfigurationDatabaseDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Connection connection;
    @NotNull
    private final KLogger logger;
    @NotNull
    public static final String CREATE_TABLE_SQL = "\n            CREATE TABLE IF NOT EXISTS screens_config (\n                id INTEGER PRIMARY KEY,\n                last_use_ts INTEGER NOT NULL,\n                screens TEXT NOT NULL,\n                active_screen INTEGER NOT NULL\n            );\n        ";
    @NotNull
    public static final String CREATE_INDEX_SQL = "\n            CREATE UNIQUE INDEX IF NOT EXISTS screens_config_screens ON screens_config (screens);\n        ";
    public static final long MAX_ROWS = 1000L;
    public static final long MAX_AGE_DAYS = 730L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScreensConfigurationDatabaseDao(@Nullable Connection connection) {
        this.connection = connection;
        this.logger = KotlinLogging.INSTANCE.logger(ScreensConfigurationDatabaseDao::logger$lambda$0);
        AutoCloseable autoCloseable = this.connection;
        if (autoCloseable != null && (autoCloseable = autoCloseable.createStatement()) != null) {
            AutoCloseable autoCloseable2 = autoCloseable;
            Throwable throwable = null;
            try {
                Object object;
                Statement it = (Statement)autoCloseable2;
                boolean bl = false;
                try {
                    it.addBatch(CREATE_TABLE_SQL);
                    it.addBatch(CREATE_INDEX_SQL);
                    object = it.executeBatch();
                }
                catch (SQLException ex) {
                    this.logger.error((Throwable)ex, ScreensConfigurationDatabaseDao::lambda$0$0);
                    object = Unit.INSTANCE;
                }
                Object object2 = object;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insert(@NotNull Collection<ScreenInformation> screens, long activeScreen) {
        block8: {
            Intrinsics.checkNotNullParameter(screens, (String)"screens");
            if (screens.isEmpty()) {
                return;
            }
            try {
                PreparedStatement preparedStatement;
                long lastUseTs = Instant.now().getEpochSecond();
                Connection connection = this.connection;
                if (connection == null || (preparedStatement = connection.prepareStatement("INSERT INTO screens_config (last_use_ts, screens, active_screen) VALUES(?, ?, ?);")) == null) break block8;
                AutoCloseable autoCloseable = preparedStatement;
                Throwable throwable = null;
                try {
                    PreparedStatement it = (PreparedStatement)autoCloseable;
                    boolean bl = false;
                    it.setLong(1, lastUseTs);
                    it.setString(2, this.serialize(screens));
                    it.setLong(3, activeScreen);
                    Integer n = it.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (SQLException ex) {
                this.logger.error((Throwable)ex, ScreensConfigurationDatabaseDao::insert$lambda$1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean update(@NotNull Collection<ScreenInformation> screens, long activeScreen) {
        boolean bl;
        Intrinsics.checkNotNullParameter(screens, (String)"screens");
        if (screens.isEmpty()) {
            return false;
        }
        try {
            boolean bl2;
            PreparedStatement preparedStatement;
            long lastUseTs = Instant.now().getEpochSecond();
            Connection connection = this.connection;
            if (connection != null && (preparedStatement = connection.prepareStatement("UPDATE screens_config SET last_use_ts = ?, active_screen = ? WHERE screens = ?;")) != null) {
                AutoCloseable autoCloseable = preparedStatement;
                Throwable throwable = null;
                try {
                    PreparedStatement it = (PreparedStatement)autoCloseable;
                    boolean bl3 = false;
                    it.setLong(1, lastUseTs);
                    it.setLong(2, activeScreen);
                    it.setString(3, this.serialize(screens));
                    boolean bl4 = it.executeUpdate() != 0;
                    bl2 = bl4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (SQLException ex) {
            this.logger.error((Throwable)ex, ScreensConfigurationDatabaseDao::update$lambda$1);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean upsert(@NotNull Collection<ScreenInformation> screens, long activeScreen) {
        boolean bl;
        Intrinsics.checkNotNullParameter(screens, (String)"screens");
        if (screens.isEmpty()) {
            return false;
        }
        try {
            boolean bl2;
            PreparedStatement preparedStatement;
            long lastUseTs = Instant.now().getEpochSecond();
            Connection connection = this.connection;
            if (connection != null && (preparedStatement = connection.prepareStatement("INSERT INTO screens_config (last_use_ts, screens, active_screen) VALUES(?, ?, ?)\n                    ON CONFLICT(screens) DO UPDATE SET last_use_ts = excluded.last_use_ts, active_screen = excluded.active_screen;")) != null) {
                AutoCloseable autoCloseable = preparedStatement;
                Throwable throwable = null;
                try {
                    PreparedStatement it = (PreparedStatement)autoCloseable;
                    boolean bl3 = false;
                    it.setLong(1, lastUseTs);
                    it.setString(2, this.serialize(screens));
                    it.setLong(3, activeScreen);
                    boolean bl4 = it.executeUpdate() != 0;
                    bl2 = bl4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            } else {
                bl2 = false;
            }
            bl = bl2;
        }
        catch (SQLException ex) {
            this.logger.error((Throwable)ex, ScreensConfigurationDatabaseDao::upsert$lambda$1);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @NotNull
    public final FindScreenResult find(@NotNull Collection<ScreenInformation> screens) {
        Intrinsics.checkNotNullParameter(screens, (String)"screens");
        if (screens.isEmpty()) {
            return FindScreenResult.Companion.getNotFound();
        }
        try {
            var2_2 = this.connection;
            if (var2_2 == null || (var3_3 = var2_2.prepareStatement("SELECT id, active_screen FROM screens_config WHERE screens = ? ORDER BY last_use_ts DESC;")) == null) ** GOTO lbl-1000
            var5_5 = var3_3;
            var6_6 = null;
            try {
                it = (PreparedStatement)var5_5;
                $i$a$-use-ScreensConfigurationDatabaseDao$find$1 = false;
                it.setString(1, this.serialize(screens));
                resultSet = it.executeQuery();
                if (resultSet.next()) {
                    id = resultSet.getLong(1);
                    activeScreen = resultSet.getLong(2);
                    v0 = new FindScreenResult(id, activeScreen);
                } else {
                    v0 = FindScreenResult.Companion.getNotFound();
                }
                var7_7 = v0;
            }
            catch (Throwable var8_9) {
                var6_6 = var8_9;
                throw var8_9;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)var5_5, (Throwable)var6_6);
            }
            var4_14 = var7_7;
            if (var4_14 != null) {
                v1 = var4_14;
            } else lbl-1000:
            // 2 sources

            {
                v1 = FindScreenResult.Companion.getNotFound();
            }
            var2_2 = v1;
        }
        catch (SQLException ex) {
            this.logger.error((Throwable)ex, (Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, find$lambda$1(), ()Ljava/lang/Object;)());
            var2_2 = FindScreenResult.Companion.getNotFound();
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean delete(long id) {
        Boolean bl;
        try {
            Boolean bl2;
            AutoCloseable autoCloseable = this.connection;
            if (autoCloseable != null && (autoCloseable = autoCloseable.createStatement()) != null) {
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    Statement it = (Statement)autoCloseable2;
                    boolean bl3 = false;
                    Boolean bl4 = it.executeUpdate("DELETE FROM screens_config WHERE id = " + id + ";") > 0;
                    bl2 = bl4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            } else {
                bl2 = null;
            }
            bl = bl2;
        }
        catch (SQLException ex) {
            this.logger.error((Throwable)ex, ScreensConfigurationDatabaseDao::delete$lambda$1);
            bl = false;
        }
        Boolean bl5 = bl;
        return bl5 != null ? bl5 : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long purge() {
        Long l;
        try {
            Long l2;
            PreparedStatement preparedStatement;
            long lastUseTs = Instant.now().minus(Duration.ofDays(730L)).getEpochSecond();
            Connection connection = this.connection;
            if (connection != null && (preparedStatement = connection.prepareStatement("DELETE FROM screens_config\n                        WHERE last_use_ts < ?\n                            OR id NOT IN (\n                                SELECT id\n                                FROM screens_config\n                                ORDER BY last_use_ts DESC\n                                LIMIT ?\n                            );")) != null) {
                AutoCloseable autoCloseable = preparedStatement;
                Throwable throwable = null;
                try {
                    PreparedStatement it = (PreparedStatement)autoCloseable;
                    boolean bl = false;
                    it.setLong(1, lastUseTs);
                    it.setLong(2, 1000L);
                    Long l3 = it.executeUpdate();
                    l2 = l3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            } else {
                l2 = null;
            }
            l = l2;
        }
        catch (SQLException ex) {
            this.logger.error((Throwable)ex, ScreensConfigurationDatabaseDao::purge$lambda$1);
            l = -1L;
        }
        Long l4 = l;
        return l4 != null ? l4 : -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getRowCount() {
        long l;
        try {
            long l2;
            AutoCloseable autoCloseable = this.connection;
            if (autoCloseable != null && (autoCloseable = autoCloseable.createStatement()) != null) {
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    Statement it = (Statement)autoCloseable2;
                    boolean bl = false;
                    ResultSet resultSet = it.executeQuery("SELECT COUNT(*) FROM screens_config;");
                    long l3 = resultSet.next() ? resultSet.getLong(1) : -1L;
                    l2 = l3;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            } else {
                l2 = -1L;
            }
            l = l2;
        }
        catch (SQLException ex) {
            this.logger.error((Throwable)ex, ScreensConfigurationDatabaseDao::getRowCount$lambda$1);
            l = -1L;
        }
        return l;
    }

    private final String serialize(Collection<ScreenInformation> $this$serialize) {
        return CollectionsKt.joinToString$default((Iterable)$this$serialize, (CharSequence)"|", null, null, (int)0, null, ScreensConfigurationDatabaseDao::serialize$lambda$0, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<ScreenInformation> deserialize(String $this$deserialize) {
        void $this$mapTo$iv$iv;
        char[] cArray = new char[]{'|'};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$deserialize, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void screen;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            char[] cArray2 = new char[]{';'};
            Iterable $this$map$iv2 = StringsKt.split$default((CharSequence)((CharSequence)screen), (char[])cArray2, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map2 = false;
            Iterable iterable2 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                void it;
                String string2 = (String)item$iv$iv2;
                Collection collection2 = destination$iv$iv2;
                boolean bl2 = false;
                collection2.add(Double.parseDouble((String)it));
            }
            List list = (List)destination$iv$iv2;
            double x = ((Number)list.get(0)).doubleValue();
            double y = ((Number)list.get(1)).doubleValue();
            double w = ((Number)list.get(2)).doubleValue();
            double h = ((Number)list.get(3)).doubleValue();
            collection.add(new ScreenInformation(x, y, w, h));
        }
        return (List)destination$iv$iv;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object lambda$0$0() {
        return "Unable to create screens configuration table and/or index";
    }

    private static final Object insert$lambda$1() {
        return "Unable to insert screens configuration entry in the database";
    }

    private static final Object update$lambda$1() {
        return "Unable to update screens configuration entry in the database";
    }

    private static final Object upsert$lambda$1() {
        return "Unable to upsert screens configuration entry in the database";
    }

    private static final Object find$lambda$1() {
        return "Unable to find screens configuration entry in the database";
    }

    private static final Object delete$lambda$1() {
        return "Unable to delete screens configuration entry";
    }

    private static final Object purge$lambda$1() {
        return "Unable to delete screens configuration entry";
    }

    private static final Object getRowCount$lambda$1() {
        return "Unable to count screens configuration entries in the database";
    }

    private static final CharSequence serialize$lambda$0(ScreenInformation it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getX() + ";" + it.getY() + ";" + it.getW() + ";" + it.getH();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/merlyn/desktopapp/storage/database/ScreensConfigurationDatabaseDao$Companion;", "", "<init>", "()V", "CREATE_TABLE_SQL", "", "CREATE_INDEX_SQL", "MAX_ROWS", "", "MAX_AGE_DAYS", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

