/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.soundrecorder.permissions.mac;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.os.HostOS;
import org.merlyn.desktopapp.os.OS;
import org.merlyn.soundrecorder.permissions.mac.MacOSVersion;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0086\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/merlyn/soundrecorder/permissions/mac/GetMacOSVersion;", "", "<init>", "()V", "cache", "Lorg/merlyn/soundrecorder/permissions/mac/MacOSVersion;", "invoke", "version", "", "Companion", "app"})
public final class GetMacOSVersion {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private MacOSVersion cache;
    @NotNull
    private static final Pattern VERSIONING_PATTERN;

    @NotNull
    public final MacOSVersion invoke(@NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        if (this.cache != null) {
            MacOSVersion macOSVersion = this.cache;
            Intrinsics.checkNotNull((Object)macOSVersion);
            return macOSVersion;
        }
        Matcher matcher = VERSIONING_PATTERN.matcher(version);
        if (!matcher.matches()) {
            return MacOSVersion.Companion.getUnknown();
        }
        String majorGroup = matcher.group("major");
        String minorGroup = matcher.group("minor");
        String patchGroup = matcher.group("patch");
        String string = majorGroup;
        int major = string != null ? Integer.parseInt(string) : 0;
        String string2 = minorGroup;
        int minor = string2 != null ? Integer.parseInt(string2) : 0;
        String string3 = patchGroup;
        int patch = string3 != null ? Integer.parseInt(string3) : 0;
        MacOSVersion macOSVersion = this.cache = new MacOSVersion(major, minor, patch);
        Intrinsics.checkNotNull((Object)macOSVersion);
        return macOSVersion;
    }

    public static /* synthetic */ MacOSVersion invoke$default(GetMacOSVersion getMacOSVersion, String string, int n, Object object) {
        if ((n & 1) != 0) {
            OS $this$invoke_u24lambda_u240 = HostOS.INSTANCE.getHostOs();
            boolean bl = false;
            if (!($this$invoke_u24lambda_u240 == OS.MacOS)) {
                boolean bl2 = false;
                String string2 = "GetMacOSVersion should only be invoked on macOS devices";
                throw new IllegalStateException(string2.toString());
            }
            string = $this$invoke_u24lambda_u240.getVersion();
        }
        return getMacOSVersion.invoke(string);
    }

    static {
        Pattern pattern = Pattern.compile("^(?<major>\\d+)(?:\\.(?<minor>\\d+)(?:\\.(?<patch>\\d+)){0,1}){0,1}$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        VERSIONING_PATTERN = pattern;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/merlyn/soundrecorder/permissions/mac/GetMacOSVersion$Companion;", "", "<init>", "()V", "VERSIONING_PATTERN", "Ljava/util/regex/Pattern;", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

