/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.storage.posix;

import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.LoggingHelper;
import com.microsoft.alm.secret.TokenPair;
import com.microsoft.alm.storage.posix.internal.GnomeKeyringBackedSecureStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GnomeKeyringBackedTokenPairStore
extends GnomeKeyringBackedSecureStore<TokenPair> {
    private static final Logger logger = LoggerFactory.getLogger(GnomeKeyringBackedTokenPairStore.class);

    @Override
    protected String serialize(TokenPair tokenPair) {
        Debug.Assert((tokenPair != null ? 1 : 0) != 0, (String)"TokenPair cannot be null");
        return TokenPair.toXmlString((TokenPair)tokenPair);
    }

    @Override
    protected TokenPair deserialize(String secret) {
        Debug.Assert((secret != null ? 1 : 0) != 0, (String)"secret cannot be null");
        try {
            return TokenPair.fromXmlString((String)secret);
        }
        catch (Exception e) {
            LoggingHelper.logError((Logger)logger, (String)"Failed to deserialize the stored secret. Return null.", (Throwable)e);
            return null;
        }
    }

    @Override
    protected String getType() {
        return "OAuth2Token";
    }
}

