/*
 * Decompiled with CFR 0.152.
 */
package org.hid4java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hid4java.HidDevice;
import org.hid4java.HidException;
import org.hid4java.HidServicesSpecification;
import org.hid4java.ScanMode;
import org.hid4java.event.HidServicesListenerList;
import org.hid4java.jna.HidApi;
import org.hid4java.jna.HidDeviceInfoStructure;

class HidDeviceManager {
    private final HidServicesSpecification hidServicesSpecification;
    private final Map<String, HidDevice> attachedDevices = Collections.synchronizedMap(new HashMap());
    private final HidServicesListenerList listenerList;
    private Thread scanThread = null;

    HidDeviceManager(HidServicesListenerList listenerList, HidServicesSpecification hidServicesSpecification) throws HidException {
        this.listenerList = listenerList;
        this.hidServicesSpecification = hidServicesSpecification;
        try {
            HidApi.init();
        }
        catch (Throwable t) {
            throw new HidException("Hidapi did not initialise: " + t.getMessage(), t);
        }
    }

    public void start() {
        if (this.isScanning()) {
            return;
        }
        this.scan();
        this.configureScanThread(this.getScanRunnable());
    }

    public synchronized void stop() {
        this.stopScanThread();
        for (HidDevice hidDevice : this.attachedDevices.values()) {
            hidDevice.close();
        }
        this.attachedDevices.clear();
    }

    public synchronized void scan() {
        ArrayList<String> removeList = new ArrayList<String>();
        List<HidDevice> attachedHidDeviceList = this.getAttachedHidDevices();
        for (HidDevice hidDevice : attachedHidDeviceList) {
            if (this.attachedDevices.containsKey(hidDevice.getId())) continue;
            this.attachedDevices.put(hidDevice.getId(), hidDevice);
            this.listenerList.fireHidDeviceAttached(hidDevice);
        }
        for (Map.Entry entry : this.attachedDevices.entrySet()) {
            String deviceId = (String)entry.getKey();
            HidDevice hidDevice = (HidDevice)entry.getValue();
            if (attachedHidDeviceList.contains(hidDevice)) continue;
            removeList.add(deviceId);
            this.listenerList.fireHidDeviceDetached(this.attachedDevices.get(deviceId));
        }
        if (!removeList.isEmpty()) {
            this.attachedDevices.keySet().removeAll(removeList);
        }
    }

    public boolean isScanning() {
        return this.scanThread != null && this.scanThread.isAlive();
    }

    public List<HidDevice> getAttachedHidDevices() {
        HidDeviceInfoStructure root;
        ArrayList<HidDevice> hidDeviceList = new ArrayList<HidDevice>();
        try {
            root = HidApi.enumerateDevices(0, 0);
        }
        catch (Throwable e) {
            this.stop();
            throw new HidException("Unable to start HidApi: " + e.getMessage());
        }
        if (root != null) {
            HidDeviceInfoStructure hidDeviceInfoStructure = root;
            do {
                hidDeviceList.add(new HidDevice(hidDeviceInfoStructure, this, this.hidServicesSpecification));
            } while ((hidDeviceInfoStructure = hidDeviceInfoStructure.next()) != null);
            HidApi.freeEnumeration(root);
        }
        return hidDeviceList;
    }

    public void afterDeviceWrite() {
        if (ScanMode.SCAN_AT_FIXED_INTERVAL_WITH_PAUSE_AFTER_WRITE == this.hidServicesSpecification.getScanMode() && this.isScanning()) {
            this.stopScanThread();
            this.configureScanThread(this.getScanRunnable());
        }
    }

    public void afterDeviceDataRead(HidDevice hidDevice, byte[] dataReceived) {
        if (dataReceived != null && dataReceived.length > 0) {
            this.listenerList.fireHidDataReceived(hidDevice, dataReceived);
        }
    }

    private synchronized void stopScanThread() {
        if (this.isScanning()) {
            this.scanThread.interrupt();
            try {
                this.scanThread.join(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private synchronized void configureScanThread(Runnable scanRunnable) {
        if (this.isScanning()) {
            this.stopScanThread();
        }
        this.scanThread = new Thread(scanRunnable);
        this.scanThread.setDaemon(true);
        this.scanThread.setName("hid4java device scanner");
        this.scanThread.start();
    }

    private synchronized Runnable getScanRunnable() {
        final int scanInterval = this.hidServicesSpecification.getScanInterval();
        final int pauseInterval = this.hidServicesSpecification.getPauseInterval();
        switch (this.hidServicesSpecification.getScanMode()) {
            case NO_SCAN: {
                return new Runnable(){

                    @Override
                    public void run() {
                    }
                };
            }
            case SCAN_AT_FIXED_INTERVAL: {
                return new Runnable(){

                    @Override
                    public void run() {
                        while (true) {
                            try {
                                Thread.sleep(scanInterval);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                            HidDeviceManager.this.scan();
                        }
                    }
                };
            }
            case SCAN_AT_FIXED_INTERVAL_WITH_PAUSE_AFTER_WRITE: {
                return new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(pauseInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        while (true) {
                            try {
                                Thread.sleep(scanInterval);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                break;
                            }
                            HidDeviceManager.this.scan();
                        }
                    }
                };
            }
        }
        return null;
    }
}

