/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.fxviews;

import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.core.spacecontextservice.model.LocalizationContext;
import org.merlyn.sharedui.avatarmanager.statedata.SoloAvatarStateData;
import org.merlyn.sharedui.fxviews.anims.ContainerAnimation;
import org.merlyn.sharedui.fxviews.avatar.AvatarViewPane;
import org.merlyn.sharedui.fxviews.classnotes.ClassNotesViewPane;
import org.merlyn.sharedui.fxviews.models.WidgetState;
import org.merlyn.sharedui.fxviews.stickynotifs.StickyNotificationViewPane;
import org.merlyn.sharedui.fxviews.utils.SoloMeasurable;
import org.merlyn.sharedui.fxviews.widget.ToolbarPopupMenu;
import org.merlyn.sharedui.fxviews.widget.WidgetContainerPane;
import org.merlyn.sharedui.fxviews.widget.WidgetListener;
import org.merlyn.sharedui.viewmodels.StickyNotificationViewState;
import org.merlyn.sharedui.viewmodels.ToolbarViewState;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0001ABU\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00126\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000e\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020+J\u000e\u0010,\u001a\u00020\u000f2\u0006\u0010-\u001a\u00020.J\u000e\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u000f2\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u000207J\u0016\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020<J\b\u0010=\u001a\u00020\u000fH\u0002J\u0010\u0010>\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020\u001eH\u0002J\u0010\u0010@\u001a\u00020\u000f2\u0006\u0010?\u001a\u00020\u001eH\u0002R>\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u001d\u001a\u00020\u001e@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&\u00a8\u0006B"}, d2={"Lorg/merlyn/sharedui/fxviews/SoloContainer;", "Ljavafx/scene/layout/AnchorPane;", "Lorg/merlyn/sharedui/fxviews/utils/SoloMeasurable;", "localizationContextFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lorg/merlyn/core/spacecontextservice/model/LocalizationContext;", "viewModelScope", "Lkotlinx/coroutines/CoroutineScope;", "onResizeRequest", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "w", "h", "", "<init>", "(Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function2;)V", "avatarViewPane", "Lorg/merlyn/sharedui/fxviews/avatar/AvatarViewPane;", "avatarContainerAnimation", "Lorg/merlyn/sharedui/fxviews/anims/ContainerAnimation;", "widgetContainerPane", "Lorg/merlyn/sharedui/fxviews/widget/WidgetContainerPane;", "stickyNotificationViewPane", "Lorg/merlyn/sharedui/fxviews/stickynotifs/StickyNotificationViewPane;", "stickyNotificationContainerAnimation", "classNotesViewPane", "Lorg/merlyn/sharedui/fxviews/classnotes/ClassNotesViewPane;", "value", "Lorg/merlyn/sharedui/fxviews/SoloContainer$ContainerHeight;", "containerHeights", "setContainerHeights", "(Lorg/merlyn/sharedui/fxviews/SoloContainer$ContainerHeight;)V", "toolbarPopupMenu", "Lorg/merlyn/sharedui/fxviews/widget/ToolbarPopupMenu;", "calculatedWidth", "getCalculatedWidth", "()D", "calculatedHeight", "getCalculatedHeight", "changeState", "avatarState", "Lorg/merlyn/sharedui/avatarmanager/statedata/SoloAvatarStateData;", "changeWidgetState", "widgetState", "Lorg/merlyn/sharedui/fxviews/models/WidgetState;", "setWidgetListener", "widgetListener", "Lorg/merlyn/sharedui/fxviews/widget/WidgetListener;", "setToolbarState", "toolbarViewState", "Lorg/merlyn/sharedui/viewmodels/ToolbarViewState;", "setStickyNotificationState", "stickyNotificationViewState", "Lorg/merlyn/sharedui/viewmodels/StickyNotificationViewState;", "setClassNotesState", "isEnabled", "", "text", "", "makeResizeRequest", "onContainerSizeChanged", "heights", "enableDisableViews", "ContainerHeight", "sharedui"})
public final class SoloContainer
extends AnchorPane
implements SoloMeasurable {
    @NotNull
    private final Function2<Double, Double, Unit> onResizeRequest;
    @NotNull
    private final AvatarViewPane avatarViewPane;
    @NotNull
    private final ContainerAnimation avatarContainerAnimation;
    @NotNull
    private final WidgetContainerPane widgetContainerPane;
    @NotNull
    private final StickyNotificationViewPane stickyNotificationViewPane;
    @NotNull
    private final ContainerAnimation stickyNotificationContainerAnimation;
    @NotNull
    private final ClassNotesViewPane classNotesViewPane;
    @NotNull
    private ContainerHeight containerHeights;
    @NotNull
    private final ToolbarPopupMenu toolbarPopupMenu;

    public SoloContainer(@NotNull StateFlow<LocalizationContext> localizationContextFlow, @NotNull CoroutineScope viewModelScope, @NotNull Function2<? super Double, ? super Double, Unit> onResizeRequest) {
        Intrinsics.checkNotNullParameter(localizationContextFlow, (String)"localizationContextFlow");
        Intrinsics.checkNotNullParameter((Object)viewModelScope, (String)"viewModelScope");
        Intrinsics.checkNotNullParameter(onResizeRequest, (String)"onResizeRequest");
        this.onResizeRequest = onResizeRequest;
        this.avatarViewPane = new AvatarViewPane((Function2<? super Double, ? super Double, Unit>)((Function2)(arg_0, arg_1) -> SoloContainer.avatarViewPane$lambda$0(this, arg_0, arg_1)), (Function1<? super Double, Unit>)((Function1)arg_0 -> SoloContainer.avatarViewPane$lambda$1(this, arg_0)));
        this.avatarContainerAnimation = new ContainerAnimation((Node)this.avatarViewPane);
        this.widgetContainerPane = new WidgetContainerPane(localizationContextFlow, viewModelScope, (Function2<? super Double, ? super Double, Unit>)((Function2)(arg_0, arg_1) -> SoloContainer.widgetContainerPane$lambda$0(this, arg_0, arg_1)), (Function2<? super Double, ? super Double, Unit>)((Function2)(arg_0, arg_1) -> SoloContainer.widgetContainerPane$lambda$1(this, arg_0, arg_1)));
        this.stickyNotificationViewPane = new StickyNotificationViewPane((Function2<? super Double, ? super Double, Unit>)((Function2)(arg_0, arg_1) -> SoloContainer.stickyNotificationViewPane$lambda$0(this, arg_0, arg_1)), (Function1<? super Double, Unit>)((Function1)arg_0 -> SoloContainer.stickyNotificationViewPane$lambda$1(this, arg_0)));
        this.stickyNotificationContainerAnimation = new ContainerAnimation((Node)this.stickyNotificationViewPane);
        this.classNotesViewPane = new ClassNotesViewPane((Function2<? super Double, ? super Double, Unit>)((Function2)(arg_0, arg_1) -> SoloContainer.classNotesViewPane$lambda$0(this, arg_0, arg_1)), (Function1<? super Double, Unit>)((Function1)arg_0 -> SoloContainer.classNotesViewPane$lambda$1(this, arg_0)));
        this.containerHeights = new ContainerHeight(0.0, 0.0, 0.0, 0.0);
        this.toolbarPopupMenu = new ToolbarPopupMenu();
        this.setBackground(Background.EMPTY);
        AnchorPane.setTopAnchor((Node)((Node)this.avatarViewPane), (Double)0.0);
        AnchorPane.setRightAnchor((Node)((Node)this.avatarViewPane), (Double)0.0);
        AnchorPane.setTopAnchor((Node)((Node)this.widgetContainerPane), (Double)0.0);
        AnchorPane.setRightAnchor((Node)((Node)this.widgetContainerPane), (Double)0.0);
        AnchorPane.setTopAnchor((Node)((Node)this.stickyNotificationViewPane), (Double)0.0);
        AnchorPane.setRightAnchor((Node)((Node)this.stickyNotificationViewPane), (Double)0.0);
        AnchorPane.setTopAnchor((Node)((Node)this.classNotesViewPane), (Double)0.0);
        AnchorPane.setRightAnchor((Node)((Node)this.classNotesViewPane), (Double)0.0);
        AnchorPane.setTopAnchor((Node)((Node)this.toolbarPopupMenu), (Double)16.0);
        AnchorPane.setRightAnchor((Node)((Node)this.toolbarPopupMenu), (Double)16.0);
        this.toolbarPopupMenu.setVisible(false);
        this.toolbarPopupMenu.visibleProperty().addListener((arg_0, arg_1, arg_2) -> SoloContainer._init_$lambda$1((arg_0, arg_1, arg_2) -> SoloContainer._init_$lambda$0(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        Object[] objectArray = new Node[]{this.avatarViewPane, this.stickyNotificationViewPane, this.widgetContainerPane, this.toolbarPopupMenu, this.classNotesViewPane};
        this.getChildren().addAll(objectArray);
    }

    private final void setContainerHeights(ContainerHeight value) {
        if (!Intrinsics.areEqual((Object)this.containerHeights, (Object)value)) {
            this.containerHeights = value;
            this.onContainerSizeChanged(this.containerHeights);
        }
    }

    @Override
    public double getCalculatedWidth() {
        Object[] objectArray = new Double[]{this.avatarViewPane.getCalculatedWidth(), this.widgetContainerPane.getCalculatedWidth(), this.toolbarPopupMenu.getCalculatedWidth(), this.stickyNotificationViewPane.getCalculatedWidth(), this.classNotesViewPane.getCalculatedWidth()};
        return CollectionsKt.maxOrThrow((Iterable)CollectionsKt.listOf((Object[])objectArray));
    }

    @Override
    public double getCalculatedHeight() {
        return this.widgetContainerPane.getCalculatedHeight() + Math.max(this.avatarViewPane.getCalculatedHeight(), this.toolbarPopupMenu.getCalculatedHeight()) + this.stickyNotificationViewPane.getCalculatedHeight() + this.classNotesViewPane.getCalculatedHeight();
    }

    public final void changeState(@NotNull SoloAvatarStateData avatarState) {
        Intrinsics.checkNotNullParameter((Object)avatarState, (String)"avatarState");
        this.avatarViewPane.changeState(avatarState);
    }

    public final void changeWidgetState(@NotNull WidgetState widgetState) {
        Intrinsics.checkNotNullParameter((Object)widgetState, (String)"widgetState");
        this.widgetContainerPane.setWidgetState(widgetState);
        this.toolbarPopupMenu.setVisible(widgetState.isToolbarPopupVisible());
    }

    public final void setWidgetListener(@NotNull WidgetListener widgetListener) {
        Intrinsics.checkNotNullParameter((Object)widgetListener, (String)"widgetListener");
        this.widgetContainerPane.setListener(widgetListener);
        this.toolbarPopupMenu.setListener(widgetListener);
        this.avatarViewPane.setListener(widgetListener);
        this.stickyNotificationViewPane.setListener(widgetListener);
    }

    public final void setToolbarState(@NotNull ToolbarViewState toolbarViewState) {
        Intrinsics.checkNotNullParameter((Object)toolbarViewState, (String)"toolbarViewState");
        this.toolbarPopupMenu.setMenuItems(toolbarViewState.getMenuItems());
        this.widgetContainerPane.setUserLoginStatus(toolbarViewState.isLoggedIn(), toolbarViewState.isUserSubscriptionValid());
        this.makeResizeRequest();
    }

    public final void setStickyNotificationState(@NotNull StickyNotificationViewState stickyNotificationViewState) {
        Intrinsics.checkNotNullParameter((Object)stickyNotificationViewState, (String)"stickyNotificationViewState");
        this.stickyNotificationViewPane.setNotifications(stickyNotificationViewState);
    }

    public final void setClassNotesState(boolean isEnabled, @NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.classNotesViewPane.setState(isEnabled, text);
    }

    private final void makeResizeRequest() {
        Platform.runLater(() -> SoloContainer.makeResizeRequest$lambda$0(this));
    }

    private final void onContainerSizeChanged(ContainerHeight heights) {
        this.avatarContainerAnimation.start(heights.getAvatarPosition(), (Function0<Unit>)((Function0)() -> SoloContainer.onContainerSizeChanged$lambda$0(this)));
        ContainerAnimation.start$default(this.stickyNotificationContainerAnimation, heights.getStickNotificationPosition(), null, 2, null);
        this.classNotesViewPane.setTranslateY(heights.getWidgetContainerH());
        this.toolbarPopupMenu.setTranslateY(heights.getWidgetContainerH());
        this.enableDisableViews(heights);
    }

    private final void enableDisableViews(ContainerHeight heights) {
        this.widgetContainerPane.setDisable(!heights.isWidgetContainerEnabled());
        this.avatarViewPane.setDisable(!heights.isAvatarContainerEnabled());
        this.stickyNotificationViewPane.setDisable(!heights.isStickyNotificationContainerEnabled());
        this.classNotesViewPane.setDisable(!heights.isClassNotesContainerEnabled());
    }

    private static final Unit avatarViewPane$lambda$0(SoloContainer this$0, double d, double d2) {
        this$0.makeResizeRequest();
        return Unit.INSTANCE;
    }

    private static final Unit avatarViewPane$lambda$1(SoloContainer this$0, double h) {
        this$0.setContainerHeights(ContainerHeight.copy$default(this$0.containerHeights, 0.0, h, 0.0, 0.0, 13, null));
        return Unit.INSTANCE;
    }

    private static final Unit widgetContainerPane$lambda$0(SoloContainer this$0, double d, double d2) {
        this$0.makeResizeRequest();
        return Unit.INSTANCE;
    }

    private static final Unit widgetContainerPane$lambda$1(SoloContainer this$0, double d, double h) {
        this$0.setContainerHeights(ContainerHeight.copy$default(this$0.containerHeights, h, 0.0, 0.0, 0.0, 14, null));
        return Unit.INSTANCE;
    }

    private static final Unit stickyNotificationViewPane$lambda$0(SoloContainer this$0, double d, double d2) {
        this$0.makeResizeRequest();
        return Unit.INSTANCE;
    }

    private static final Unit stickyNotificationViewPane$lambda$1(SoloContainer this$0, double h) {
        this$0.setContainerHeights(ContainerHeight.copy$default(this$0.containerHeights, 0.0, 0.0, h, 0.0, 11, null));
        return Unit.INSTANCE;
    }

    private static final Unit classNotesViewPane$lambda$0(SoloContainer this$0, double d, double d2) {
        this$0.makeResizeRequest();
        return Unit.INSTANCE;
    }

    private static final Unit classNotesViewPane$lambda$1(SoloContainer this$0, double h) {
        this$0.setContainerHeights(ContainerHeight.copy$default(this$0.containerHeights, 0.0, 0.0, 0.0, h, 7, null));
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$0(SoloContainer this$0, ObservableValue observableValue, Boolean bl, Boolean bl2) {
        this$0.makeResizeRequest();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final void makeResizeRequest$lambda$0(SoloContainer this$0) {
        this$0.onResizeRequest.invoke((Object)this$0.getCalculatedWidth(), (Object)this$0.getCalculatedHeight());
    }

    private static final Unit onContainerSizeChanged$lambda$0(SoloContainer this$0) {
        this$0.makeResizeRequest();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00132\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\"H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0011\u0010\u000e\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\nR\u0011\u0010\u0010\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\nR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0011\u0010\u0016\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0014\u00a8\u0006#"}, d2={"Lorg/merlyn/sharedui/fxviews/SoloContainer$ContainerHeight;", "", "widgetContainerH", "", "avatarContainerH", "stickyNotificationContainerH", "classNotesContainerH", "<init>", "(DDDD)V", "getWidgetContainerH", "()D", "getAvatarContainerH", "getStickyNotificationContainerH", "getClassNotesContainerH", "avatarPosition", "getAvatarPosition", "stickNotificationPosition", "getStickNotificationPosition", "isAvatarContainerEnabled", "", "()Z", "isWidgetContainerEnabled", "isStickyNotificationContainerEnabled", "isClassNotesContainerEnabled", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "sharedui"})
    private static final class ContainerHeight {
        private final double widgetContainerH;
        private final double avatarContainerH;
        private final double stickyNotificationContainerH;
        private final double classNotesContainerH;

        public ContainerHeight(double widgetContainerH, double avatarContainerH, double stickyNotificationContainerH, double classNotesContainerH) {
            this.widgetContainerH = widgetContainerH;
            this.avatarContainerH = avatarContainerH;
            this.stickyNotificationContainerH = stickyNotificationContainerH;
            this.classNotesContainerH = classNotesContainerH;
        }

        public final double getWidgetContainerH() {
            return this.widgetContainerH;
        }

        public final double getAvatarContainerH() {
            return this.avatarContainerH;
        }

        public final double getStickyNotificationContainerH() {
            return this.stickyNotificationContainerH;
        }

        public final double getClassNotesContainerH() {
            return this.classNotesContainerH;
        }

        public final double getAvatarPosition() {
            return this.widgetContainerH + this.stickyNotificationContainerH;
        }

        public final double getStickNotificationPosition() {
            return this.widgetContainerH;
        }

        public final boolean isAvatarContainerEnabled() {
            return this.avatarContainerH > 0.0;
        }

        public final boolean isWidgetContainerEnabled() {
            return this.widgetContainerH > 0.0;
        }

        public final boolean isStickyNotificationContainerEnabled() {
            return this.stickyNotificationContainerH > 0.0;
        }

        public final boolean isClassNotesContainerEnabled() {
            return this.classNotesContainerH > 0.0;
        }

        public final double component1() {
            return this.widgetContainerH;
        }

        public final double component2() {
            return this.avatarContainerH;
        }

        public final double component3() {
            return this.stickyNotificationContainerH;
        }

        public final double component4() {
            return this.classNotesContainerH;
        }

        @NotNull
        public final ContainerHeight copy(double widgetContainerH, double avatarContainerH, double stickyNotificationContainerH, double classNotesContainerH) {
            return new ContainerHeight(widgetContainerH, avatarContainerH, stickyNotificationContainerH, classNotesContainerH);
        }

        public static /* synthetic */ ContainerHeight copy$default(ContainerHeight containerHeight, double d, double d2, double d3, double d4, int n, Object object) {
            if ((n & 1) != 0) {
                d = containerHeight.widgetContainerH;
            }
            if ((n & 2) != 0) {
                d2 = containerHeight.avatarContainerH;
            }
            if ((n & 4) != 0) {
                d3 = containerHeight.stickyNotificationContainerH;
            }
            if ((n & 8) != 0) {
                d4 = containerHeight.classNotesContainerH;
            }
            return containerHeight.copy(d, d2, d3, d4);
        }

        @NotNull
        public String toString() {
            return "ContainerHeight(widgetContainerH=" + this.widgetContainerH + ", avatarContainerH=" + this.avatarContainerH + ", stickyNotificationContainerH=" + this.stickyNotificationContainerH + ", classNotesContainerH=" + this.classNotesContainerH + ")";
        }

        public int hashCode() {
            int result = Double.hashCode(this.widgetContainerH);
            result = result * 31 + Double.hashCode(this.avatarContainerH);
            result = result * 31 + Double.hashCode(this.stickyNotificationContainerH);
            result = result * 31 + Double.hashCode(this.classNotesContainerH);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ContainerHeight)) {
                return false;
            }
            ContainerHeight containerHeight = (ContainerHeight)other;
            if (Double.compare(this.widgetContainerH, containerHeight.widgetContainerH) != 0) {
                return false;
            }
            if (Double.compare(this.avatarContainerH, containerHeight.avatarContainerH) != 0) {
                return false;
            }
            if (Double.compare(this.stickyNotificationContainerH, containerHeight.stickyNotificationContainerH) != 0) {
                return false;
            }
            return Double.compare(this.classNotesContainerH, containerHeight.classNotesContainerH) == 0;
        }
    }
}

