/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.screenselection;

import com.sun.javafx.tk.FontLoader;
import com.sun.javafx.tk.Toolkit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.sharedui.res.ColorsKt;
import org.merlyn.sharedui.screenselection.ScreenRepresentation;
import org.merlyn.sharedui.screenselection.ScreensLayoutRepresentation;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u0014H\u0002JH\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020!2\u0006\u0010$\u001a\u00020!2\u0006\u0010%\u001a\u00020\f2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002R0\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR$\u0010\r\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R.\u0010\u0012\u001a\u0016\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u0013j\u0004\u0018\u0001`\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/merlyn/sharedui/screenselection/ScreensLayoutView;", "Ljavafx/scene/canvas/Canvas;", "<init>", "()V", "value", "", "Lorg/merlyn/sharedui/screenselection/ScreenRepresentation;", "screenRepresentations", "getScreenRepresentations", "()Ljava/util/List;", "setScreenRepresentations", "(Ljava/util/List;)V", "", "selectedScreenIndex", "getSelectedScreenIndex", "()I", "setSelectedScreenIndex", "(I)V", "onScreenClicked", "Lkotlin/Function1;", "", "Lorg/merlyn/sharedui/screenselection/OnScreenClicked;", "getOnScreenClicked", "()Lkotlin/jvm/functions/Function1;", "setOnScreenClicked", "(Lkotlin/jvm/functions/Function1;)V", "screensLayoutRepresentation", "Lorg/merlyn/sharedui/screenselection/ScreensLayoutRepresentation;", "draw", "drawScreen", "gc", "Ljavafx/scene/canvas/GraphicsContext;", "x", "", "y", "width", "height", "fontHeight", "text", "", "selected", "", "sharedui"})
@SourceDebugExtension(value={"SMAP\nScreensLayoutView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScreensLayoutView.kt\norg/merlyn/sharedui/screenselection/ScreensLayoutView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1#2:177\n1878#3,3:178\n785#3:181\n796#3:182\n1878#3,2:183\n797#3,2:185\n1880#3:187\n799#3:188\n1869#3,2:189\n785#3:191\n796#3:192\n1878#3,2:193\n797#3,2:195\n1880#3:197\n799#3:198\n1869#3,2:199\n*S KotlinDebug\n*F\n+ 1 ScreensLayoutView.kt\norg/merlyn/sharedui/screenselection/ScreensLayoutView\n*L\n105#1:178,3\n117#1:181\n117#1:182\n117#1:183,2\n117#1:185,2\n117#1:187\n117#1:188\n118#1:189,2\n131#1:191\n131#1:192\n131#1:193,2\n131#1:195,2\n131#1:197\n131#1:198\n132#1:199,2\n*E\n"})
public final class ScreensLayoutView
extends Canvas {
    @NotNull
    private List<ScreenRepresentation> screenRepresentations = CollectionsKt.emptyList();
    private int selectedScreenIndex = -1;
    @Nullable
    private Function1<? super Integer, Unit> onScreenClicked;
    @NotNull
    private List<ScreensLayoutRepresentation> screensLayoutRepresentation = CollectionsKt.emptyList();

    public ScreensLayoutView() {
        this.widthProperty().addListener((arg_0, arg_1, arg_2) -> ScreensLayoutView._init_$lambda$1((arg_0, arg_1, arg_2) -> ScreensLayoutView._init_$lambda$0(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        this.heightProperty().addListener((arg_0, arg_1, arg_2) -> ScreensLayoutView._init_$lambda$3((arg_0, arg_1, arg_2) -> ScreensLayoutView._init_$lambda$2(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        this.setOnMouseClicked(new EventHandler(){

            /*
             * WARNING - void declaration
             */
            public final void handle(MouseEvent event) {
                void $this$forEach$iv;
                Iterable iterable = CollectionsKt.reversed((Iterable)screensLayoutRepresentation);
                ScreensLayoutView screensLayoutView = this;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ScreensLayoutRepresentation it = (ScreensLayoutRepresentation)element$iv;
                    boolean bl = false;
                    if (!(event.getX() >= it.getX()) || !(event.getX() < it.getX() + it.getWidth()) || !(event.getY() >= it.getY()) || !(event.getY() < it.getY() + it.getHeight())) continue;
                    screensLayoutView.setSelectedScreenIndex(it.getScreenRepresentationIndex());
                    Function1<Integer, Unit> function1 = screensLayoutView.getOnScreenClicked();
                    if (function1 == null) continue;
                    function1.invoke((Object)it.getScreenRepresentationIndex());
                }
                event.consume();
            }
        });
    }

    @NotNull
    public final List<ScreenRepresentation> getScreenRepresentations() {
        return this.screenRepresentations;
    }

    public final void setScreenRepresentations(@NotNull List<ScreenRepresentation> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.screenRepresentations = value;
        this.draw();
    }

    public final int getSelectedScreenIndex() {
        return this.selectedScreenIndex;
    }

    public final void setSelectedScreenIndex(int value) {
        this.selectedScreenIndex = value;
        this.draw();
    }

    @Nullable
    public final Function1<Integer, Unit> getOnScreenClicked() {
        return this.onScreenClicked;
    }

    public final void setOnScreenClicked(@Nullable Function1<? super Integer, Unit> function1) {
        this.onScreenClicked = function1;
    }

    /*
     * WARNING - void declaration
     */
    private final void draw() {
        Iterable $this$forEach$iv;
        int index$iv$iv;
        int n;
        Iterable $this$filterIndexedTo$iv$iv;
        Iterable $this$filterIndexed$iv;
        double w = this.getWidth();
        double h = this.getHeight();
        this.getGraphicsContext2D().clearRect(0.0, 0.0, w, h);
        if (this.screenRepresentations.isEmpty()) {
            return;
        }
        Iterator iterator = ((Iterable)this.screenRepresentations).iterator();
        if (!iterator.hasNext()) {
            throw new NoSuchElementException();
        }
        ScreenRepresentation it = (ScreenRepresentation)iterator.next();
        boolean bl = false;
        double d = it.getX();
        while (iterator.hasNext()) {
            ScreenRepresentation it2 = (ScreenRepresentation)iterator.next();
            $i$a$-minOf-ScreensLayoutView$draw$minX$1 = false;
            double d2 = it2.getX();
            d = Math.min(d, d2);
        }
        double minX = d;
        Iterator iterator2 = ((Iterable)this.screenRepresentations).iterator();
        if (!iterator2.hasNext()) {
            throw new NoSuchElementException();
        }
        ScreenRepresentation it3 = (ScreenRepresentation)iterator2.next();
        boolean bl2 = false;
        double it2 = it3.getY();
        while (iterator2.hasNext()) {
            ScreenRepresentation it4 = (ScreenRepresentation)iterator2.next();
            $i$a$-minOf-ScreensLayoutView$draw$minY$1 = false;
            double d3 = it4.getY();
            it2 = Math.min(it2, d3);
        }
        double minY = it2;
        Iterator iterator3 = ((Iterable)this.screenRepresentations).iterator();
        if (!iterator3.hasNext()) {
            throw new NoSuchElementException();
        }
        ScreenRepresentation it22 = (ScreenRepresentation)iterator3.next();
        boolean bl3 = false;
        double it4 = it22.getX() + it22.getWidth();
        while (iterator3.hasNext()) {
            ScreenRepresentation it5 = (ScreenRepresentation)iterator3.next();
            $i$a$-maxOf-ScreensLayoutView$draw$maxX$1 = false;
            double d4 = it5.getX() + it5.getWidth();
            it4 = Math.max(it4, d4);
        }
        double maxX = it4;
        Iterator iterator4 = ((Iterable)this.screenRepresentations).iterator();
        if (!iterator4.hasNext()) {
            throw new NoSuchElementException();
        }
        ScreenRepresentation it32 = (ScreenRepresentation)iterator4.next();
        boolean bl4 = false;
        double it5 = it32.getY() + it32.getHeight();
        while (iterator4.hasNext()) {
            ScreenRepresentation it6 = (ScreenRepresentation)iterator4.next();
            $i$a$-maxOf-ScreensLayoutView$draw$maxY$1 = false;
            double d5 = it6.getY() + it6.getHeight();
            it5 = Math.max(it5, d5);
        }
        double maxY = it5;
        double boxesWidth = maxX - minX;
        double boxesHeight = maxY - minY;
        double scaleX = w / boxesWidth;
        double scaleY = h / boxesHeight;
        double scale = Math.min(scaleX, scaleY) * 0.9;
        double offsetX = (w - boxesWidth * scale) / 2.0;
        double offsetY = (h - boxesHeight * scale) / 2.0;
        this.getGraphicsContext2D().setFill((Paint)Color.LIGHTGRAY);
        this.getGraphicsContext2D().fillRect(0.0, 0.0, w, h);
        this.getGraphicsContext2D().setStroke((Paint)Color.BLACK);
        this.getGraphicsContext2D().setLineWidth(2.0);
        this.getGraphicsContext2D().setFill((Paint)Color.WHITE);
        this.getGraphicsContext2D().setFont(Font.font((double)24.0));
        this.getGraphicsContext2D().setTextAlign(TextAlignment.CENTER);
        FontLoader fontLoader = Toolkit.getToolkit().getFontLoader();
        Intrinsics.checkNotNullExpressionValue((Object)fontLoader, (String)"getFontLoader(...)");
        FontLoader fontLoader2 = fontLoader;
        int fontHeight = fontLoader2.getFontMetrics(this.getGraphicsContext2D().getFont()).getBaseline();
        List screensLayoutRepresentation = new ArrayList();
        Iterable $this$forEachIndexed$iv = this.screenRepresentations;
        boolean $i$f$forEachIndexed = false;
        int index$iv22 = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void screenRepresentation;
            int n2;
            if ((n2 = index$iv22++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ScreenRepresentation screenRepresentation2 = (ScreenRepresentation)item$iv;
            int index = n2;
            boolean bl5 = false;
            double x = offsetX + (screenRepresentation.getX() - minX) * scale;
            double y = offsetY + (screenRepresentation.getY() - minY) * scale;
            double boxWidth = screenRepresentation.getWidth() * scale;
            double boxHeight = screenRepresentation.getHeight() * scale;
            screensLayoutRepresentation.add(new ScreensLayoutRepresentation(index, x, y, boxWidth, boxHeight, screenRepresentation.getText()));
        }
        $this$forEachIndexed$iv = screensLayoutRepresentation;
        boolean $i$f$filterIndexed = false;
        void index$iv22 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed2 = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object y = item$iv$iv$iv;
            index$iv$iv = n;
            boolean bl6 = false;
            ScreensLayoutRepresentation cfr_ignored_0 = (ScreensLayoutRepresentation)element$iv$iv;
            int index = index$iv$iv;
            boolean bl7 = false;
            if (!(index != this.selectedScreenIndex)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIndexed$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScreensLayoutRepresentation screen = (ScreensLayoutRepresentation)element$iv;
            boolean bl8 = false;
            GraphicsContext graphicsContext = this.getGraphicsContext2D();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsContext, (String)"getGraphicsContext2D(...)");
            this.drawScreen(graphicsContext, screen.getX(), screen.getY(), screen.getWidth(), screen.getHeight(), fontHeight, screen.getText(), false);
        }
        $this$forEach$iv = screensLayoutRepresentation;
        $i$f$filterIndexed = false;
        $this$filterIndexedTo$iv$iv = $this$filterIndexed$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterIndexedTo = false;
        Iterable $this$forEachIndexed$iv$iv$iv2 = $this$filterIndexedTo$iv$iv;
        $i$f$forEachIndexed2 = false;
        index$iv$iv$iv = 0;
        Iterator iterator5 = $this$forEachIndexed$iv$iv$iv2.iterator();
        while (iterator5.hasNext()) {
            Object item$iv$iv$iv = iterator5.next();
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object element$iv$iv = item$iv$iv$iv;
            index$iv$iv = n;
            boolean bl9 = false;
            ScreensLayoutRepresentation cfr_ignored_1 = (ScreensLayoutRepresentation)element$iv$iv;
            int index = index$iv$iv;
            boolean bl10 = false;
            if (!(index == this.selectedScreenIndex)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIndexed$iv = (List)destination$iv$iv;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScreensLayoutRepresentation screen = (ScreensLayoutRepresentation)element$iv;
            boolean bl11 = false;
            GraphicsContext graphicsContext = this.getGraphicsContext2D();
            Intrinsics.checkNotNullExpressionValue((Object)graphicsContext, (String)"getGraphicsContext2D(...)");
            this.drawScreen(graphicsContext, screen.getX(), screen.getY(), screen.getWidth(), screen.getHeight(), fontHeight, screen.getText(), true);
        }
        this.screensLayoutRepresentation = screensLayoutRepresentation;
    }

    private final void drawScreen(GraphicsContext gc, double x, double y, double width, double height, int fontHeight, String text, boolean selected) {
        gc.fillRect(x, y, width, height);
        if (!selected) {
            gc.setStroke((Paint)Color.BLACK);
            gc.setLineWidth(2.0);
        } else {
            gc.setStroke((Paint)ColorsKt.toColor("#FF7D00"));
            gc.setLineWidth(5.0);
        }
        gc.strokeRect(x, y, width, height);
        double textX = x + width / 2.0;
        double textY = y + height / 2.0 - (double)fontHeight / 2.0;
        gc.setStroke((Paint)Color.BLACK);
        gc.setLineWidth(2.0);
        gc.strokeText(text, textX, textY);
    }

    private static final Unit _init_$lambda$0(ScreensLayoutView this$0, ObservableValue observableValue, Number number, Number number2) {
        this$0.draw();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    private static final Unit _init_$lambda$2(ScreensLayoutView this$0, ObservableValue observableValue, Number number, Number number2) {
        this$0.draw();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$3(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }
}

