/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.utils.win32;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.WinDef;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.sharedui.utils.win32.Win32Locator;
import org.merlyn.sharedui.utils.win32.WindowHandle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\t\u001a\u0004\u0018\u00010\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\f0\u000bJ \u0010\t\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/merlyn/sharedui/utils/win32/WindowsWindowManager;", "Lorg/merlyn/sharedui/utils/win32/Win32Locator;", "<init>", "()V", "windows", "", "Lorg/merlyn/sharedui/utils/win32/WindowHandle;", "getWindows", "()Ljava/util/Set;", "find", "predicate", "Lkotlin/Function1;", "", "name", "", "className", "sharedui"})
public final class WindowsWindowManager
implements Win32Locator {
    @NotNull
    public static final WindowsWindowManager INSTANCE = new WindowsWindowManager();

    private WindowsWindowManager() {
    }

    @NotNull
    public final Set<WindowHandle> getWindows() {
        Set windows = new LinkedHashSet();
        this.getUser32().EnumWindows((arg_0, arg_1) -> WindowsWindowManager._get_windows_$lambda$0(windows, arg_0, arg_1), null);
        return CollectionsKt.toSet((Iterable)windows);
    }

    @Nullable
    public final WindowHandle find(@NotNull Function1<? super WindowHandle, Boolean> predicate) {
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Ref.ObjectRef result = new Ref.ObjectRef();
        this.getUser32().EnumWindows((arg_0, arg_1) -> WindowsWindowManager.find$lambda$0(predicate, result, arg_0, arg_1), null);
        return (WindowHandle)result.element;
    }

    @Nullable
    public final WindowHandle find(@Nullable String name, @Nullable String className) {
        if (name == null && className == null) {
            return null;
        }
        WinDef.HWND hWND = this.getUser32().FindWindow(className, name);
        if (hWND == null) {
            return null;
        }
        WinDef.HWND result = hWND;
        return new WindowHandle(result);
    }

    public static /* synthetic */ WindowHandle find$default(WindowsWindowManager windowsWindowManager, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            string2 = null;
        }
        return windowsWindowManager.find(string, string2);
    }

    private static final boolean _get_windows_$lambda$0(Set $windows, WinDef.HWND win, Pointer pointer) {
        Intrinsics.checkNotNull((Object)win);
        $windows.add(new WindowHandle(win));
        return true;
    }

    private static final boolean find$lambda$0(Function1 $predicate, Ref.ObjectRef $result, WinDef.HWND win, Pointer pointer) {
        boolean bl;
        Intrinsics.checkNotNull((Object)win);
        WindowHandle info = new WindowHandle(win);
        if (((Boolean)$predicate.invoke((Object)info)).booleanValue()) {
            $result.element = info;
            bl = false;
        } else {
            bl = true;
        }
        return bl;
    }
}

