/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.diagnostics.checkers;

import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.diagnostics.Checker;
import org.merlyn.diagnostics.CheckerKt;
import org.merlyn.diagnostics.checkers.UserData;
import org.merlyn.diagnostics.checkers.UserProvider;
import org.merlyn.diagnostics.models.CheckResult;
import org.merlyn.diagnostics.models.CheckerConfig;
import org.merlyn.diagnostics.models.CheckerMessages;
import org.merlyn.diagnostics.models.Help;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/merlyn/diagnostics/checkers/MerlynUserChecker;", "Lorg/merlyn/diagnostics/Checker;", "userProvider", "Lorg/merlyn/diagnostics/checkers/UserProvider;", "<init>", "(Lorg/merlyn/diagnostics/checkers/UserProvider;)V", "check", "Lorg/merlyn/diagnostics/models/CheckResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configuration", "Lorg/merlyn/diagnostics/models/CheckerConfig;", "diagnostics"})
@SourceDebugExtension(value={"SMAP\nMerlynUserChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MerlynUserChecker.kt\norg/merlyn/diagnostics/checkers/MerlynUserChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,88:1\n1557#2:89\n1628#2,3:90\n28#3,4:93\n*S KotlinDebug\n*F\n+ 1 MerlynUserChecker.kt\norg/merlyn/diagnostics/checkers/MerlynUserChecker\n*L\n47#1:89\n47#1:90,3\n80#1:93,4\n*E\n"})
public final class MerlynUserChecker
implements Checker {
    @NotNull
    private final UserProvider userProvider;

    public MerlynUserChecker(@NotNull UserProvider userProvider) {
        Intrinsics.checkNotNullParameter((Object)userProvider, (String)"userProvider");
        this.userProvider = userProvider;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object check(@NotNull Continuation<? super CheckResult> $completion) {
        String accessToken;
        UserData user = this.userProvider.provide();
        boolean connected = user.getConnected();
        boolean loggedIn = user.getLoggedIn();
        boolean license = user.getValidLicense();
        boolean ok = connected && loggedIn && license;
        List messages = new ArrayList();
        if (loggedIn && (accessToken = user.getAccessToken()) != null) {
            List list;
            String sub;
            String[] stringArray = new String[]{"."};
            List parts = StringsKt.split$default((CharSequence)accessToken, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            Base64.Decoder decoder = Base64.getUrlDecoder();
            byte[] byArray = decoder.decode((String)parts.get(1));
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            byte[] byArray2 = byArray;
            String partAsString = new String(byArray2, Charsets.UTF_8);
            JsonObject decoded = JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(partAsString));
            JsonElement jsonElement = (JsonElement)decoded.get((Object)"sub");
            String string = sub = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null;
            JsonElement jsonElement2 = (JsonElement)decoded.get((Object)"cognito:groups");
            if (jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonArray((JsonElement)jsonElement2)) != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)jsonElement2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsonElement jsonElement3 = (JsonElement)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(JsonElementKt.getJsonPrimitive((JsonElement)it).getContent());
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
            List groups = list;
            messages.add("User subject identifier is: " + sub);
            messages.add("User claims are: " + CollectionsKt.joinToString$default((Iterable)groups, null, null, null, (int)0, null, null, (int)63, null));
            messages.add("User email is: " + user.getEmail());
        }
        Object[] objectArray = new String[]{"Is user connected: " + CheckerKt.yesOrNo(connected), "Is user logged in: " + CheckerKt.yesOrNo(loggedIn), "Does user have valid license: " + CheckerKt.yesOrNo(license)};
        return new CheckResult(ok, connected && loggedIn ? 1 : 0, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object[])objectArray), (Iterable)messages));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CheckerConfig configuration() {
        void $this$configuration_u24lambda_u241;
        JsonObjectBuilder builder$iv;
        String email = this.userProvider.provide().getEmail();
        Object[] objectArray = new String[]{"The user is not logged in to the Merlyn Cloud", "The user " + email + " does not have a valid license to use Merlyn"};
        List list = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        String string = "text";
        CheckerMessages checkerMessages = new CheckerMessages("The user is a part of the Merlyn Cloud", list, "Checking whether user is part of the Merlyn Cloud");
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$configuration_u24lambda_u241, (String)"title", (String)"Log in using the Merlyn App");
        Unit unit = Unit.INSTANCE;
        JsonObject jsonObject = builder$iv.build();
        String string2 = string;
        List list2 = CollectionsKt.listOf((Object)new Help(string2, jsonObject));
        CheckerMessages checkerMessages2 = checkerMessages;
        return new CheckerConfig(checkerMessages2, list2);
    }
}

