/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.xaudio;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.logging.Logger;

public final class FileUtils {
    static Logger logger = Logger.getLogger(FileUtils.class.getCanonicalName());
    static Path dir = null;

    private FileUtils() {
    }

    private static Path getTempDirectory() {
        if (dir != null) {
            return dir;
        }
        try {
            dir = Files.createTempDirectory("native-libs", new FileAttribute[0]);
            dir.toFile().deleteOnExit();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return dir;
    }

    static void load(String resource) {
        String libraryNameWithExtension = new File(resource).getName();
        String libraryName = libraryNameWithExtension.contains(".") ? libraryNameWithExtension.substring(0, libraryNameWithExtension.lastIndexOf(46)) : libraryNameWithExtension;
        String appDir = System.getProperty("app.dir");
        if (appDir != null) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os.contains("win")) {
                if (FileUtils.tryLoadLibrary(appDir, libraryNameWithExtension)) {
                    return;
                }
                if (FileUtils.tryLoadLibrary(appDir, "..\\bin", libraryNameWithExtension)) {
                    return;
                }
            } else {
                if (FileUtils.tryLoadLibrary(appDir, "../runtime/Contents/Home/lib", libraryNameWithExtension)) {
                    return;
                }
                if (FileUtils.tryLoadLibrary(appDir, libraryNameWithExtension)) {
                    return;
                }
            }
        }
        try {
            System.loadLibrary(libraryName);
            return;
        }
        catch (Throwable t) {
            logger.warning("Error loading " + libraryName + ". Will try to extract it from resources.");
            try {
                Path dest = Files.createFile(FileUtils.getTempDirectory().resolve(Paths.get(resource, new String[0]).getFileName()), new FileAttribute[0]);
                try (InputStream stream = FileUtils.class.getResourceAsStream("/" + resource);){
                    Files.copy(Objects.requireNonNull(stream, "Failed to copy resource: " + resource), dest, StandardCopyOption.REPLACE_EXISTING);
                    System.load(dest.toAbsolutePath().toString());
                }
            }
            catch (Throwable t2) {
                throw new RuntimeException(t2);
            }
            return;
        }
    }

    private static boolean tryLoadLibrary(String ... pathElements) {
        File file = null;
        for (String pathElement : pathElements) {
            file = file == null ? new File(pathElement) : new File(file, pathElement);
        }
        if (file == null) {
            logger.severe("Error loading library as the absolute path is null. This was absolutely unexpected and is probably due to bad application code. May continue trying with other paths.");
            return false;
        }
        try {
            System.load(file.getAbsolutePath());
            return true;
        }
        catch (Throwable ex) {
            logger.warning("Error loading " + file.getAbsolutePath() + ". May continue trying with other paths.");
            return false;
        }
    }
}

