/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.xaudio;

import org.merlyn.xaudio.BaseWavPlayer;
import org.merlyn.xaudio.FileUtils;

public final class WavPlayer
implements BaseWavPlayer {
    private long xAudioRef;
    private long xAudioMasteringVoiceRef;

    @Override
    public boolean isInitialized() {
        if (this.xAudioRef != 0L && this.xAudioMasteringVoiceRef != 0L) {
            return true;
        }
        if (this.xAudioRef == 0L && this.xAudioMasteringVoiceRef == 0L) {
            return false;
        }
        throw new IllegalStateException("Pointer references inconsistent, xAudioRef:" + this.xAudioRef + ", xAudioMasteringVoiceRef:" + this.xAudioMasteringVoiceRef);
    }

    @Override
    public native void initialize();

    @Override
    public native void play(String var1);

    @Override
    public native void release();

    static {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            if (System.getProperty("os.arch").contains("64")) {
                FileUtils.load("win/x64/XAudioWavPlayer.dll");
            } else {
                FileUtils.load("win/win32/XAudioWavPlayer.dll");
            }
        } else {
            System.err.println("Unable to initialize WavPlayer, unsupported platform:" + os);
        }
    }
}

