/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.macos;

import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import net.codecrete.usb.macos.gen.corefoundation.CoreFoundation;

class UUID {
    private UUID() {
    }

    static MemorySegment createCFUUID(byte[] bytes) {
        Arena arena = Arena.ofConfined();
        try {
            MemorySegment uuidBytes = arena.allocate(16L);
            uuidBytes.copyFrom(MemorySegment.ofArray(bytes));
            MemorySegment memorySegment = CoreFoundation.CFUUIDCreateFromUUIDBytes(MemorySegment.NULL, uuidBytes);
            if (arena != null) {
                arena.close();
            }
            return memorySegment;
        }
        catch (Throwable throwable) {
            try {
                if (arena != null) {
                    try {
                        arena.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new AssertionError("internal error (CFUUIDCreateFromUUIDBytes)", e);
            }
        }
    }
}

