/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.context;

import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.Json;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.agent.ActionContext;
import org.merlyn.agent.ActionDispatcher;
import org.merlyn.agent.IntentContext;
import org.merlyn.agent.KeyEventContext;
import org.merlyn.agent.model.Action;
import org.merlyn.agent.model.AgentOperation;
import org.merlyn.agent.model.Intent;
import org.merlyn.agent.model.KeyEvent;
import org.merlyn.agent.model.Message;
import org.merlyn.agent.model.MessageExtKt;
import org.merlyn.agent.model.RequestContext;
import org.merlyn.core.context.ActionContextImpl;
import org.merlyn.core.context.ActionDispatcherImpl;
import org.merlyn.core.context.ContextFactory;
import org.merlyn.core.context.IntentContextImpl;
import org.merlyn.core.context.KeyEventContextImpl;
import org.merlyn.core.context.RecommendationsBuilderImpl;
import org.merlyn.core.router.Router;
import org.merlyn.core.webagentrouter.ActionChain;
import org.merlyn.core.webagentrouter.ActionChainImpl;
import org.merlyn.core.webagentrouter.IntentChain;
import org.merlyn.core.webagentrouter.IntentChainImpl;
import org.merlyn.core.webagentrouter.KeyEventChain;
import org.merlyn.core.webagentrouter.KeyEventChainImpl;
import org.merlyn.core.webagentrouter.WebAgentRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u001e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010#J\u001e\u0010$\u001a\u00020%2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010#J\u001e\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/merlyn/core/context/ContextFactoryImpl;", "Lorg/merlyn/core/context/ContextFactory;", "router", "Lorg/merlyn/core/router/Router;", "format", "Lkotlinx/serialization/json/Json;", "log", "Lorg/slf4j/Logger;", "<init>", "(Lorg/merlyn/core/router/Router;Lkotlinx/serialization/json/Json;Lorg/slf4j/Logger;)V", "createActionDispatcher", "Lorg/merlyn/agent/ActionDispatcher;", "requestContext", "Lorg/merlyn/agent/model/RequestContext;", "(Lorg/merlyn/agent/model/RequestContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createActionDispatcherInternal", "Lorg/merlyn/core/context/ActionDispatcherImpl;", "createIntentContext", "Lorg/merlyn/agent/IntentContext;", "message", "Lorg/merlyn/agent/model/Message;", "(Lorg/merlyn/agent/model/Message;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createIntentContextInternal", "Lorg/merlyn/core/context/IntentContextImpl;", "actionDispatcher", "createKeyEventContext", "Lorg/merlyn/agent/KeyEventContext;", "createKeyEventContextInternal", "createActionContext", "Lorg/merlyn/agent/ActionContext;", "createActionContextInternal", "createIntentChain", "Lorg/merlyn/core/webagentrouter/IntentChain;", "webAgentRouter", "Lorg/merlyn/core/webagentrouter/WebAgentRouter;", "(Lorg/merlyn/core/webagentrouter/WebAgentRouter;Lorg/merlyn/agent/model/Message;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createActionChain", "Lorg/merlyn/core/webagentrouter/ActionChain;", "createKeyEventChain", "Lorg/merlyn/core/webagentrouter/KeyEventChain;", "sdkCore"})
public final class ContextFactoryImpl
implements ContextFactory {
    @NotNull
    private final Router router;
    @NotNull
    private final Json format;
    @NotNull
    private final Logger log;

    public ContextFactoryImpl(@NotNull Router router, @NotNull Json format, @NotNull Logger log2) {
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)log2, (String)"log");
        this.router = router;
        this.format = format;
        this.log = log2;
    }

    public /* synthetic */ ContextFactoryImpl(Router router, Json json, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            logger = LoggerFactory.getLogger(ContextFactoryImpl.class);
        }
        this(router, json, logger);
    }

    @Override
    @Nullable
    public Object createActionDispatcher(@NotNull RequestContext requestContext, @NotNull Continuation<? super ActionDispatcher> $completion) {
        return new ActionDispatcherImpl(this.router, requestContext);
    }

    private final ActionDispatcherImpl createActionDispatcherInternal(RequestContext requestContext) {
        return new ActionDispatcherImpl(this.router, requestContext);
    }

    @Override
    @Nullable
    public Object createIntentContext(@NotNull Message message, @NotNull Continuation<? super IntentContext> $completion) {
        return this.createIntentContextInternal(message, this.createActionDispatcherInternal(MessageExtKt.getRequestContext(message)));
    }

    private final IntentContextImpl createIntentContextInternal(Message message, ActionDispatcher actionDispatcher) {
        if (!MessageExtKt.isIntent(message)) {
            boolean bl = false;
            String string = "Message is not an " + AgentOperation.class + " of " + Intent.class + ", message: " + message;
            throw new IllegalStateException(string.toString());
        }
        return new IntentContextImpl(actionDispatcher, new RecommendationsBuilderImpl(message.getDestination(), MessageExtKt.getRequestContext(message)), this.format);
    }

    @Override
    @Nullable
    public Object createKeyEventContext(@NotNull Message message, @NotNull Continuation<? super KeyEventContext> $completion) {
        return this.createKeyEventContextInternal(message, this.createActionDispatcherInternal(MessageExtKt.getRequestContext(message)));
    }

    private final KeyEventContext createKeyEventContextInternal(Message message, ActionDispatcher actionDispatcher) {
        if (!MessageExtKt.isKeyEvent(message)) {
            boolean bl = false;
            String string = "Message is not an " + AgentOperation.class + " of " + KeyEvent.class + ", message: " + message;
            throw new IllegalStateException(string.toString());
        }
        return new KeyEventContextImpl(actionDispatcher, this.format);
    }

    @Override
    @Nullable
    public Object createActionContext(@NotNull Message message, @NotNull Continuation<? super ActionContext> $completion) {
        return this.createActionContextInternal(message, this.createActionDispatcherInternal(MessageExtKt.getRequestContext(message)));
    }

    private final ActionContext createActionContextInternal(Message message, ActionDispatcher actionDispatcher) {
        if (!MessageExtKt.isAction(message)) {
            boolean bl = false;
            String string = "Message is not an " + AgentOperation.class + " of " + Action.class + ", message: " + message;
            throw new IllegalStateException(string.toString());
        }
        return new ActionContextImpl(actionDispatcher);
    }

    @Override
    @Nullable
    public Object createIntentChain(@NotNull WebAgentRouter webAgentRouter, @NotNull Message message, @NotNull Continuation<? super IntentChain> $completion) {
        ActionDispatcherImpl actionDispatcher = this.createActionDispatcherInternal(MessageExtKt.getRequestContext(message));
        ActionDispatcher.Agent agent = actionDispatcher.getByLocator(message.getDestination());
        if (agent == null) {
            boolean bl = false;
            String string = message.getDestination() + " does not correspond to known agents: " + MessageExtKt.getRequestContext(message).getAvailableAgents();
            throw new IllegalStateException(string.toString());
        }
        ActionDispatcher.Agent target = agent;
        return new IntentChainImpl(message, webAgentRouter, this.createIntentContextInternal(message, actionDispatcher), target, this.log);
    }

    @Override
    @Nullable
    public Object createActionChain(@NotNull WebAgentRouter webAgentRouter, @NotNull Message message, @NotNull Continuation<? super ActionChain> $completion) {
        ActionDispatcherImpl actionDispatcher = this.createActionDispatcherInternal(MessageExtKt.getRequestContext(message));
        ActionDispatcher.Agent agent = actionDispatcher.getByLocator(message.getDestination());
        if (agent == null) {
            boolean bl = false;
            String string = message.getDestination() + " does not correspond to known agents: " + MessageExtKt.getRequestContext(message).getAvailableAgents();
            throw new IllegalStateException(string.toString());
        }
        ActionDispatcher.Agent target = agent;
        return new ActionChainImpl(message, webAgentRouter, this.createActionContextInternal(message, actionDispatcher), target, this.log);
    }

    @Override
    @Nullable
    public Object createKeyEventChain(@NotNull WebAgentRouter webAgentRouter, @NotNull Message message, @NotNull Continuation<? super KeyEventChain> $completion) {
        ActionDispatcherImpl actionDispatcher = this.createActionDispatcherInternal(MessageExtKt.getRequestContext(message));
        ActionDispatcher.Agent agent = actionDispatcher.getByLocator(message.getDestination());
        if (agent == null) {
            boolean bl = false;
            String string = message.getDestination() + " does not correspond to known agents: " + MessageExtKt.getRequestContext(message).getAvailableAgents();
            throw new IllegalStateException(string.toString());
        }
        ActionDispatcher.Agent target = agent;
        return new KeyEventChainImpl(message, webAgentRouter, this.createKeyEventContextInternal(message, actionDispatcher), target, this.log);
    }
}

