/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.render;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.agent.Action;
import org.merlyn.agent.ActionContext;
import org.merlyn.agent.Agent;
import org.merlyn.agent.Intent;
import org.merlyn.agent.IntentContext;
import org.merlyn.agent.KeyEvent;
import org.merlyn.agent.KeyEventContext;
import org.merlyn.agent.model.Payload;
import org.merlyn.agent.model.RenderAlert;
import org.merlyn.agent.model.RenderConfirmation;
import org.merlyn.agent.model.RenderEvent;
import org.merlyn.agent.model.RenderRecommendations;
import org.merlyn.core.render.Render;
import org.merlyn.core.render.RenderCallbackBuilder;
import org.merlyn.core.render.RenderExtKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0096@\u00a2\u0006\u0002\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Lorg/merlyn/core/render/RenderAgent;", "Lorg/merlyn/agent/Agent;", "format", "Lkotlinx/serialization/json/Json;", "renderCallbackBuilder", "Lorg/merlyn/core/render/RenderCallbackBuilder;", "<init>", "(Lkotlinx/serialization/json/Json;Lorg/merlyn/core/render/RenderCallbackBuilder;)V", "_renderStream", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/merlyn/core/render/Render;", "renderStream", "Lkotlinx/coroutines/flow/SharedFlow;", "getRenderStream", "()Lkotlinx/coroutines/flow/SharedFlow;", "agentName", "", "getAgentName", "()Ljava/lang/String;", "agentVersion", "getAgentVersion", "setAgentVersion", "(Ljava/lang/String;)V", "handleAction", "", "action", "Lorg/merlyn/agent/Action;", "actionContext", "Lorg/merlyn/agent/ActionContext;", "(Lorg/merlyn/agent/Action;Lorg/merlyn/agent/ActionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "sdkCore"})
@SourceDebugExtension(value={"SMAP\nRenderAgent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RenderAgent.kt\norg/merlyn/core/render/RenderAgent\n+ 2 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,64:1\n309#2:65\n*S KotlinDebug\n*F\n+ 1 RenderAgent.kt\norg/merlyn/core/render/RenderAgent\n*L\n42#1:65\n*E\n"})
public final class RenderAgent
implements Agent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Json format;
    @NotNull
    private final RenderCallbackBuilder renderCallbackBuilder;
    @NotNull
    private final MutableSharedFlow<Render> _renderStream;
    @NotNull
    private final SharedFlow<Render> renderStream;
    @NotNull
    private final String agentName;
    @NotNull
    private String agentVersion;
    @NotNull
    public static final String AGENT_NAME = "Render";
    @NotNull
    public static final String AGENT_VERSION = "1.0.0";
    @NotNull
    public static final String ACTION_RENDER = "RENDER";

    public RenderAgent(@NotNull Json format, @NotNull RenderCallbackBuilder renderCallbackBuilder2) {
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)renderCallbackBuilder2, (String)"renderCallbackBuilder");
        this.format = format;
        this.renderCallbackBuilder = renderCallbackBuilder2;
        this._renderStream = SharedFlowKt.MutableSharedFlow$default((int)0, (int)1, null, (int)4, null);
        this.renderStream = FlowKt.asSharedFlow(this._renderStream);
        this.agentName = AGENT_NAME;
        this.agentVersion = AGENT_VERSION;
    }

    @NotNull
    public final SharedFlow<Render> getRenderStream() {
        return this.renderStream;
    }

    @NotNull
    public String getAgentName() {
        return this.agentName;
    }

    @NotNull
    public String getAgentVersion() {
        return this.agentVersion;
    }

    public void setAgentVersion(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.agentVersion = string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object handleAction(@NotNull Action action, @NotNull ActionContext actionContext, @NotNull Continuation<? super Unit> $completion) {
        if (Intrinsics.areEqual((Object)action.getAction(), (Object)ACTION_RENDER)) {
            Render render2;
            void $this$decodeFromJsonElement$iv;
            Json json = this.format;
            JsonObject jsonObject = action.getParams();
            Intrinsics.checkNotNull((Object)jsonObject);
            JsonElement json$iv = (JsonElement)jsonObject;
            boolean $i$f$decodeFromJsonElement = false;
            $this$decodeFromJsonElement$iv.getSerializersModule();
            Payload renderParams = (Payload)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)Payload.Companion.serializer(), json$iv);
            if (renderParams instanceof RenderAlert) {
                render2 = RenderExtKt.toRender((RenderAlert)renderParams);
            } else if (renderParams instanceof RenderEvent) {
                render2 = RenderExtKt.toRender((RenderEvent)renderParams);
            } else if (renderParams instanceof RenderRecommendations) {
                render2 = RenderExtKt.toRender((RenderRecommendations)renderParams, this.renderCallbackBuilder);
            } else if (renderParams instanceof RenderConfirmation) {
                render2 = RenderExtKt.toRender((RenderConfirmation)renderParams, this.renderCallbackBuilder);
            } else {
                throw new UnsupportedOperationException();
            }
            Object object = this._renderStream.emit((Object)render2, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public Object handleIntent(@NotNull Intent intent, @NotNull IntentContext intentContext, @NotNull Continuation<? super Unit> $completion) {
        return Agent.DefaultImpls.handleIntent((Agent)this, (Intent)intent, (IntentContext)intentContext, $completion);
    }

    @Nullable
    public Object handleKeyEvent(@NotNull KeyEvent keyEvent, @NotNull KeyEventContext keyEventContext, @NotNull Continuation<? super Unit> $completion) {
        return Agent.DefaultImpls.handleKeyEvent((Agent)this, (KeyEvent)keyEvent, (KeyEventContext)keyEventContext, $completion);
    }

    @Nullable
    public StateFlow<JsonObject> getAgentContext() {
        return Agent.DefaultImpls.getAgentContext((Agent)this);
    }

    @NotNull
    public List<String> getKeyCodes() {
        return Agent.DefaultImpls.getKeyCodes((Agent)this);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/merlyn/core/render/RenderAgent$Companion;", "", "<init>", "()V", "AGENT_NAME", "", "AGENT_VERSION", "ACTION_RENDER", "sdkCore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

