/*
 * Decompiled with CFR 0.152.
 */
package org.rococoa.internal;

import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeLong;
import com.sun.jna.Structure;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import org.rococoa.ID;
import org.rococoa.RococoaException;
import org.rococoa.Selector;
import org.rococoa.internal.MethodFunctionPair;
import org.rococoa.internal.MsgSendInvocationMapper;
import org.rococoa.internal.MsgSendLibrary;
import org.rococoa.internal.RococoaTypeMapper;

class MsgSendHandler
implements InvocationHandler {
    private final String OPTION_INVOKING_METHOD = "invoking-method";
    private static final int I386_STRET_CUTOFF = 9;
    private static final int IA64_STRET_CUTOFF = 17;
    private static final int STRET_CUTOFF = NativeLong.SIZE == 8 ? 17 : 9;
    public static final boolean AARCH64 = System.getProperty("os.arch").trim().equalsIgnoreCase("aarch64");
    public static final boolean PPC = System.getProperty("os.arch").trim().equalsIgnoreCase("ppc");
    private static final Method OBJC_MSGSEND;
    private static final Method OBJC_MSGSEND_VAR_ARGS;
    private static final Method OBJC_MSGSEND_STRET;
    private final MethodFunctionPair objc_msgSend_stret_Pair;
    private final MethodFunctionPair objc_msgSend_varArgs_Pair;
    private final MethodFunctionPair objc_msgSend_Pair;
    private final RococoaTypeMapper rococoaTypeMapper = new RococoaTypeMapper();

    public MsgSendHandler(NativeLibrary lib) {
        this.objc_msgSend_Pair = new MethodFunctionPair(AARCH64 ? null : OBJC_MSGSEND, lib.getFunction("objc_msgSend"));
        this.objc_msgSend_varArgs_Pair = new MethodFunctionPair(OBJC_MSGSEND_VAR_ARGS, lib.getFunction("objc_msgSend"));
        this.objc_msgSend_stret_Pair = new MethodFunctionPair(OBJC_MSGSEND_STRET, AARCH64 ? null : lib.getFunction("objc_msgSend_stret"));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        Class returnTypeForThisCall = (Class)args[0];
        MethodFunctionPair invocation = this.invocationFor(returnTypeForThisCall, MsgSendInvocationMapper.SYNTHETIC_SEND_VARARGS_MSG.equals(method));
        HashMap<String, RococoaTypeMapper> options = new HashMap<String, RococoaTypeMapper>(Collections.singletonMap("type-mapper", this.rococoaTypeMapper));
        options.put("invoking-method", (RococoaTypeMapper)((Object)invocation.method));
        return invocation.function.invoke(returnTypeForThisCall, Arrays.copyOfRange(args, 1, args.length), options);
    }

    private MethodFunctionPair invocationFor(Class<?> returnTypeForThisCall, boolean varArgs) {
        boolean isStructByValue;
        if (AARCH64) {
            if (varArgs) {
                return this.objc_msgSend_varArgs_Pair;
            }
            return this.objc_msgSend_Pair;
        }
        boolean isStruct = Structure.class.isAssignableFrom(returnTypeForThisCall);
        boolean bl = isStructByValue = isStruct && Structure.ByValue.class.isAssignableFrom(returnTypeForThisCall);
        if (!isStructByValue) {
            return this.objc_msgSend_Pair;
        }
        try {
            if (PPC) {
                return this.objc_msgSend_stret_Pair;
            }
            Structure prototype = (Structure)returnTypeForThisCall.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return prototype.size() < STRET_CUTOFF ? this.objc_msgSend_Pair : this.objc_msgSend_stret_Pair;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RococoaException(e);
        }
    }

    static {
        try {
            OBJC_MSGSEND = MsgSendLibrary.class.getDeclaredMethod("objc_msgSend", ID.class, Selector.class, Object[].class);
            OBJC_MSGSEND_VAR_ARGS = MsgSendLibrary.class.getDeclaredMethod("objc_msgSend", ID.class, Selector.class, Object.class, Object[].class);
            OBJC_MSGSEND_STRET = MsgSendLibrary.class.getDeclaredMethod("objc_msgSend_stret", ID.class, Selector.class, Object[].class);
        }
        catch (NoSuchMethodException x) {
            throw new RococoaException(x);
        }
    }
}

