/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.helpers;

import com.microsoft.alm.helpers.Environment;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class IOHelper {
    static final int BUFFER_SIZE = 4096;

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String readFileToString(File file) throws IOException {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            string = IOHelper.readToString(fis);
        }
        catch (Throwable throwable) {
            IOHelper.closeQuietly(fis);
            throw throwable;
        }
        IOHelper.closeQuietly(fis);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readToString(InputStream stream) throws IOException {
        String string;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            String line;
            isr = new InputStreamReader(stream);
            reader = new BufferedReader(isr);
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append(Environment.NewLine);
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            IOHelper.closeQuietly(reader);
            IOHelper.closeQuietly(isr);
            throw throwable;
        }
        IOHelper.closeQuietly(reader);
        IOHelper.closeQuietly(isr);
        return string;
    }

    public static void copyStream(InputStream is, OutputStream os) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = is.read(buffer, 0, 4096)) != -1) {
            os.write(buffer, 0, bytesRead);
        }
        os.flush();
    }
}

