/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.helpers;

import com.microsoft.alm.helpers.Func;
import com.microsoft.alm.helpers.ObjectExtensions;
import java.nio.charset.Charset;

public class StringHelper {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    public static final String Empty = "";

    public static boolean endsWithIgnoreCase(String haystack, String needle) {
        int hl;
        if (haystack == null) {
            throw new IllegalArgumentException("Parameter 'haystack' is null.");
        }
        if (needle == null) {
            throw new IllegalArgumentException("Parameter 'needle' is null.");
        }
        int nl = needle.length();
        if (nl == (hl = haystack.length())) {
            return haystack.equalsIgnoreCase(needle);
        }
        if (nl > hl) {
            return false;
        }
        int toffset = hl - nl;
        return haystack.regionMatches(true, toffset, needle, 0, nl);
    }

    public static int indexOfAny(String s, char[] anyOf) {
        for (char c : anyOf) {
            int i = s.indexOf(c);
            if (i == -1) continue;
            return i;
        }
        return -1;
    }

    public static boolean isNullOrEmpty(String s) {
        return null == s || s.length() == 0;
    }

    public static boolean isNullOrWhiteSpace(String s) {
        return null == s || s.trim().length() == 0;
    }

    public static String join(String separator, String[] value) {
        return StringHelper.join(separator, value, 0, value.length);
    }

    public static String join(String separator, String[] value, int startIndex, int count) {
        return StringHelper.join(separator, value, startIndex, count, null);
    }

    public static String join(String separator, String[] value, int startIndex, int count, Func<String, String> processor) {
        if (value == null) {
            throw new IllegalArgumentException("value is null");
        }
        if (startIndex < 0) {
            throw new IllegalArgumentException("startIndex is less than 0");
        }
        if (count < 0) {
            throw new IllegalArgumentException("count is less than 0");
        }
        if (startIndex + count > value.length) {
            throw new IllegalArgumentException("startIndex + count is greater than the number of elements in value");
        }
        String sep = ObjectExtensions.coalesce(separator, Empty);
        StringBuilder result = new StringBuilder();
        if (value.length > 0 && count > 0) {
            String element = ObjectExtensions.coalesce(value[startIndex], Empty);
            if (processor != null) {
                element = processor.call(element);
            }
            result.append(element);
            for (int i = startIndex + 1; i < startIndex + count; ++i) {
                result.append(sep);
                element = ObjectExtensions.coalesce(value[i], Empty);
                if (processor != null) {
                    element = processor.call(element);
                }
                result.append(element);
            }
        }
        return result.toString();
    }

    public static String trimEnd(String s, char ... trimChars) {
        int len;
        if (trimChars == null || trimChars.length == 0) {
            return StringHelper.trimEnd(s);
        }
        for (len = s.length(); len > 0; --len) {
            char current = s.charAt(len - 1);
            boolean found = false;
            for (char c : trimChars) {
                if (current != c) continue;
                found = true;
                break;
            }
            if (!found) break;
        }
        return len < s.length() ? s.substring(0, len) : s;
    }

    public static String trimEnd(String s) {
        char current;
        int len;
        for (len = s.length(); len > 0 && Character.isWhitespace(current = s.charAt(len - 1)); --len) {
        }
        return len < s.length() ? s.substring(0, len) : s;
    }

    public static byte[] UTF8GetBytes(String value) {
        byte[] result = value.getBytes(UTF8);
        return result;
    }

    public static String UTF8GetString(byte[] bytes) {
        String result = new String(bytes, UTF8);
        return result;
    }

    public static String UTF8GetString(byte[] bytes, int index, int count) {
        String result = new String(bytes, index, count, UTF8);
        return result;
    }
}

