/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.secret;

import com.microsoft.alm.helpers.ScopeSet;
import com.microsoft.alm.helpers.StringHelper;

public abstract class TokenScope {
    private static final String[] EmptyStringArray = new String[0];
    protected final String[] _scopes;

    protected TokenScope(String value) {
        if (StringHelper.isNullOrWhiteSpace(value)) {
            this._scopes = new String[0];
        } else {
            this._scopes = new String[1];
            this._scopes[0] = value;
        }
    }

    protected TokenScope(String[] values) {
        this._scopes = values;
    }

    protected TokenScope(ScopeSet set) {
        this._scopes = set.toArray(EmptyStringArray);
    }

    public String getValue() {
        return StringHelper.join(" ", this._scopes);
    }

    public boolean equals(Object obj) {
        return TokenScope.operatorEquals(this, obj instanceof TokenScope ? (TokenScope)obj : null);
    }

    public int hashCode() {
        int hash = Integer.MAX_VALUE;
        for (int i = 0; i < this._scopes.length; ++i) {
            hash ^= this._scopes[i].hashCode();
        }
        return hash;
    }

    public String toString() {
        return this.getValue();
    }

    public static boolean operatorEquals(TokenScope scope1, TokenScope scope2) {
        if (scope1 == scope2) {
            return true;
        }
        if (scope1 == null || null == scope2) {
            return false;
        }
        ScopeSet set = new ScopeSet();
        set.unionWith(scope1._scopes);
        return set.setEquals(scope2._scopes);
    }

    public static boolean operatorNotEquals(TokenScope scope1, TokenScope scope2) {
        return !TokenScope.operatorEquals(scope1, scope2);
    }
}

