/*
 * Decompiled with CFR 0.152.
 */
package com.j256.cloudwatchlogbackappender;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2ClientBuilder;
import com.amazonaws.services.ec2.model.DescribeTagsRequest;
import com.amazonaws.services.ec2.model.DescribeTagsResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.TagDescription;
import com.amazonaws.services.logs.AWSLogs;
import com.amazonaws.services.logs.AWSLogsClientBuilder;
import com.amazonaws.services.logs.model.CreateLogGroupRequest;
import com.amazonaws.services.logs.model.CreateLogStreamRequest;
import com.amazonaws.services.logs.model.DataAlreadyAcceptedException;
import com.amazonaws.services.logs.model.DescribeLogGroupsRequest;
import com.amazonaws.services.logs.model.DescribeLogGroupsResult;
import com.amazonaws.services.logs.model.DescribeLogStreamsRequest;
import com.amazonaws.services.logs.model.DescribeLogStreamsResult;
import com.amazonaws.services.logs.model.InputLogEvent;
import com.amazonaws.services.logs.model.InvalidSequenceTokenException;
import com.amazonaws.services.logs.model.LogGroup;
import com.amazonaws.services.logs.model.LogStream;
import com.amazonaws.services.logs.model.PutLogEventsRequest;
import com.amazonaws.services.logs.model.PutLogEventsResult;
import com.amazonaws.util.EC2MetadataUtils;
import com.j256.cloudwatchlogbackappender.Ec2InstanceIdConverter;
import com.j256.cloudwatchlogbackappender.Ec2InstanceNameConverter;
import com.j256.cloudwatchlogbackappender.Ec2PatternLayout;
import com.j256.cloudwatchlogbackappender.MiscUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.slf4j.Marker;

public class CloudWatchAppender
extends UnsynchronizedAppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent> {
    private static final int DEFAULT_MAX_BATCH_SIZE = 128;
    private static final long DEFAULT_MAX_BATCH_TIME_MILLIS = 5000L;
    private static final int DEFAULT_INTERNAL_QUEUE_SIZE = 8192;
    private static final boolean DEFAULT_CREATE_LOG_DESTS = true;
    private static final long DEFAULT_MAX_QUEUE_WAIT_TIME_MILLIS = 100L;
    private static final long DEFAULT_INITIAL_WAIT_TIME_MILLIS = 0L;
    private static final int PUT_REQUEST_RETRY_COUNT = 2;
    public static final String AWS_ACCESS_KEY_ID_PROPERTY = "cloudwatchappender.aws.accessKeyId";
    public static final String AWS_SECRET_KEY_PROPERTY = "cloudwatchappender.aws.secretKey";
    public static final int DEFAULT_MAX_EVENT_MESSAGE_SIZE = 262144;
    public static final boolean DEFAULT_TRUNCATE_EVENT_MESSAGES = true;
    public static final boolean DEFAULT_COPY_EVENTS = true;
    public static final boolean DEFAULT_PRINT_REJECTED_EVENTS = false;
    public static final Pattern LOG_GROUP_PATTERN = Pattern.compile("[\\.\\-_/#A-Za-z0-9]+");
    private String accessKeyId;
    private String secretKey;
    private String region;
    private String logGroupName;
    private String logStreamName;
    private Layout<ILoggingEvent> layout;
    private Appender<ILoggingEvent> emergencyAppender;
    private int maxBatchSize = 128;
    private long maxBatchTimeMillis = 5000L;
    private long maxQueueWaitTimeMillis = 100L;
    private int internalQueueSize = 8192;
    private boolean createLogDests = true;
    private long initialWaitTimeMillis = 0L;
    private int maxEventMessageSize = 262144;
    private boolean truncateEventMessages = true;
    private boolean copyEvents = true;
    private boolean printRejectedEvents = false;
    private AtomicReference<AWSLogs> awsLogsClient = new AtomicReference<Object>(null);
    private AWSLogs testAwsLogsClient;
    private AmazonEC2 testAmazonEc2Client;
    private volatile long eventsWrittenCount;
    private BlockingQueue<ILoggingEvent> loggingEventQueue;
    private CloudWatchWriter cloudWatchWriter;
    private Thread cloudWatchWriterThread;
    private final ThreadLocal<Boolean> stopMessagesThreadLocal = new ThreadLocal();
    private volatile boolean warningMessagePrinted;
    private final InputLogEventComparator inputLogEventComparator = new InputLogEventComparator();
    private boolean avoidDropMessages = false;

    public void start() {
        if (this.started) {
            return;
        }
        if (MiscUtils.isBlank(this.region)) {
            throw new IllegalStateException("Region not set or invalid for appender: " + this.region);
        }
        if (MiscUtils.isBlank(this.logGroupName)) {
            throw new IllegalStateException("Log group name not set or invalid for appender: " + this.logGroupName);
        }
        if (!LOG_GROUP_PATTERN.matcher(this.logGroupName).matches()) {
            throw new IllegalStateException("Log group name does not match AWS acceptance pattern '" + LOG_GROUP_PATTERN + "': " + this.logGroupName);
        }
        if (MiscUtils.isBlank(this.logStreamName)) {
            throw new IllegalStateException("Log stream name not set or invalid for appender: " + this.logStreamName);
        }
        if (this.layout == null) {
            throw new IllegalStateException("Layout was not set for appender");
        }
        this.loggingEventQueue = new ArrayBlockingQueue<ILoggingEvent>(this.internalQueueSize);
        this.cloudWatchWriter = new CloudWatchWriter();
        this.cloudWatchWriterThread = new Thread((Runnable)this.cloudWatchWriter, ((Object)((Object)this)).getClass().getSimpleName());
        this.cloudWatchWriterThread.setDaemon(true);
        this.cloudWatchWriterThread.start();
        if (this.emergencyAppender != null && !this.emergencyAppender.isStarted()) {
            this.emergencyAppender.start();
        }
        super.start();
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.cloudWatchWriterThread.interrupt();
        try {
            this.cloudWatchWriterThread.join(1000L);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        if (this.awsLogsClient.get() != null) {
            this.awsLogsClient.get().shutdown();
            this.awsLogsClient.set(null);
        }
        super.stop();
    }

    protected void append(ILoggingEvent loggingEvent) {
        Boolean stopped;
        if (this.loggingEventQueue == null) {
            if (!this.warningMessagePrinted) {
                System.err.println(((Object)((Object)this)).getClass().getSimpleName() + " not started correctly, ignoring all log messages");
                this.warningMessagePrinted = true;
            }
            return;
        }
        if (!this.avoidDropMessages && (stopped = this.stopMessagesThreadLocal.get()) != null && stopped.booleanValue()) {
            return;
        }
        String message = loggingEvent.getMessage();
        boolean copied = false;
        if (message != null && message.length() > this.maxEventMessageSize) {
            if (!this.truncateEventMessages) {
                this.appendToEmergencyAppender(loggingEvent);
                return;
            }
            loggingEvent = this.copyEvent(loggingEvent, message.substring(0, this.maxEventMessageSize));
            copied = true;
        }
        if (!copied) {
            if (this.copyEvents) {
                loggingEvent = this.copyEvent(loggingEvent, null);
            } else {
                loggingEvent.prepareForDeferredProcessing();
            }
        }
        try {
            if (!this.loggingEventQueue.offer(loggingEvent, this.maxQueueWaitTimeMillis, TimeUnit.MILLISECONDS)) {
                this.appendToEmergencyAppender(loggingEvent);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.appendToEmergencyAppender(loggingEvent);
        }
    }

    public boolean resetAWSLogsClient() {
        return this.cloudWatchWriter.resetLogsClient(true);
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setLogGroup(String logGroupName) {
        this.logGroupName = logGroupName;
    }

    public void setLogStream(String logStreamName) {
        this.logStreamName = logStreamName;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public void setMaxBatchSize(int maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public void setMaxBatchTimeMillis(long maxBatchTimeMillis) {
        this.maxBatchTimeMillis = maxBatchTimeMillis;
    }

    public void setMaxQueueWaitTimeMillis(long maxQueueWaitTimeMillis) {
        this.maxQueueWaitTimeMillis = maxQueueWaitTimeMillis;
    }

    public void setInternalQueueSize(int internalQueueSize) {
        this.internalQueueSize = internalQueueSize;
    }

    public void setCreateLogDests(boolean createLogDests) {
        this.createLogDests = createLogDests;
    }

    public void setInitialWaitTimeMillis(long initialWaitTimeMillis) {
        this.initialWaitTimeMillis = initialWaitTimeMillis;
    }

    void setAwsLogsClient(AWSLogs awsLogsClient) {
        this.awsLogsClient.set(awsLogsClient);
    }

    void setTestAwsLogsClient(AWSLogs testAwsLogsClient) {
        this.testAwsLogsClient = testAwsLogsClient;
    }

    void setTestAmazonEc2Client(AmazonEC2 testAmazonEc2Client) {
        this.testAmazonEc2Client = testAmazonEc2Client;
    }

    public void setMaxEventMessageSize(int maxEventMessageSize) {
        this.maxEventMessageSize = maxEventMessageSize;
    }

    public void setTruncateEventMessages(boolean truncateEventMessages) {
        this.truncateEventMessages = truncateEventMessages;
    }

    public void setCopyEvents(boolean copyEvents) {
        this.copyEvents = copyEvents;
    }

    public void setPrintRejectedEvents(boolean printRejectedEvents) {
        this.printRejectedEvents = printRejectedEvents;
    }

    public void setAvoidDropMessages(boolean avoidDropMessages) {
        this.avoidDropMessages = avoidDropMessages;
    }

    public static void setEc2MetadataServiceOverride(String ec2MetadataServiceOverride) {
        System.setProperty("com.amazonaws.sdk.ec2MetadataServiceEndpointOverride", ec2MetadataServiceOverride);
    }

    public static void setEc2InstanceName(String testInstanceName) {
        Ec2InstanceNameConverter.setInstanceName(testInstanceName);
    }

    long getEventsWrittenCount() {
        return this.eventsWrittenCount;
    }

    boolean isWarningMessagePrinted() {
        return this.warningMessagePrinted;
    }

    public void addAppender(Appender<ILoggingEvent> appender) {
        if (this.emergencyAppender == null) {
            this.emergencyAppender = appender;
        } else {
            this.addWarn("One and only one appender may be attached to " + ((Object)((Object)this)).getClass().getSimpleName());
            this.addWarn("Ignoring additional appender named [" + appender.getName() + "]");
        }
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        throw new UnsupportedOperationException("Don't know how to create iterator");
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        if (this.emergencyAppender != null && name != null && name.equals(this.emergencyAppender.getName())) {
            return this.emergencyAppender;
        }
        return null;
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.emergencyAppender == appender;
    }

    public void detachAndStopAllAppenders() {
        if (this.emergencyAppender != null) {
            this.emergencyAppender.stop();
            this.emergencyAppender = null;
        }
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        if (this.emergencyAppender == appender) {
            this.emergencyAppender = null;
            return true;
        }
        return false;
    }

    public boolean detachAppender(String name) {
        if (this.emergencyAppender != null && this.emergencyAppender.getName().equals(name)) {
            this.emergencyAppender = null;
            return true;
        }
        return false;
    }

    private LoggingEvent copyEvent(ILoggingEvent loggingEvent, String message) {
        LoggingEvent newEvent = new LoggingEvent();
        newEvent.setArgumentArray(loggingEvent.getArgumentArray());
        newEvent.setLevel(loggingEvent.getLevel());
        newEvent.setLoggerContextRemoteView(loggingEvent.getLoggerContextVO());
        newEvent.setLoggerName(loggingEvent.getLoggerName());
        if (loggingEvent.getMarkerList() != null) {
            for (Marker marker : loggingEvent.getMarkerList()) {
                newEvent.addMarker(marker);
            }
        }
        newEvent.setMDCPropertyMap(loggingEvent.getMDCPropertyMap());
        if (message == null) {
            newEvent.setMessage(loggingEvent.getMessage());
        } else {
            newEvent.setMessage(message);
        }
        newEvent.setThreadName(loggingEvent.getThreadName());
        IThrowableProxy ithrowableProxy = loggingEvent.getThrowableProxy();
        if (ithrowableProxy instanceof ThrowableProxy) {
            newEvent.setThrowableProxy((ThrowableProxy)ithrowableProxy);
        }
        newEvent.setTimeStamp(loggingEvent.getTimeStamp());
        return newEvent;
    }

    private void appendToEmergencyAppender(ILoggingEvent event) {
        if (this.emergencyAppender != null) {
            try {
                this.emergencyAppender.doAppend((Object)event);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.printRejectedEvents) {
            try {
                System.err.println(((Object)((Object)this)).getClass().getSimpleName() + " emergency appender didn't handle event: " + this.layout.doLayout((Object)event));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void appendToEmergencyAppender(List<ILoggingEvent> events) {
        for (ILoggingEvent event : events) {
            this.appendToEmergencyAppender(event);
        }
    }

    private static class InputLogEventComparator
    implements Comparator<InputLogEvent> {
        private InputLogEventComparator() {
        }

        @Override
        public int compare(InputLogEvent o1, InputLogEvent o2) {
            if (o1.getTimestamp() == null) {
                if (o2.getTimestamp() == null) {
                    return 0;
                }
                return -1;
            }
            if (o2.getTimestamp() == null) {
                return 1;
            }
            return o1.getTimestamp().compareTo(o2.getTimestamp());
        }
    }

    private class CloudWatchWriter
    implements Runnable {
        private String sequenceToken;
        private String logStreamName;
        private boolean initialized;

        private CloudWatchWriter() {
        }

        @Override
        public void run() {
            ILoggingEvent event;
            try {
                Thread.sleep(CloudWatchAppender.this.initialWaitTimeMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            ArrayList<ILoggingEvent> events = new ArrayList<ILoggingEvent>(CloudWatchAppender.this.maxBatchSize);
            Thread thread = Thread.currentThread();
            while (!thread.isInterrupted()) {
                long timeoutMillis;
                long batchTimeout = System.currentTimeMillis() + CloudWatchAppender.this.maxBatchTimeMillis;
                while (!thread.isInterrupted() && (timeoutMillis = batchTimeout - System.currentTimeMillis()) >= 0L) {
                    ILoggingEvent loggingEvent;
                    try {
                        loggingEvent = (ILoggingEvent)CloudWatchAppender.this.loggingEventQueue.poll(timeoutMillis, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                        break;
                    }
                    if (loggingEvent == null) break;
                    events.add(loggingEvent);
                    if (events.size() < CloudWatchAppender.this.maxBatchSize) continue;
                    break;
                }
                if (events.isEmpty()) continue;
                this.writeEvents(events);
                events.clear();
            }
            events.clear();
            while ((event = (ILoggingEvent)CloudWatchAppender.this.loggingEventQueue.poll()) != null) {
                events.add(event);
                if (events.size() < CloudWatchAppender.this.maxBatchSize) continue;
                this.writeEvents(events);
                events.clear();
            }
            if (!events.isEmpty()) {
                this.writeEvents(events);
                events.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean resetLogsClient(boolean forced) {
            Exception exception = null;
            try {
                CloudWatchAppender.this.stopMessagesThreadLocal.set(true);
                if (CloudWatchAppender.this.awsLogsClient.get() == null || forced) {
                    this.createLogsClient();
                } else {
                    this.logStreamName = this.buildLogStreamName();
                }
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                CloudWatchAppender.this.stopMessagesThreadLocal.set(false);
            }
            if (exception != null) {
                this.appendEvent(Level.ERROR, "Problems initializing cloudwatch writer", exception);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeEvents(List<ILoggingEvent> events) {
            if (!this.initialized) {
                this.initialized = true;
                this.resetLogsClient(false);
            }
            if (CloudWatchAppender.this.awsLogsClient.get() == null) {
                CloudWatchAppender.this.appendToEmergencyAppender(events);
                return;
            }
            CloudWatchAppender.this.stopMessagesThreadLocal.set(true);
            Throwable exception = null;
            try {
                ArrayList<InputLogEvent> logEvents = new ArrayList<InputLogEvent>(events.size());
                for (ILoggingEvent event : events) {
                    String message = CloudWatchAppender.this.layout.doLayout((Object)event);
                    InputLogEvent logEvent = new InputLogEvent().withTimestamp(Long.valueOf(event.getTimeStamp())).withMessage(message);
                    logEvents.add(logEvent);
                }
                Collections.sort(logEvents, CloudWatchAppender.this.inputLogEventComparator);
                for (int i = 0; i < 2; ++i) {
                    try {
                        PutLogEventsRequest request = new PutLogEventsRequest(CloudWatchAppender.this.logGroupName, this.logStreamName, logEvents);
                        if (this.sequenceToken != null) {
                            request.withSequenceToken(this.sequenceToken);
                        }
                        PutLogEventsResult result = ((AWSLogs)CloudWatchAppender.this.awsLogsClient.get()).putLogEvents(request);
                        this.sequenceToken = result.getNextSequenceToken();
                        exception = null;
                        CloudWatchAppender.this.eventsWrittenCount += logEvents.size();
                        break;
                    }
                    catch (InvalidSequenceTokenException iste) {
                        exception = iste;
                        this.sequenceToken = iste.getExpectedSequenceToken();
                        continue;
                    }
                }
            }
            catch (DataAlreadyAcceptedException daac) {
                exception = daac;
                this.sequenceToken = daac.getExpectedSequenceToken();
            }
            catch (Exception e) {
                exception = e;
            }
            finally {
                if (exception != null) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    exception.printStackTrace(pw);
                    events.add((ILoggingEvent)this.makeEvent(Level.ERROR, "Exception thrown when creating logging " + events.size() + " events; error: " + exception.getMessage() + "; stacktrace: " + sw, exception));
                    CloudWatchAppender.this.appendToEmergencyAppender(events);
                }
                CloudWatchAppender.this.stopMessagesThreadLocal.set(false);
            }
        }

        private void createLogsClient() {
            if (MiscUtils.isBlank(CloudWatchAppender.this.accessKeyId)) {
                CloudWatchAppender.this.accessKeyId = System.getProperty(CloudWatchAppender.AWS_ACCESS_KEY_ID_PROPERTY);
                CloudWatchAppender.this.secretKey = System.getProperty(CloudWatchAppender.AWS_SECRET_KEY_PROPERTY);
            }
            Object credentialProvider = MiscUtils.isBlank(CloudWatchAppender.this.accessKeyId) ? new DefaultAWSCredentialsProviderChain() : new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(CloudWatchAppender.this.accessKeyId, CloudWatchAppender.this.secretKey));
            AWSLogs client = CloudWatchAppender.this.testAwsLogsClient == null ? (AWSLogs)((AWSLogsClientBuilder)((AWSLogsClientBuilder)AWSLogsClientBuilder.standard().withCredentials((AWSCredentialsProvider)credentialProvider)).withRegion(CloudWatchAppender.this.region)).build() : CloudWatchAppender.this.testAwsLogsClient;
            this.logStreamName = this.buildLogStreamName();
            this.verifyLogGroupExists(client);
            this.verifyLogStreamExists(client);
            CloudWatchAppender.this.awsLogsClient.set(client);
        }

        private void verifyLogGroupExists(AWSLogs client) {
            DescribeLogGroupsRequest request = new DescribeLogGroupsRequest().withLogGroupNamePrefix(CloudWatchAppender.this.logGroupName);
            DescribeLogGroupsResult result = client.describeLogGroups(request);
            for (LogGroup group : result.getLogGroups()) {
                if (!CloudWatchAppender.this.logGroupName.equals(group.getLogGroupName())) continue;
                return;
            }
            if (CloudWatchAppender.this.createLogDests) {
                this.callLogClientMethod(client, "createLogGroup", (AmazonWebServiceRequest)new CreateLogGroupRequest(CloudWatchAppender.this.logGroupName));
            } else {
                this.appendEvent(Level.WARN, "Log-group '" + CloudWatchAppender.this.logGroupName + "' doesn't exist and not created", null);
            }
        }

        private void verifyLogStreamExists(AWSLogs client) {
            DescribeLogStreamsRequest request = new DescribeLogStreamsRequest().withLogGroupName(CloudWatchAppender.this.logGroupName).withLogStreamNamePrefix(this.logStreamName);
            DescribeLogStreamsResult result = client.describeLogStreams(request);
            for (LogStream stream : result.getLogStreams()) {
                if (!this.logStreamName.equals(stream.getLogStreamName())) continue;
                this.sequenceToken = stream.getUploadSequenceToken();
                return;
            }
            if (CloudWatchAppender.this.createLogDests) {
                this.callLogClientMethod(client, "createLogStream", (AmazonWebServiceRequest)new CreateLogStreamRequest(CloudWatchAppender.this.logGroupName, this.logStreamName));
            } else {
                this.appendEvent(Level.WARN, "Log-stream '" + this.logStreamName + "' doesn't exist and not created", null);
            }
        }

        private String buildLogStreamName() {
            String name = CloudWatchAppender.this.logStreamName;
            if (name.indexOf(37) < 0) {
                return name;
            }
            Ec2PatternLayout nameLayout = new Ec2PatternLayout();
            nameLayout.setPattern(name);
            nameLayout.setContext(CloudWatchAppender.this.context);
            nameLayout.start();
            LoggingEvent event = new LoggingEvent();
            event.setLevel(Level.INFO);
            event.setLoggerName("logStreamName");
            event.setMessage("log stream name");
            event.setTimeStamp(System.currentTimeMillis());
            name = nameLayout.doLayout((ILoggingEvent)event);
            name = name.replace(':', '_');
            return name;
        }

        private void callLogClientMethod(AWSLogs client, String methodName, AmazonWebServiceRequest arg) {
            try {
                Method method = client.getClass().getMethod(methodName, arg.getClass());
                method.invoke((Object)client, arg);
                this.appendEvent(Level.INFO, "Ran log client method " + methodName + ", arg " + arg, null);
            }
            catch (Exception e) {
                if (CloudWatchAppender.this.emergencyAppender != null) {
                    CloudWatchAppender.this.emergencyAppender.addError("Problems running log-client method: " + methodName + ", arg: " + arg, (Throwable)e);
                }
                this.appendEvent(Level.ERROR, "Problems running log-client method: " + methodName + ", arg: " + arg, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lookupInstanceName(AWSCredentialsProvider credentialProvider) {
            String instanceId = EC2MetadataUtils.getInstanceId();
            if (instanceId == null) {
                return;
            }
            Ec2InstanceIdConverter.setInstanceId(instanceId);
            AmazonEC2 ec2Client = null;
            try {
                ec2Client = CloudWatchAppender.this.testAmazonEc2Client == null ? (AmazonEC2)((AmazonEC2ClientBuilder)((AmazonEC2ClientBuilder)AmazonEC2ClientBuilder.standard().withCredentials(credentialProvider)).withRegion(CloudWatchAppender.this.region)).build() : CloudWatchAppender.this.testAmazonEc2Client;
                DescribeTagsRequest request = new DescribeTagsRequest();
                request.setFilters(Arrays.asList(new Filter("resource-type").withValues(new String[]{"instance"}), new Filter("resource-id").withValues(new String[]{instanceId})));
                DescribeTagsResult result = ec2Client.describeTags(request);
                List tags = result.getTags();
                for (TagDescription tag : tags) {
                    if (!"Name".equals(tag.getKey())) continue;
                    String instanceName = tag.getValue();
                    Ec2InstanceNameConverter.setInstanceName(instanceName);
                    return;
                }
                this.appendEvent(Level.INFO, "Could not find EC2 instance name in tags: " + tags, null);
            }
            catch (AmazonServiceException ase) {
                this.appendEvent(Level.WARN, "Looking up EC2 instance-name threw", ase);
            }
            finally {
                if (ec2Client != null) {
                    ec2Client.shutdown();
                }
            }
            Ec2InstanceNameConverter.setInstanceName(instanceId);
        }

        private void appendEvent(Level level, String message, Throwable th) {
            CloudWatchAppender.this.append((ILoggingEvent)this.makeEvent(level, message, th));
        }

        private LoggingEvent makeEvent(Level level, String message, Throwable th) {
            LoggingEvent event = new LoggingEvent();
            event.setLoggerName(CloudWatchAppender.class.getName());
            event.setLevel(level);
            event.setMessage(message);
            event.setTimeStamp(System.currentTimeMillis());
            if (th != null) {
                event.setThrowableProxy(new ThrowableProxy(th));
            }
            return event;
        }
    }
}

