/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.storage.posix;

import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.LoggingHelper;
import com.microsoft.alm.helpers.StringHelper;
import com.microsoft.alm.helpers.XmlHelper;
import com.microsoft.alm.secret.Credential;
import com.microsoft.alm.storage.posix.internal.GnomeKeyringBackedSecureStore;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GnomeKeyringBackedCredentialStore
extends GnomeKeyringBackedSecureStore<Credential> {
    private static final Logger logger = LoggerFactory.getLogger(GnomeKeyringBackedCredentialStore.class);

    @Override
    protected Credential deserialize(String secret) {
        Debug.Assert((secret != null ? 1 : 0) != 0, (String)"secret cannot be null");
        try {
            return GnomeKeyringBackedCredentialStore.fromXmlString(secret);
        }
        catch (Exception e) {
            LoggingHelper.logError((Logger)logger, (String)"Failed to deserialize credential.", (Throwable)e);
            return null;
        }
    }

    static Credential fromXmlString(String xmlString) {
        byte[] bytes = StringHelper.UTF8GetBytes((String)xmlString);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        return GnomeKeyringBackedCredentialStore.fromXmlStream(inputStream);
    }

    static Credential fromXmlStream(InputStream source) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.parse(source);
            Element rootElement = document.getDocumentElement();
            Credential result = Credential.fromXml((Node)rootElement);
            return result;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    protected String serialize(Credential credential) {
        Debug.Assert((credential != null ? 1 : 0) != 0, (String)"Credential cannot be null");
        return GnomeKeyringBackedCredentialStore.toXmlString(credential);
    }

    static String toXmlString(Credential credential) {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = dbf.newDocumentBuilder();
            Document document = builder.newDocument();
            Element element = credential.toXml(document);
            document.appendChild(element);
            String result = XmlHelper.toString((Document)document);
            return result;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    protected String getType() {
        return "Credential";
    }
}

