/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.alm.storage.posix.internal;

import com.microsoft.alm.helpers.Debug;
import com.microsoft.alm.helpers.SettingsHelper;
import com.microsoft.alm.helpers.SystemHelper;
import com.microsoft.alm.secret.Secret;
import com.microsoft.alm.storage.SecretStore;
import com.microsoft.alm.storage.posix.internal.GLibInitializer;
import com.microsoft.alm.storage.posix.internal.GnomeKeyringLibrary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GnomeKeyringBackedSecureStore<E extends Secret>
implements SecretStore<E> {
    private static final Logger logger = LoggerFactory.getLogger(GnomeKeyringBackedSecureStore.class);
    private static final GnomeKeyringLibrary INSTANCE = GnomeKeyringBackedSecureStore.getGnomeKeyringLibrary();
    private static final GnomeKeyringLibrary.GnomeKeyringPasswordSchema SCHEMA = GnomeKeyringBackedSecureStore.getGnomeKeyringPasswordSchema();
    public static final String ALLOW_UNLOCK_KEYRING = "AUTH_LIB_ALLOW_UNLOCK_GNOME_KEYRING";

    protected abstract E deserialize(String var1);

    protected abstract String serialize(E var1);

    protected abstract String getType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(String key) {
        Debug.Assert((key != null ? 1 : 0) != 0, (String)"key cannot be null");
        logger.info("Getting {} for {}", (Object)this.getType(), (Object)key);
        GnomeKeyringLibrary.PointerToPointer pPassword = new GnomeKeyringLibrary.PointerToPointer();
        String secret = null;
        try {
            int result = INSTANCE.gnome_keyring_find_password_sync(SCHEMA, pPassword, "Type", this.getType(), "Key", key, null);
            if (GnomeKeyringBackedSecureStore.checkResult(result, "Could not retrieve secret from storage.")) {
                secret = pPassword.pointer.getString(0L);
            }
        }
        finally {
            if (pPassword.pointer != null) {
                INSTANCE.gnome_keyring_free_password(pPassword.pointer);
            }
        }
        return secret != null ? (E)this.deserialize(secret) : null;
    }

    public boolean delete(String key) {
        Debug.Assert((key != null ? 1 : 0) != 0, (String)"key cannot be null");
        logger.info("Deleting {} for {}", (Object)this.getType(), (Object)key);
        int result = INSTANCE.gnome_keyring_delete_password_sync(SCHEMA, "Type", this.getType(), "Key", key, null);
        return GnomeKeyringBackedSecureStore.checkResult(result, "Could not delete secret from storage");
    }

    public boolean add(String key, E secret) {
        Debug.Assert((key != null ? 1 : 0) != 0, (String)"key cannot be null");
        Debug.Assert((secret != null ? 1 : 0) != 0, (String)"Secret cannot be null");
        logger.info("Adding a {} for {}", (Object)this.getType(), (Object)key);
        int result = INSTANCE.gnome_keyring_store_password_sync(SCHEMA, GnomeKeyringLibrary.GNOME_KEYRING_DEFAULT, key, this.serialize(secret), "Type", this.getType(), "Key", key, null);
        return GnomeKeyringBackedSecureStore.checkResult(result, "Could not save secret to the storage.");
    }

    public boolean isSecure() {
        return true;
    }

    public static boolean isGnomeKeyringSupported() {
        block5: {
            GnomeKeyringLibrary.PointerToPointer keyring_info;
            if (INSTANCE == null || SCHEMA == null || (keyring_info = GnomeKeyringBackedSecureStore.getGnomeKeyringInfoStruct()) == null) break block5;
            try {
                boolean bl = GnomeKeyringBackedSecureStore.isSimplePasswordAPISupported() && GnomeKeyringBackedSecureStore.isGnomeKeyringUnlocked(keyring_info);
                INSTANCE.gnome_keyring_info_free(keyring_info.pointer);
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    INSTANCE.gnome_keyring_info_free(keyring_info.pointer);
                    throw throwable;
                }
                catch (Throwable t) {
                    logger.warn("Gnome Keyring is not available.", t);
                }
            }
        }
        return false;
    }

    private static GnomeKeyringLibrary.PointerToPointer getGnomeKeyringInfoStruct() {
        GnomeKeyringLibrary.PointerToPointer keyring_info_container = new GnomeKeyringLibrary.PointerToPointer();
        int ret = INSTANCE.gnome_keyring_get_info_sync(GnomeKeyringLibrary.GNOME_KEYRING_DEFAULT, keyring_info_container);
        return GnomeKeyringBackedSecureStore.checkResult(ret, "Could not get default keyring info. GNOME Keyring is not available.") ? keyring_info_container : null;
    }

    private static boolean isSimplePasswordAPISupported() {
        logger.debug("Try access gnome-keyring with dummy data to make sure it's accessible...");
        try {
            GnomeKeyringLibrary.PointerToPointer pPassword = new GnomeKeyringLibrary.PointerToPointer();
            INSTANCE.gnome_keyring_find_password_sync(SCHEMA, pPassword, "Type", "NullType", "Key", "NullKey", null);
        }
        catch (UnsatisfiedLinkError error) {
            logger.warn("GNOME Keyring on this platform does not support the simple password API.  We require gnome-keyring 2.22+.");
            return false;
        }
        return true;
    }

    private static boolean isGnomeKeyringUnlocked(GnomeKeyringLibrary.PointerToPointer keyring_info) {
        boolean locked = INSTANCE.gnome_keyring_info_get_is_locked(keyring_info.pointer);
        if (locked) {
            logger.info("Keyring is locked, most likely due to UI is unavailable or user logged in automatically without supplying a password.");
            boolean allowUnlock = Boolean.valueOf(SettingsHelper.getInstance().getProperty(ALLOW_UNLOCK_KEYRING));
            if (allowUnlock) {
                int ret = INSTANCE.gnome_keyring_unlock_sync(GnomeKeyringLibrary.GNOME_KEYRING_DEFAULT, null);
                return GnomeKeyringBackedSecureStore.checkResult(ret, "Could not unlock keyring. GNOME Keyring is not available.");
            }
            logger.info("Keyring is locked and unavailable, please set variable {} to allow unlocking the keyring with a popup dialog.", (Object)ALLOW_UNLOCK_KEYRING);
            return false;
        }
        return true;
    }

    private static boolean isGnomeKeyringLibraryAvailable() {
        if (SystemHelper.isLinux()) {
            try {
                GnomeKeyringLibrary ignored = GnomeKeyringLibrary.INSTANCE;
                try {
                    GLibInitializer.getInstance().initialize();
                }
                catch (UnsatisfiedLinkError error) {
                    logger.warn("Glib not available -- user will see warnings printed on screen. Those warnings are not serious and can be ignored.");
                }
                return true;
            }
            catch (Throwable t) {
                logger.info("gnome-keyring library not loaded", t);
            }
        }
        return false;
    }

    private static GnomeKeyringLibrary getGnomeKeyringLibrary() {
        return GnomeKeyringBackedSecureStore.isGnomeKeyringLibraryAvailable() ? GnomeKeyringLibrary.INSTANCE : null;
    }

    private static GnomeKeyringLibrary.GnomeKeyringPasswordSchema getGnomeKeyringPasswordSchema() {
        try {
            if (GnomeKeyringBackedSecureStore.isGnomeKeyringLibraryAvailable()) {
                logger.info("gnome-keyring library loaded, creating a password SCHEMA");
                GnomeKeyringLibrary.GnomeKeyringPasswordSchema schema = new GnomeKeyringLibrary.GnomeKeyringPasswordSchema();
                schema.item_type = 0;
                schema.attributes = new GnomeKeyringLibrary.GnomeKeyringPasswordSchemaAttribute[3];
                schema.attributes[0] = new GnomeKeyringLibrary.GnomeKeyringPasswordSchemaAttribute();
                schema.attributes[0].name = "Type";
                schema.attributes[0].type = 0;
                schema.attributes[1] = new GnomeKeyringLibrary.GnomeKeyringPasswordSchemaAttribute();
                schema.attributes[1].name = "Key";
                schema.attributes[1].type = 0;
                schema.attributes[2] = new GnomeKeyringLibrary.GnomeKeyringPasswordSchemaAttribute();
                schema.attributes[2].name = null;
                schema.attributes[2].type = 0;
                return schema;
            }
            logger.info("gnome-keyring library not loaded, return null for SCHEMA");
        }
        catch (Throwable t) {
            logger.warn("creating SCHEMA failed, return null for SCHEMA.", t);
        }
        return null;
    }

    private static boolean checkResult(int retCode, String message) {
        if (retCode != 0) {
            logger.error(message);
            try {
                logger.error("Return code: {} description: {}", (Object)retCode, (Object)INSTANCE.gnome_keyring_result_to_message(retCode));
            }
            catch (UnsatisfiedLinkError e) {
                logger.error("Return code: {}", (Object)retCode);
            }
            return false;
        }
        return true;
    }
}

