/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.context;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.agent.ActionDispatcher;
import org.merlyn.agent.model.Action;
import org.merlyn.agent.model.AgentMetadata;
import org.merlyn.agent.model.AgentOperation;
import org.merlyn.agent.model.Message;
import org.merlyn.agent.model.Operation;
import org.merlyn.agent.model.Payload;
import org.merlyn.agent.model.RequestContext;
import org.merlyn.core.router.Router;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0011\u001a\u00020\tJ\t\u0010\u0012\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c2\u0003J\u001d\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\tH\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001d"}, d2={"Lorg/merlyn/core/context/ActionDispatcherImpl;", "Lorg/merlyn/agent/ActionDispatcher;", "router", "Lorg/merlyn/core/router/Router;", "requestContext", "Lorg/merlyn/agent/model/RequestContext;", "<init>", "(Lorg/merlyn/core/router/Router;Lorg/merlyn/agent/model/RequestContext;)V", "requestId", "", "getRequestId", "()Ljava/lang/String;", "get", "Lorg/merlyn/agent/ActionDispatcher$Agent;", "agentName", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getByLocator", "locator", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Agent", "sdkCore"})
@SourceDebugExtension(value={"SMAP\nActionDispatcherImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActionDispatcherImpl.kt\norg/merlyn/core/context/ActionDispatcherImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public final class ActionDispatcherImpl
implements ActionDispatcher {
    @NotNull
    private final Router router;
    @NotNull
    private final RequestContext requestContext;

    public ActionDispatcherImpl(@NotNull Router router, @NotNull RequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        this.router = router;
        this.requestContext = requestContext;
    }

    @NotNull
    public String getRequestId() {
        return this.requestContext.getRequestId();
    }

    @Nullable
    public Object get(@NotNull String agentName, @NotNull Continuation<? super ActionDispatcher.Agent> $completion) {
        AgentMetadata agentMetadata = (AgentMetadata)this.requestContext.getAvailableAgents().get(agentName);
        if (agentMetadata == null) {
            return null;
        }
        AgentMetadata metadata = agentMetadata;
        return new Agent(metadata, this.requestContext);
    }

    @Nullable
    public final ActionDispatcher.Agent getByLocator(@NotNull String locator) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)locator, (String)"locator");
            Iterable iterable = this.requestContext.getAvailableAgents().values();
            for (Object t : iterable) {
                AgentMetadata it = (AgentMetadata)t;
                boolean bl = false;
                if (!it.getLocations().contains(locator)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        AgentMetadata agentMetadata = v0;
        if (agentMetadata == null) {
            return null;
        }
        AgentMetadata metadata = agentMetadata;
        return new Agent(metadata, this.requestContext);
    }

    private final Router component1() {
        return this.router;
    }

    private final RequestContext component2() {
        return this.requestContext;
    }

    @NotNull
    public final ActionDispatcherImpl copy(@NotNull Router router, @NotNull RequestContext requestContext) {
        Intrinsics.checkNotNullParameter((Object)router, (String)"router");
        Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
        return new ActionDispatcherImpl(router, requestContext);
    }

    public static /* synthetic */ ActionDispatcherImpl copy$default(ActionDispatcherImpl actionDispatcherImpl, Router router, RequestContext requestContext, int n, Object object) {
        if ((n & 1) != 0) {
            router = actionDispatcherImpl.router;
        }
        if ((n & 2) != 0) {
            requestContext = actionDispatcherImpl.requestContext;
        }
        return actionDispatcherImpl.copy(router, requestContext);
    }

    @NotNull
    public String toString() {
        return "ActionDispatcherImpl(router=" + this.router + ", requestContext=" + this.requestContext + ")";
    }

    public int hashCode() {
        int result = this.router.hashCode();
        result = result * 31 + this.requestContext.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ActionDispatcherImpl)) {
            return false;
        }
        ActionDispatcherImpl actionDispatcherImpl = (ActionDispatcherImpl)other;
        if (!Intrinsics.areEqual((Object)this.router, (Object)actionDispatcherImpl.router)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.requestContext, (Object)actionDispatcherImpl.requestContext);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J&\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\t2\u000e\u0010\u0011\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\u0012H\u0096@\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lorg/merlyn/core/context/ActionDispatcherImpl$Agent;", "Lorg/merlyn/agent/ActionDispatcher$Agent;", "metadata", "Lorg/merlyn/agent/model/AgentMetadata;", "requestContext", "Lorg/merlyn/agent/model/RequestContext;", "<init>", "(Lorg/merlyn/core/context/ActionDispatcherImpl;Lorg/merlyn/agent/model/AgentMetadata;Lorg/merlyn/agent/model/RequestContext;)V", "version", "", "getVersion", "()Ljava/lang/String;", "location", "getLocation", "dispatchAction", "", "action", "params", "Lorg/merlyn/agent/model/ActionParams;", "Lkotlinx/serialization/json/JsonObject;", "(Ljava/lang/String;Lkotlinx/serialization/json/JsonObject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "sdkCore"})
    public final class Agent
    implements ActionDispatcher.Agent {
        @NotNull
        private final AgentMetadata metadata;
        @NotNull
        private final RequestContext requestContext;
        @NotNull
        private final String location;

        public Agent(@NotNull AgentMetadata metadata, RequestContext requestContext) {
            Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
            Intrinsics.checkNotNullParameter((Object)requestContext, (String)"requestContext");
            this.metadata = metadata;
            this.requestContext = requestContext;
            Object object = CollectionsKt.firstOrNull((List)this.metadata.getLocations());
            if (object == null) {
                Agent agent = this;
                boolean bl = false;
                Agent agent2 = agent;
                String string = "Agent '" + this.metadata.getName() + "' location not available";
                throw new IllegalArgumentException(string.toString());
            }
            this.location = (String)object;
        }

        @NotNull
        public String getVersion() {
            return this.metadata.getVersion();
        }

        @NotNull
        public final String getLocation() {
            return this.location;
        }

        @Nullable
        public Object dispatchAction(@NotNull String action, @Nullable JsonObject params, @NotNull Continuation<? super Unit> $completion) {
            Object object = ActionDispatcherImpl.this.router.route(new Message(this.location, (Payload)new AgentOperation(this.requestContext, (Operation)new Action(action, params))), $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
    }
}

