/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ApplicationConfigKt;
import io.ktor.server.config.ConfigLoader;
import io.ktor.server.config.MapApplicationConfig;
import io.ktor.server.config.MergedApplicationConfigKt;
import io.ktor.server.engine.ApplicationEngineEnvironment;
import io.ktor.server.engine.ApplicationEngineEnvironmentBuilder;
import io.ktor.server.engine.ApplicationEngineEnvironmentKt;
import io.ktor.server.engine.BaseApplicationEngine;
import io.ktor.server.engine.ConfigKeys;
import io.ktor.server.engine.EngineConnectorBuilder;
import io.ktor.server.engine.EnvironmentUtilsJvmKt;
import io.ktor.util.PlatformUtils;
import io.ktor.util.logging.KtorSimpleLoggerJvmKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\u001a\u001b\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0000\u00a2\u0006\u0002\u0010\u0005\u001a\u0019\u0010\u0006\u001a\u00020\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\b\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\"\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u000e*\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u00a8\u0006\u0011"}, d2={"buildApplicationConfig", "Lio/ktor/server/config/ApplicationConfig;", "args", "", "", "([Ljava/lang/String;)Lio/ktor/server/config/ApplicationConfig;", "commandLineEnvironment", "Lio/ktor/server/engine/ApplicationEngineEnvironment;", "([Ljava/lang/String;)Lio/ktor/server/engine/ApplicationEngineEnvironment;", "loadCommonConfiguration", "", "Lio/ktor/server/engine/BaseApplicationEngine$Configuration;", "deploymentConfig", "splitPair", "Lkotlin/Pair;", "ch", "", "ktor-server-host-common"})
public final class CommandLineKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationEngineEnvironment commandLineEnvironment(@NotNull String[] args) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String[] $this$mapNotNull$iv = args;
        boolean $i$f$mapNotNull = false;
        String[] stringArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            Pair<String, String> it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            void it = element$iv$iv;
            boolean bl2 = false;
            if (CommandLineKt.splitPair((String)it, '=') == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Map argumentsPairs = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        ApplicationConfig configuration = CommandLineKt.buildApplicationConfig(args);
        String string = ApplicationConfigKt.tryGetString((ApplicationConfig)configuration, (String)ConfigKeys.INSTANCE.getApplicationIdPath());
        if (string == null) {
            string = "Application";
        }
        String applicationId = string;
        Logger logger = KtorSimpleLoggerJvmKt.KtorSimpleLogger((String)applicationId);
        String string2 = (String)argumentsPairs.get("-path");
        if (string2 == null && (string2 = ApplicationConfigKt.tryGetString((ApplicationConfig)configuration, (String)ConfigKeys.INSTANCE.getRootPathPath())) == null) {
            string2 = "";
        }
        String rootPath = string2;
        ApplicationEngineEnvironment environment2 = ApplicationEngineEnvironmentKt.applicationEngineEnvironment((Function1<? super ApplicationEngineEnvironmentBuilder, Unit>)((Function1)new Function1<ApplicationEngineEnvironmentBuilder, Unit>(logger, args, configuration, rootPath, (Map<String, String>)argumentsPairs){
            final /* synthetic */ Logger $logger;
            final /* synthetic */ String[] $args;
            final /* synthetic */ ApplicationConfig $configuration;
            final /* synthetic */ String $rootPath;
            final /* synthetic */ Map<String, String> $argumentsPairs;
            {
                this.$logger = $logger;
                this.$args = $args;
                this.$configuration = $configuration;
                this.$rootPath = $rootPath;
                this.$argumentsPairs = $argumentsPairs;
                super(1);
            }

            public final void invoke(@NotNull ApplicationEngineEnvironmentBuilder $this$applicationEngineEnvironment) {
                block11: {
                    String[] $this$invoke_u24lambda_u241;
                    boolean bl;
                    EngineConnectorBuilder it;
                    Object object;
                    String string;
                    String sslPort;
                    String string2;
                    String port;
                    String string3;
                    String host;
                    Intrinsics.checkNotNullParameter((Object)$this$applicationEngineEnvironment, (String)"$this$applicationEngineEnvironment");
                    $this$applicationEngineEnvironment.setLog(this.$logger);
                    EnvironmentUtilsJvmKt.configurePlatformProperties($this$applicationEngineEnvironment, this.$args);
                    $this$applicationEngineEnvironment.setConfig(this.$configuration);
                    $this$applicationEngineEnvironment.setRootPath(this.$rootPath);
                    String string4 = this.$argumentsPairs.get("-host");
                    if (string4 == null && (string4 = ApplicationConfigKt.tryGetString((ApplicationConfig)this.$configuration, (String)ConfigKeys.INSTANCE.getHostConfigPath())) == null) {
                        string4 = host = "0.0.0.0";
                    }
                    if ((string3 = this.$argumentsPairs.get("-port")) == null) {
                        string3 = port = ApplicationConfigKt.tryGetString((ApplicationConfig)this.$configuration, (String)ConfigKeys.INSTANCE.getHostPortPath());
                    }
                    if ((string2 = this.$argumentsPairs.get("-sslPort")) == null) {
                        string2 = sslPort = ApplicationConfigKt.tryGetString((ApplicationConfig)this.$configuration, (String)ConfigKeys.INSTANCE.getHostSslPortPath());
                    }
                    if ((string = this.$argumentsPairs.get("-sslKeyStore")) == null) {
                        string = ApplicationConfigKt.tryGetString((ApplicationConfig)this.$configuration, (String)ConfigKeys.INSTANCE.getHostSslKeyStore());
                    }
                    String sslKeyStorePath = string;
                    String string5 = ApplicationConfigKt.tryGetString((ApplicationConfig)this.$configuration, (String)ConfigKeys.INSTANCE.getHostSslKeyStorePassword());
                    String sslKeyStorePassword = string5 != null ? ((Object)StringsKt.trim((CharSequence)string5)).toString() : null;
                    String string6 = ApplicationConfigKt.tryGetString((ApplicationConfig)this.$configuration, (String)ConfigKeys.INSTANCE.getHostSslPrivateKeyPassword());
                    String sslPrivateKeyPassword = string6 != null ? ((Object)StringsKt.trim((CharSequence)string6)).toString() : null;
                    String string7 = ApplicationConfigKt.tryGetString((ApplicationConfig)this.$configuration, (String)ConfigKeys.INSTANCE.getHostSslKeyAlias());
                    if (string7 == null) {
                        string7 = "mykey";
                    }
                    String sslKeyAlias = string7;
                    ApplicationEngineEnvironmentBuilder applicationEngineEnvironmentBuilder = $this$applicationEngineEnvironment;
                    String string8 = ApplicationConfigKt.tryGetString((ApplicationConfig)this.$configuration, (String)ConfigKeys.INSTANCE.getDevelopmentModeKey());
                    if (string8 != null) {
                        String string9 = string8;
                        object = applicationEngineEnvironmentBuilder;
                        boolean bl2 = false;
                        boolean bl3 = Boolean.parseBoolean((String)((Object)it));
                        applicationEngineEnvironmentBuilder = object;
                        bl = bl3;
                    } else {
                        bl = PlatformUtils.INSTANCE.getIS_DEVELOPMENT_MODE();
                    }
                    applicationEngineEnvironmentBuilder.setDevelopmentMode(bl);
                    if (port != null) {
                        EngineConnectorBuilder engineConnectorBuilder;
                        ApplicationEngineEnvironmentBuilder $this$connector$iv = $this$applicationEngineEnvironment;
                        boolean $i$f$connector = false;
                        it = engineConnectorBuilder = new EngineConnectorBuilder(null, 1, null);
                        object = $this$connector$iv.getConnectors();
                        boolean bl4 = false;
                        $this$invoke_u24lambda_u241.setHost(host);
                        $this$invoke_u24lambda_u241.setPort(Integer.parseInt(port));
                        object.add(engineConnectorBuilder);
                    }
                    if (sslPort != null) {
                        EnvironmentUtilsJvmKt.configureSSLConnectors($this$applicationEngineEnvironment, host, sslPort, sslKeyStorePath, sslKeyStorePassword, sslPrivateKeyPassword, sslKeyAlias);
                    }
                    if (port == null && sslPort == null) {
                        throw new IllegalArgumentException("Neither port nor sslPort specified. Use command line options -port/-sslPort or configure connectors in application.conf");
                    }
                    Object object2 = this.$argumentsPairs.get("-watch");
                    if (object2 == null || (object2 = StringsKt.split$default((CharSequence)((CharSequence)object2), (String[])($this$invoke_u24lambda_u241 = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
                        object2 = ApplicationConfigKt.tryGetStringList((ApplicationConfig)this.$configuration, (String)ConfigKeys.INSTANCE.getHostWatchPaths());
                    }
                    if (object2 == null) break block11;
                    Object it2 = object2;
                    boolean bl5 = false;
                    $this$applicationEngineEnvironment.setWatchPaths((List<String>)it2);
                }
            }
        }));
        return environment2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ApplicationConfig buildApplicationConfig(@NotNull String[] args) {
        Object v0;
        List commandLineProperties;
        block4: {
            void $this$mapTo$iv$iv;
            Iterable $this$filterTo$iv$iv;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            String[] $this$mapNotNull$iv = args;
            boolean $i$f$mapNotNull = false;
            String[] stringArray = $this$mapNotNull$iv;
            Iterable<Pair<String, String>> destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Pair<String, String> it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                void it = element$iv$iv;
                boolean bl2 = false;
                if (CommandLineKt.splitPair((String)it, '=') == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List argumentsPairs = (List)destination$iv$iv;
            Iterable $this$filter$iv = argumentsPairs;
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Pair it = (Pair)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.startsWith$default((String)((String)it.getFirst()), (String)"-P:", (boolean)false, (int)2, null)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv2;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair it = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)StringsKt.removePrefix((String)((String)it.getFirst()), (CharSequence)"-P:"), (Object)it.getSecond()));
            }
            commandLineProperties = (List)destination$iv$iv2;
            Iterable $this$firstOrNull$iv = argumentsPairs;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair it = (Pair)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getFirst(), (Object)"-config")) continue;
                v0 = element$iv;
                break block4;
            }
            v0 = null;
        }
        Pair pair = v0;
        String configPath = pair != null ? (String)pair.getSecond() : null;
        MapApplicationConfig commandLineConfig = new MapApplicationConfig(commandLineProperties);
        ApplicationConfig environmentConfig = EnvironmentUtilsJvmKt.getConfigFromEnvironment();
        ApplicationConfig fileConfig = ConfigLoader.Companion.load(ConfigLoader.Companion, configPath);
        return MergedApplicationConfigKt.mergeWith((ApplicationConfig)MergedApplicationConfigKt.mergeWith((ApplicationConfig)fileConfig, (ApplicationConfig)environmentConfig), (ApplicationConfig)((ApplicationConfig)commandLineConfig));
    }

    public static final void loadCommonConfiguration(@NotNull BaseApplicationEngine.Configuration $this$loadCommonConfiguration, @NotNull ApplicationConfig deploymentConfig) {
        block2: {
            Object object;
            Object object2;
            int it;
            Intrinsics.checkNotNullParameter((Object)$this$loadCommonConfiguration, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)deploymentConfig, (String)"deploymentConfig");
            Object object3 = deploymentConfig.propertyOrNull("callGroupSize");
            if (object3 != null && (object3 = object3.getString()) != null) {
                it = Integer.parseInt((String)object3);
                boolean bl = false;
                $this$loadCommonConfiguration.setCallGroupSize(it);
            }
            if ((object2 = deploymentConfig.propertyOrNull("connectionGroupSize")) != null && (object2 = object2.getString()) != null) {
                it = Integer.parseInt((String)object2);
                boolean bl = false;
                $this$loadCommonConfiguration.setConnectionGroupSize(it);
            }
            if ((object = deploymentConfig.propertyOrNull("workerGroupSize")) == null || (object = object.getString()) == null) break block2;
            it = Integer.parseInt((String)object);
            boolean bl = false;
            $this$loadCommonConfiguration.setWorkerGroupSize(it);
        }
    }

    @Nullable
    public static final Pair<String, String> splitPair(@NotNull String $this$splitPair, char ch) {
        Intrinsics.checkNotNullParameter((Object)$this$splitPair, (String)"<this>");
        int idx = StringsKt.indexOf$default((CharSequence)$this$splitPair, (char)ch, (int)0, (boolean)false, (int)6, null);
        boolean bl = false;
        return idx == -1 ? null : new Pair((Object)StringsKt.take((String)$this$splitPair, (int)idx), (Object)StringsKt.drop((String)$this$splitPair, (int)(idx + 1)));
    }
}

