/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.proxy.generic.select_for_update;

import io.github.bucket4j.BucketExceptions;
import io.github.bucket4j.TimeMeter;
import io.github.bucket4j.distributed.proxy.AbstractProxyManager;
import io.github.bucket4j.distributed.proxy.ClientSideConfig;
import io.github.bucket4j.distributed.proxy.Timeout;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.LockAndGetResult;
import io.github.bucket4j.distributed.proxy.generic.select_for_update.SelectForUpdateBasedTransaction;
import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.remote.Request;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractSelectForUpdateBasedProxyManager<K>
extends AbstractProxyManager<K> {
    private static final CommandResult RETRY_IN_THE_SCOPE_OF_NEW_TRANSACTION = CommandResult.success(Boolean.valueOf(true), 666);

    protected AbstractSelectForUpdateBasedProxyManager(ClientSideConfig clientSideConfig) {
        super(AbstractSelectForUpdateBasedProxyManager.injectTimeClock(clientSideConfig));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> CommandResult<T> execute(K key, Request<T> request) {
        CommandResult<T> result;
        Timeout timeout = Timeout.of(this.getClientSideConfig());
        do {
            SelectForUpdateBasedTransaction transaction = timeout.call(timeoutNanos -> this.allocateTransaction(key, (Optional<Long>)timeoutNanos));
            try {
                result = this.execute(request, transaction, timeout);
            }
            finally {
                transaction.release();
            }
        } while (result == RETRY_IN_THE_SCOPE_OF_NEW_TRANSACTION);
        return result;
    }

    @Override
    public boolean isAsyncModeSupported() {
        return false;
    }

    @Override
    public <T> CompletableFuture<CommandResult<T>> executeAsync(K key, Request<T> request) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected CompletableFuture<Void> removeAsync(Object key) {
        return null;
    }

    protected abstract SelectForUpdateBasedTransaction allocateTransaction(K var1, Optional<Long> var2);

    private <T> CommandResult<T> execute(Request<T> request, SelectForUpdateBasedTransaction transaction, Timeout timeout) {
        LockAndGetResult lockResult;
        RemoteCommand<T> command = request.getCommand();
        timeout.run(transaction::begin);
        try {
            lockResult = timeout.call(transaction::tryLockAndGet);
        }
        catch (Throwable t) {
            transaction.rollback();
            throw BucketExceptions.from(t);
        }
        if (!lockResult.isLocked()) {
            try {
                if (timeout.call(transaction::tryInsertEmptyData).booleanValue()) {
                    timeout.run(transaction::commit);
                } else {
                    transaction.rollback();
                }
                return RETRY_IN_THE_SCOPE_OF_NEW_TRANSACTION;
            }
            catch (Throwable t) {
                transaction.rollback();
                throw BucketExceptions.from(t);
            }
        }
        byte[] persistedDataOnBeginOfTransaction = lockResult.getData();
        if (persistedDataOnBeginOfTransaction == null && !request.getCommand().isInitializationCommand()) {
            transaction.rollback();
            return CommandResult.bucketNotFound();
        }
        try {
            MutableBucketEntry entry = new MutableBucketEntry(persistedDataOnBeginOfTransaction);
            CommandResult<T> result = command.execute(entry, super.getClientSideTime());
            if (entry.isStateModified()) {
                RemoteBucketState modifiedState = entry.get();
                byte[] bytes = entry.getStateBytes(request.getBackwardCompatibilityVersion());
                timeout.run(threshold -> transaction.update(bytes, modifiedState, (Optional<Long>)threshold));
            }
            timeout.run(transaction::commit);
            return result;
        }
        catch (Throwable t) {
            transaction.rollback();
            throw BucketExceptions.from(t);
        }
    }

    private static ClientSideConfig injectTimeClock(ClientSideConfig clientSideConfig) {
        if (clientSideConfig.getClientSideClock().isPresent()) {
            return clientSideConfig;
        }
        return clientSideConfig.withClientClock(TimeMeter.SYSTEM_MILLISECONDS);
    }

    protected void applyTimeout(PreparedStatement statement, Optional<Long> requestTimeoutNanos) throws SQLException {
        if (requestTimeoutNanos.isPresent()) {
            int timeoutSeconds = (int)Math.max(1L, TimeUnit.NANOSECONDS.toSeconds(requestTimeoutNanos.get()));
            statement.setQueryTimeout(timeoutSeconds);
        }
    }
}

