/*
 * Decompiled with CFR 0.152.
 */
package com.lordcodes.turtle;

import com.lordcodes.turtle.ArgumentsKt;
import com.lordcodes.turtle.Command;
import com.lordcodes.turtle.Executable;
import com.lordcodes.turtle.FileCommands;
import com.lordcodes.turtle.Platform;
import com.lordcodes.turtle.ShellRunException;
import com.lordcodes.turtle.ShellScript;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0006J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0012\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/lordcodes/turtle/FileCommands;", "", "shell", "Lcom/lordcodes/turtle/ShellScript;", "(Lcom/lordcodes/turtle/ShellScript;)V", "createSymlink", "", "targetPath", "Ljava/io/File;", "linkPath", "open", "url", "openApplication", "name", "openFile", "path", "readSymlink", "which", "command", "turtle"})
public final class FileCommands {
    @NotNull
    private final ShellScript shell;

    public FileCommands(@NotNull ShellScript shell) {
        Intrinsics.checkNotNullParameter((Object)shell, (String)"shell");
        this.shell = shell;
    }

    @NotNull
    public final String open(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.shell.multiplatform$turtle((Function1<? super Platform, Command>)((Function1)new Function1<Platform, Command>(url){
            final /* synthetic */ String $url;
            {
                this.$url = $url;
                super(1);
            }

            @Nullable
            public final Command invoke(@NotNull Platform platform) {
                Intrinsics.checkNotNullParameter((Object)((Object)platform), (String)"platform");
                return switch (open.WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
                    case 1 -> {
                        Object[] var2_2 = new Object[]{this.$url};
                        yield new Executable("xdg-open", null, 2, null).plus(ArgumentsKt.Arguments(var2_2));
                    }
                    case 2 -> {
                        Object[] var2_3 = new Object[]{this.$url};
                        yield new Executable("open", null, 2, null).plus(ArgumentsKt.Arguments(var2_3));
                    }
                    case 3 -> {
                        Object[] var2_4 = new Object[]{"/c", "start", this.$url};
                        yield new Executable("cmd.exe", null, 2, null).plus(ArgumentsKt.Arguments(var2_4));
                    }
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        }));
    }

    @NotNull
    public final String openFile(@NotNull File path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = path.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.open(string);
    }

    @NotNull
    public final String openFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.open(path);
    }

    @NotNull
    public final String openApplication(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.shell.multiplatform$turtle((Function1<? super Platform, Command>)((Function1)new Function1<Platform, Command>(name){
            final /* synthetic */ String $name;
            {
                this.$name = $name;
                super(1);
            }

            @Nullable
            public final Command invoke(@NotNull Platform platform) {
                Intrinsics.checkNotNullParameter((Object)((Object)platform), (String)"platform");
                return switch (openApplication.WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
                    case 1 -> null;
                    case 2 -> {
                        Object[] var2_2 = new Object[]{"-a", this.$name};
                        yield new Executable("open", null, 2, null).plus(ArgumentsKt.Arguments(var2_2));
                    }
                    case 3 -> null;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        }));
    }

    @NotNull
    public final String createSymlink(@NotNull File targetPath, @NotNull File linkPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter((Object)linkPath, (String)"linkPath");
        String string = targetPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string2 = linkPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return this.createSymlink(string, string2);
    }

    @NotNull
    public final String createSymlink(@NotNull String targetPath, @NotNull String linkPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        Intrinsics.checkNotNullParameter((Object)linkPath, (String)"linkPath");
        return this.shell.multiplatform$turtle((Function1<? super Platform, Command>)((Function1)new Function1<Platform, Command>(targetPath, linkPath){
            final /* synthetic */ String $targetPath;
            final /* synthetic */ String $linkPath;
            {
                this.$targetPath = $targetPath;
                this.$linkPath = $linkPath;
                super(1);
            }

            @Nullable
            public final Command invoke(@NotNull Platform platform) {
                Intrinsics.checkNotNullParameter((Object)((Object)platform), (String)"platform");
                return switch (createSymlink.WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
                    case 1 -> {
                        Object[] var2_2 = new Object[]{"-s", this.$targetPath, this.$linkPath};
                        yield new Executable("ln", null, 2, null).plus(ArgumentsKt.Arguments(var2_2));
                    }
                    case 2 -> {
                        Object[] var2_3 = new Object[]{"-s", this.$targetPath, this.$linkPath};
                        yield new Executable("ln", null, 2, null).plus(ArgumentsKt.Arguments(var2_3));
                    }
                    case 3 -> null;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        }));
    }

    @NotNull
    public final String readSymlink(@NotNull File linkPath) {
        Intrinsics.checkNotNullParameter((Object)linkPath, (String)"linkPath");
        String string = linkPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return this.readSymlink(string);
    }

    @NotNull
    public final String readSymlink(@NotNull String linkPath) {
        Intrinsics.checkNotNullParameter((Object)linkPath, (String)"linkPath");
        return this.shell.multiplatform$turtle((Function1<? super Platform, Command>)((Function1)new Function1<Platform, Command>(linkPath){
            final /* synthetic */ String $linkPath;
            {
                this.$linkPath = $linkPath;
                super(1);
            }

            @Nullable
            public final Command invoke(@NotNull Platform platform) {
                Intrinsics.checkNotNullParameter((Object)((Object)platform), (String)"platform");
                return switch (readSymlink.WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
                    case 1 -> {
                        Object[] var2_2 = new Object[]{this.$linkPath};
                        yield new Executable("readlink", null, 2, null).plus(ArgumentsKt.Arguments(var2_2));
                    }
                    case 2 -> {
                        Object[] var2_3 = new Object[]{this.$linkPath};
                        yield new Executable("readlink", null, 2, null).plus(ArgumentsKt.Arguments(var2_3));
                    }
                    case 3 -> null;
                    default -> throw new NoWhenBranchMatchedException();
                };
            }
        }));
    }

    @Nullable
    public final String which(@NotNull String command) {
        String string;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        try {
            string = this.shell.multiplatform$turtle((Function1<? super Platform, Command>)((Function1)new Function1<Platform, Command>(command){
                final /* synthetic */ String $command;
                {
                    this.$command = $command;
                    super(1);
                }

                @Nullable
                public final Command invoke(@NotNull Platform platform) {
                    Intrinsics.checkNotNullParameter((Object)((Object)platform), (String)"platform");
                    return switch (which.WhenMappings.$EnumSwitchMapping$0[platform.ordinal()]) {
                        case 1 -> {
                            Object[] var2_2 = new Object[]{this.$command};
                            yield new Executable("which", null, 2, null).plus(ArgumentsKt.Arguments(var2_2));
                        }
                        case 2 -> {
                            Object[] var2_3 = new Object[]{this.$command};
                            yield new Executable("which", null, 2, null).plus(ArgumentsKt.Arguments(var2_3));
                        }
                        case 3 -> null;
                        default -> throw new NoWhenBranchMatchedException();
                    };
                }
            }));
        }
        catch (ShellRunException ex) {
            string = null;
        }
        return string;
    }
}

