/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.usb.common;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.codecrete.usb.UsbAlternateInterface;
import net.codecrete.usb.UsbException;
import net.codecrete.usb.UsbInterface;
import org.jetbrains.annotations.NotNull;

public class UsbInterfaceImpl
implements UsbInterface {
    private final int interfaceNumber;
    private UsbAlternateInterface currentAlternate;
    private final List<UsbAlternateInterface> alternateInterfaces;
    private boolean claimed;

    public UsbInterfaceImpl(int number, List<UsbAlternateInterface> alternates) {
        this.interfaceNumber = number;
        this.alternateInterfaces = alternates;
        this.currentAlternate = alternates.getFirst();
        this.alternateInterfaces.sort(Comparator.comparingInt(UsbAlternateInterface::getNumber));
    }

    @Override
    public int getNumber() {
        return this.interfaceNumber;
    }

    @Override
    public boolean isClaimed() {
        return this.claimed;
    }

    public void setClaimed(boolean claimed) {
        this.claimed = claimed;
    }

    @Override
    @NotNull
    public UsbAlternateInterface getCurrentAlternate() {
        return this.currentAlternate;
    }

    @Override
    @NotNull
    public UsbAlternateInterface getAlternate(int alternateNumber) {
        return this.alternateInterfaces.stream().filter(alt -> alt.getNumber() == alternateNumber).findFirst().orElseThrow(() -> new UsbException(String.format("Interface %d does not have an alternate interface setting %d", this.interfaceNumber, alternateNumber)));
    }

    @Override
    @NotNull
    public List<UsbAlternateInterface> getAlternates() {
        return Collections.unmodifiableList(this.alternateInterfaces);
    }

    void addAlternate(UsbAlternateInterface alt) {
        this.alternateInterfaces.add(alt);
    }

    public void setAlternate(UsbAlternateInterface alternate) {
        this.currentAlternate = alternate;
    }
}

