/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.logfront.base;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.logfront.base.LogEvent;
import org.merlyn.logfront.base.LogLevel;
import org.merlyn.logfront.base.LogSetup;
import org.merlyn.logfront.base.LogSetupKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003J\u000e\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003J\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/merlyn/logfront/base/Logger;", "", "tag", "", "<init>", "(Ljava/lang/String;)V", "debug", "", "message", "info", "warn", "error", "throwable", "", "Companion", "logfront_base"})
public final class Logger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String tag;
    @NotNull
    private static LogSetup setup = LogSetupKt.getSetup();
    @NotNull
    private static final MutableSharedFlow<LogEvent> _logs = SharedFlowKt.MutableSharedFlow((int)0, (int)10, (BufferOverflow)BufferOverflow.DROP_OLDEST);
    @NotNull
    private static final SharedFlow<LogEvent> logs = FlowKt.asSharedFlow(_logs);

    private Logger(String tag) {
        this.tag = tag;
    }

    public final void debug(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.Companion.log(LogLevel.DEBUG, this.tag, message);
    }

    public final void info(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.Companion.log(LogLevel.INFO, this.tag, message);
    }

    public final void warn(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.Companion.log(LogLevel.WARN, this.tag, message);
    }

    public final void error(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Logger.Companion.log(LogLevel.ERROR, this.tag, message);
    }

    public final void error(@NotNull String message, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Logger.Companion.log(LogLevel.ERROR, this.tag, message, throwable);
    }

    public /* synthetic */ Logger(String tag, DefaultConstructorMarker $constructor_marker) {
        this(tag);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00112\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0015H\u0002J(\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/merlyn/logfront/base/Logger$Companion;", "", "<init>", "()V", "setup", "Lorg/merlyn/logfront/base/LogSetup;", "getSetup", "()Lorg/merlyn/logfront/base/LogSetup;", "setSetup", "(Lorg/merlyn/logfront/base/LogSetup;)V", "_logs", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lorg/merlyn/logfront/base/LogEvent;", "logs", "Lkotlinx/coroutines/flow/SharedFlow;", "getLogs", "()Lkotlinx/coroutines/flow/SharedFlow;", "", "getInstance", "Lorg/merlyn/logfront/base/Logger;", "name", "", "log", "logLevel", "Lorg/merlyn/logfront/base/LogLevel;", "tag", "message", "throwable", "", "logfront_base"})
    @SourceDebugExtension(value={"SMAP\nLogger.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Logger.kt\norg/merlyn/logfront/base/Logger$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n1#2:61\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LogSetup getSetup() {
            return setup;
        }

        public final void setSetup(@NotNull LogSetup logSetup) {
            Intrinsics.checkNotNullParameter((Object)logSetup, (String)"<set-?>");
            setup = logSetup;
        }

        @NotNull
        public final SharedFlow<LogEvent> getLogs() {
            return logs;
        }

        public final void setup(@Nullable LogSetup setup) {
            block0: {
                LogSetup logSetup = setup;
                if (logSetup == null) break block0;
                LogSetup it = logSetup;
                boolean bl = false;
                Companion.setSetup(it);
            }
        }

        public static /* synthetic */ void setup$default(Companion companion, LogSetup logSetup, int n, Object object) {
            if ((n & 1) != 0) {
                logSetup = null;
            }
            companion.setup(logSetup);
        }

        @NotNull
        public final Logger getInstance(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Logger(name, null);
        }

        private final void log(LogLevel logLevel, String tag, String message) {
            if (logLevel.compareTo((Enum)this.getSetup().getLogLevel()) >= 0) {
                _logs.tryEmit((Object)new LogEvent(logLevel, tag, message, null, 8, null));
            }
        }

        private final void log(LogLevel logLevel, String tag, String message, Throwable throwable) {
            if (logLevel.compareTo((Enum)this.getSetup().getLogLevel()) >= 0) {
                _logs.tryEmit((Object)new LogEvent(logLevel, tag, message, throwable));
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

