/*
 * Decompiled with CFR 0.152.
 */
package com.sksamuel.hoplite.watch.watchers;

import com.sksamuel.hoplite.watch.Watchable;
import com.sksamuel.hoplite.watch.watchers.FileWatcher;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\u0007H\u0002J*\u0010\f\u001a\u00020\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00070\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/sksamuel/hoplite/watch/watchers/FileWatcher;", "Lcom/sksamuel/hoplite/watch/Watchable;", "dir", "", "(Ljava/lang/String;)V", "cb", "Lkotlin/Function0;", "", "errorCallback", "Lkotlin/Function1;", "", "start", "watch", "callback", "errorHandler", "hoplite-watch"})
public final class FileWatcher
implements Watchable {
    @NotNull
    private final String dir;
    @NotNull
    private Function0<Unit> cb;
    @NotNull
    private Function1<? super Throwable, Unit> errorCallback;

    public FileWatcher(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        this.dir = dir;
        this.cb = cb.1.INSTANCE;
        this.errorCallback = errorCallback.1.INSTANCE;
    }

    @Override
    public void watch(@NotNull Function0<Unit> callback, @NotNull Function1<? super Throwable, Unit> errorHandler) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Intrinsics.checkNotNullParameter(errorHandler, (String)"errorHandler");
        this.cb = callback;
        this.errorCallback = errorHandler;
        this.start();
    }

    private final void start() {
        WatchService watchService = FileSystems.getDefault().newWatchService();
        Path pathToWatch = Paths.get(this.dir, new String[0]).toAbsolutePath();
        WatchEvent.Kind[] kindArray = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE};
        pathToWatch.register(watchService, kindArray);
        Executors.newSingleThreadExecutor().submit(() -> FileWatcher.start$lambda-0(watchService, this));
    }

    private static final void start$lambda-0(WatchService $watchService, FileWatcher this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        while (true) {
            try {
                WatchKey watchKey = $watchService.take();
                if (watchKey == null) continue;
                List<WatchEvent<?>> events = watchKey.pollEvents();
                if (events.size() > 0) {
                    this$0.cb.invoke();
                }
                if (watchKey.reset()) continue;
                watchKey.cancel();
                $watchService.close();
            }
            catch (Exception e) {
                this$0.errorCallback.invoke((Object)e);
                continue;
            }
            break;
        }
    }
}

