/*
 * Decompiled with CFR 0.152.
 */
package com.portaudio;

import com.portaudio.BlockingStream;
import com.portaudio.DeviceInfo;
import com.portaudio.FileUtils;
import com.portaudio.HostApiInfo;
import com.portaudio.StreamParameters;

public class PortAudio {
    public static final String VERSION = "0.1.0";
    public static final int FLAG_CLIP_OFF = 1;
    public static final int FLAG_DITHER_OFF = 2;
    public static final int FORMAT_FLOAT_32 = 1;
    public static final int FORMAT_INT_32 = 2;
    public static final int FORMAT_INT_24 = 4;
    public static final int FORMAT_INT_16 = 8;
    public static final int FORMAT_INT_8 = 16;
    public static final int FORMAT_UINT_8 = 32;
    public static final int HOST_API_TYPE_DEV = 0;
    public static final int HOST_API_TYPE_DIRECTSOUND = 1;
    public static final int HOST_API_TYPE_MME = 2;
    public static final int HOST_API_TYPE_ASIO = 3;
    public static final int HOST_API_TYPE_SOUNDMANAGER = 4;
    public static final int HOST_API_TYPE_COREAUDIO = 5;
    public static final int HOST_API_TYPE_OSS = 7;
    public static final int HOST_API_TYPE_ALSA = 8;
    public static final int HOST_API_TYPE_AL = 9;
    public static final int HOST_API_TYPE_BEOS = 10;
    public static final int HOST_API_TYPE_WDMKS = 11;
    public static final int HOST_API_TYPE_JACK = 12;
    public static final int HOST_API_TYPE_WASAPI = 13;
    public static final int HOST_API_TYPE_AUDIOSCIENCE = 14;
    public static final int HOST_API_TYPE_COUNT = 15;

    public static native int getVersion();

    public static native String getVersionText();

    public static native void initialize();

    public static native void terminate();

    public static native int getDeviceCount();

    private static native void getDeviceInfo(int var0, DeviceInfo var1);

    public static DeviceInfo getDeviceInfo(int index) {
        DeviceInfo deviceInfo = new DeviceInfo();
        PortAudio.getDeviceInfo(index, deviceInfo);
        return deviceInfo;
    }

    public static native int getHostApiCount();

    private static native void getHostApiInfo(int var0, HostApiInfo var1);

    public static HostApiInfo getHostApiInfo(int index) {
        HostApiInfo hostApiInfo = new HostApiInfo();
        PortAudio.getHostApiInfo(index, hostApiInfo);
        return hostApiInfo;
    }

    public static native int hostApiTypeIdToHostApiIndex(int var0);

    public static native int hostApiDeviceIndexToDeviceIndex(int var0, int var1);

    public static native int getDefaultInputDevice();

    public static native int getDefaultOutputDevice();

    public static native int getDefaultHostApi();

    public static native int isFormatSupported(StreamParameters var0, StreamParameters var1, int var2);

    private static native void openStream(BlockingStream var0, StreamParameters var1, StreamParameters var2, int var3, int var4, int var5);

    public static BlockingStream openStream(StreamParameters inputStreamParameters, StreamParameters outputStreamParameters, int sampleRate, int framesPerBuffer, int flags) {
        BlockingStream blockingStream = new BlockingStream();
        PortAudio.openStream(blockingStream, inputStreamParameters, outputStreamParameters, sampleRate, framesPerBuffer, flags);
        return blockingStream;
    }

    static {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.indexOf("win") >= 0) {
            if (System.getProperty("os.arch").contains("64")) {
                FileUtils.load("win/x64/portaudio.dll");
                FileUtils.load("win/x64/jportaudio_0_1_0.dll");
            } else {
                FileUtils.load("win/win32/portaudio.dll");
                FileUtils.load("win/win32/jportaudio_0_1_0.dll");
            }
        } else {
            FileUtils.load("darwin/libportaudio.dylib");
            FileUtils.load("darwin/libjportaudio_0_1_0.dylib");
        }
        System.out.println("---- JPortAudio 0.1.0, " + PortAudio.getVersionText());
    }
}

