/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.service.browser.applications;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.harawata.appdirs.AppDirs;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.os.OS;
import org.merlyn.desktopapp.service.browser.applications.BaseBrowserApplication;
import org.merlyn.desktopapp.storage.BrowserType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0012H\u0014J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000eX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lorg/merlyn/desktopapp/service/browser/applications/EdgeBrowserApplication;", "Lorg/merlyn/desktopapp/service/browser/applications/BaseBrowserApplication;", "appDirs", "Lnet/harawata/appdirs/AppDirs;", "hostOs", "Lorg/merlyn/desktopapp/os/OS;", "<init>", "(Lnet/harawata/appdirs/AppDirs;Lorg/merlyn/desktopapp/os/OS;)V", "type", "Lorg/merlyn/desktopapp/storage/BrowserType;", "getType", "()Lorg/merlyn/desktopapp/storage/BrowserType;", "applicationNames", "", "", "getApplicationNames", "()Ljava/util/List;", "getExecArguments", "", "specificUrlPrefix", "getSpecificUrlPrefix", "()Ljava/lang/String;", "getProfileFileLocation", "Ljava/nio/file/Path;", "getBookmarksUrl", "app"})
public final class EdgeBrowserApplication
extends BaseBrowserApplication {
    @NotNull
    private final BrowserType type;
    @NotNull
    private final List<String> applicationNames;
    @NotNull
    private final String specificUrlPrefix;

    public EdgeBrowserApplication(@NotNull AppDirs appDirs, @NotNull OS hostOs) {
        Intrinsics.checkNotNullParameter((Object)appDirs, (String)"appDirs");
        Intrinsics.checkNotNullParameter((Object)((Object)hostOs), (String)"hostOs");
        super(appDirs, hostOs);
        this.type = BrowserType.EDGE;
        Object[] objectArray = new String[]{"Microsoft Edge.app", "msedge.exe"};
        this.applicationNames = CollectionsKt.listOf((Object[])objectArray);
        this.specificUrlPrefix = "edge://";
    }

    @Override
    @NotNull
    public BrowserType getType() {
        return this.type;
    }

    @Override
    @NotNull
    public List<String> getApplicationNames() {
        return this.applicationNames;
    }

    @Override
    @NotNull
    protected Iterable<String> getExecArguments() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getHostOs().ordinal()]) {
            case 1 -> CollectionsKt.listOf((Object)"open -b com.microsoft.edgemac");
            case 2 -> CollectionsKt.listOf((Object)"start msedge");
            default -> throw new UnsupportedOperationException("Only supported Mac & Windows");
        };
    }

    @Override
    @NotNull
    protected String getSpecificUrlPrefix() {
        return this.specificUrlPrefix;
    }

    @Override
    @Nullable
    public Path getProfileFileLocation() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.getHostOs().ordinal()]) {
            case 1 -> {
                String[] var1_1 = new String[]{"Local State"};
                yield Paths.get(this.getAppDirs().getUserDataDir("Microsoft Edge", null, null), var1_1);
            }
            case 2 -> {
                String[] var1_2 = new String[]{"User Data", "Local State"};
                yield Paths.get(this.getAppDirs().getUserDataDir("Edge", null, "Microsoft"), var1_2);
            }
            default -> null;
        };
    }

    @Override
    @NotNull
    public String getBookmarksUrl() {
        return this.getSpecificUrlPrefix() + "favorites";
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OS.values().length];
            try {
                nArray[OS.MacOS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OS.Windows.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

