/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.service.browser.impl;

import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.service.browser.impl.ProcessParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\b\u0010\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0016\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u0004\u0018\u00010\u00052\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/merlyn/desktopapp/service/browser/impl/DefaultProcessParser;", "Lorg/merlyn/desktopapp/service/browser/impl/ProcessParser;", "<init>", "()V", "currentPid", "", "logger", "Lmu/KLogger;", "rejectedProcesses", "", "[Ljava/lang/String;", "isRejectedProcess", "", "command", "pidToCheck", "getHeaderRowBoundary", "", "process", "lines", "([Ljava/lang/String;)Ljava/lang/String;", "processRow", "row", "", "app"})
@SourceDebugExtension(value={"SMAP\nBrowserLookupImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserLookupImpl.kt\norg/merlyn/desktopapp/service/browser/impl/DefaultProcessParser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,167:1\n13805#2,2:168\n1#3:170\n*S KotlinDebug\n*F\n+ 1 BrowserLookupImpl.kt\norg/merlyn/desktopapp/service/browser/impl/DefaultProcessParser\n*L\n141#1:168,2\n*E\n"})
public class DefaultProcessParser
implements ProcessParser {
    @NotNull
    private final String currentPid = String.valueOf(ProcessHandle.current().pid());
    @NotNull
    private final KLogger logger = KotlinLogging.INSTANCE.logger(DefaultProcessParser::logger$lambda$0);
    @NotNull
    private final String[] rejectedProcesses;

    public DefaultProcessParser() {
        String[] stringArray = new String[]{"merlyn", "java"};
        this.rejectedProcesses = stringArray;
    }

    public boolean isRejectedProcess(@NotNull String command, @NotNull String pidToCheck) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)pidToCheck, (String)"pidToCheck");
        this.logger.debug(() -> DefaultProcessParser.isRejectedProcess$lambda$0(command, pidToCheck, this));
        String string = command.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (ArraysKt.contains((Object[])this.rejectedProcesses, (Object)string)) {
            return true;
        }
        return Intrinsics.areEqual((Object)this.currentPid, (Object)pidToCheck);
    }

    public int getHeaderRowBoundary() {
        return 1;
    }

    @Override
    @Nullable
    public String process(@NotNull String[] lines) {
        Intrinsics.checkNotNullParameter((Object)lines, (String)"lines");
        Object[] $this$forEach$iv = ArraysKt.copyOfRange((Object[])lines, (int)this.getHeaderRowBoundary(), (int)lines.length);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            CharSequence charSequence = line;
            Regex regex = new Regex("\\s+");
            int n = 0;
            String string = this.processRow(regex.split(charSequence, n));
            if (string == null) continue;
            String it = string;
            boolean bl2 = false;
            return it;
        }
        return null;
    }

    @Nullable
    public String processRow(@NotNull List<String> row) {
        Intrinsics.checkNotNullParameter(row, (String)"row");
        return !this.isRejectedProcess(row.get(0), row.get(1)) ? row.get(1) : null;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object isRejectedProcess$lambda$0(String $command, String $pidToCheck, DefaultProcessParser this$0) {
        CharSequence charSequence;
        CharSequence charSequence2 = $command;
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = "-unknown-";
        } else {
            charSequence = charSequence2;
        }
        return "Checking command \"" + charSequence + "\" with processId " + $pidToCheck + " against current " + this$0.currentPid;
    }
}

