/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.storage.credentials.impl;

import java.util.Optional;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.storage.TokenSecureData;
import org.merlyn.desktopapp.storage.credentials.TokenCredentialsStore;
import pt.davidafsilva.apple.OSXKeychain;
import pt.davidafsilva.apple.OSXKeychainException;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J&\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0003H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\b\u0010\u001b\u001a\u00020\u0011H\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/merlyn/desktopapp/storage/credentials/impl/MacTokenCredentialsStore;", "Lorg/merlyn/desktopapp/storage/credentials/TokenCredentialsStore;", "appName", "", "<init>", "(Ljava/lang/String;)V", "keyAccessToken", "keyRefreshToken", "keyIdToken", "keychain", "Lpt/davidafsilva/apple/OSXKeychain;", "kotlin.jvm.PlatformType", "logger", "Lmu/KLogger;", "get", "Lorg/merlyn/desktopapp/storage/TokenSecureData;", "set", "", "accessToken", "refreshToken", "idToken", "setNullableProperty", "", "account", "password", "updateOrCreate", "safeDelete", "clearAccessToken", "clear", "app"})
public final class MacTokenCredentialsStore
implements TokenCredentialsStore {
    @NotNull
    private final String appName;
    @NotNull
    private final String keyAccessToken;
    @NotNull
    private final String keyRefreshToken;
    @NotNull
    private final String keyIdToken;
    private final OSXKeychain keychain;
    @NotNull
    private final KLogger logger;

    public MacTokenCredentialsStore(@NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        this.appName = appName;
        this.keyAccessToken = "accessToken";
        this.keyRefreshToken = "refreshToken";
        this.keyIdToken = "idToken";
        this.keychain = OSXKeychain.getInstance();
        this.logger = KotlinLogging.INSTANCE.logger(MacTokenCredentialsStore::logger$lambda$0);
    }

    @Override
    @Nullable
    public TokenSecureData get() {
        TokenSecureData tokenSecureData;
        try {
            Optional optional = this.keychain.findGenericPassword(this.appName, this.keyAccessToken);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findGenericPassword(...)");
            String accessToken = (String)OptionalsKt.getOrNull((Optional)optional);
            Optional optional2 = this.keychain.findGenericPassword(this.appName, this.keyRefreshToken);
            Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"findGenericPassword(...)");
            String refreshToken = (String)OptionalsKt.getOrNull((Optional)optional2);
            Optional optional3 = this.keychain.findGenericPassword(this.appName, this.keyIdToken);
            Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"findGenericPassword(...)");
            String idToken = (String)OptionalsKt.getOrNull((Optional)optional3);
            tokenSecureData = accessToken != null || refreshToken != null || idToken != null ? new TokenSecureData(accessToken, refreshToken, idToken) : null;
        }
        catch (OSXKeychainException ex) {
            this.logger.error((Throwable)ex, MacTokenCredentialsStore::get$lambda$0);
            tokenSecureData = null;
        }
        return tokenSecureData;
    }

    @Override
    public boolean set(@Nullable String accessToken, @Nullable String refreshToken, @Nullable String idToken) {
        boolean bl;
        try {
            this.setNullableProperty(this.keyAccessToken, accessToken);
            this.setNullableProperty(this.keyRefreshToken, refreshToken);
            this.setNullableProperty(this.keyIdToken, idToken);
            bl = true;
        }
        catch (OSXKeychainException ex) {
            this.logger.error((Throwable)ex, MacTokenCredentialsStore::set$lambda$0);
            bl = false;
        }
        return bl;
    }

    private final void setNullableProperty(String account, String password) {
        if (password != null) {
            this.updateOrCreate(account, password);
        } else {
            this.safeDelete(account);
        }
    }

    private final void updateOrCreate(String account, String password) {
        if (this.keychain.findGenericPassword(this.appName, account).isEmpty()) {
            this.keychain.addGenericPassword(this.appName, account, password);
        } else {
            this.keychain.modifyGenericPassword(this.appName, account, password);
        }
    }

    private final void safeDelete(String account) {
        if (this.keychain.findGenericPassword(this.appName, account).isPresent()) {
            this.keychain.deleteGenericPassword(this.appName, account);
        }
    }

    @Override
    public boolean clearAccessToken() {
        boolean bl;
        try {
            this.safeDelete(this.keyAccessToken);
            bl = true;
        }
        catch (OSXKeychainException ex) {
            this.logger.error((Throwable)ex, MacTokenCredentialsStore::clearAccessToken$lambda$0);
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean clear() {
        boolean bl;
        try {
            this.safeDelete(this.keyAccessToken);
            this.safeDelete(this.keyRefreshToken);
            this.safeDelete(this.keyIdToken);
            bl = true;
        }
        catch (OSXKeychainException ex) {
            this.logger.error((Throwable)ex, MacTokenCredentialsStore::clear$lambda$0);
            bl = false;
        }
        return bl;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object get$lambda$0() {
        return "Error retrieving access, refresh and id tokens in the keychain";
    }

    private static final Object set$lambda$0() {
        return "Error storing access, refresh and id tokens in the keychain";
    }

    private static final Object clearAccessToken$lambda$0() {
        return "Error clearing access token from the keychain";
    }

    private static final Object clear$lambda$0() {
        return "Error clearing access, refresh and id tokens from the keychain";
    }
}

