/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.core.encryption;

import com.macasaet.fernet.Token;
import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.MGF1ParameterSpec;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0015\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/merlyn/core/encryption/Encryptor;", "", "base64PublicKey", "", "symmetricKey", "Lcom/macasaet/fernet/Key;", "<init>", "(Ljava/lang/String;Lcom/macasaet/fernet/Key;)V", "symmetricKeyEncrypted", "getSymmetricKeyEncrypted", "()Ljava/lang/String;", "publicKey", "getPublicKey", "encrypt", "content", "encrypt$sdkCore", "Companion", "sdkCore"})
public final class Encryptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final com.macasaet.fernet.Key symmetricKey;
    @NotNull
    private final String symmetricKeyEncrypted;
    @NotNull
    private final String publicKey;

    public Encryptor(@NotNull String base64PublicKey, @NotNull com.macasaet.fernet.Key symmetricKey) {
        Intrinsics.checkNotNullParameter((Object)base64PublicKey, (String)"base64PublicKey");
        Intrinsics.checkNotNullParameter((Object)symmetricKey, (String)"symmetricKey");
        this.symmetricKey = symmetricKey;
        byte[] byArray = Base64.getDecoder().decode(base64PublicKey);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
        byte[] byArray2 = byArray;
        this.publicKey = new String(byArray2, Charsets.UTF_8);
        Object object = new PEMParser((Reader)new StringReader(this.publicKey)).readObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.bouncycastle.asn1.x509.SubjectPublicKeyInfo");
        SubjectPublicKeyInfo keyInfo = (SubjectPublicKeyInfo)object;
        PublicKey publicKey = new JcaPEMKeyConverter().getPublicKey(keyInfo);
        Object object2 = Cipher.getInstance("RSA/ECB/OAEPWITHSHA-256ANDMGF1PADDING", "BC");
        Cipher $this$_init__u24lambda_u240 = object2;
        boolean bl = false;
        $this$_init__u24lambda_u240.init(1, (Key)publicKey, new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT));
        Cipher cipher = object2;
        Base64.Encoder encoder = Base64.getEncoder();
        String string = this.symmetricKey.serialise();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialise(...)");
        object2 = string;
        byte[] byArray3 = ((String)object2).getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"getBytes(...)");
        this.symmetricKeyEncrypted = encoder.encodeToString(cipher.doFinal(byArray3));
    }

    public /* synthetic */ Encryptor(String string, com.macasaet.fernet.Key key, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            key = com.macasaet.fernet.Key.generateKey();
        }
        this(string, key);
    }

    @NotNull
    public final String getSymmetricKeyEncrypted() {
        return this.symmetricKeyEncrypted;
    }

    @NotNull
    public final String getPublicKey() {
        return this.publicKey;
    }

    @NotNull
    public final String encrypt$sdkCore(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = Token.generate((com.macasaet.fernet.Key)this.symmetricKey, (String)content).serialise();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialise(...)");
        return string;
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lorg/merlyn/core/encryption/Encryptor$Companion;", "", "<init>", "()V", "sdkCore"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

