/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.metrics;

import io.sentry.IMetricsAggregator;
import io.sentry.ISpan;
import io.sentry.MeasurementUnit;
import io.sentry.metrics.LocalMetricsAggregator;
import io.sentry.metrics.MetricsHelper;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MetricsApi {
    @NotNull
    private final IMetricsInterface aggregator;

    public MetricsApi(@NotNull IMetricsInterface aggregator) {
        this.aggregator = aggregator;
    }

    public void increment(@NotNull String key) {
        this.increment(key, 1.0, null, null, null, 1);
    }

    public void increment(@NotNull String key, double value) {
        this.increment(key, value, null, null, null, 1);
    }

    public void increment(@NotNull String key, double value, @Nullable MeasurementUnit unit) {
        this.increment(key, value, unit, null, null, 1);
    }

    public void increment(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        this.increment(key, value, unit, tags, null, 1);
    }

    public void increment(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs) {
        this.increment(key, value, unit, tags, timestampMs, 1);
    }

    public void increment(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs, int stackLevel) {
        long timestamp = timestampMs != null ? timestampMs : System.currentTimeMillis();
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        this.aggregator.getMetricsAggregator().increment(key, value, unit, enrichedTags, timestamp, stackLevel, localMetricsAggregator);
    }

    public void gauge(@NotNull String key, double value) {
        this.gauge(key, value, null, null, null, 1);
    }

    public void gauge(@NotNull String key, double value, @Nullable MeasurementUnit unit) {
        this.gauge(key, value, unit, null, null, 1);
    }

    public void gauge(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        this.gauge(key, value, unit, tags, null, 1);
    }

    public void gauge(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs) {
        this.gauge(key, value, unit, tags, timestampMs, 1);
    }

    public void gauge(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs, int stackLevel) {
        long timestamp = timestampMs != null ? timestampMs : System.currentTimeMillis();
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        this.aggregator.getMetricsAggregator().gauge(key, value, unit, enrichedTags, timestamp, stackLevel, localMetricsAggregator);
    }

    public void distribution(@NotNull String key, double value) {
        this.distribution(key, value, null, null, null, 1);
    }

    public void distribution(@NotNull String key, double value, @Nullable MeasurementUnit unit) {
        this.distribution(key, value, unit, null, null, 1);
    }

    public void distribution(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        this.distribution(key, value, unit, tags, null, 1);
    }

    public void distribution(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs) {
        this.distribution(key, value, unit, tags, timestampMs, 1);
    }

    public void distribution(@NotNull String key, double value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs, int stackLevel) {
        long timestamp = timestampMs != null ? timestampMs : System.currentTimeMillis();
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        this.aggregator.getMetricsAggregator().distribution(key, value, unit, enrichedTags, timestamp, stackLevel, localMetricsAggregator);
    }

    public void set(@NotNull String key, int value) {
        this.set(key, value, null, null, null, 1);
    }

    public void set(@NotNull String key, int value, @Nullable MeasurementUnit unit) {
        this.set(key, value, unit, null, null, 1);
    }

    public void set(@NotNull String key, int value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        this.set(key, value, unit, tags, null, 1);
    }

    public void set(@NotNull String key, int value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs) {
        this.set(key, value, unit, tags, timestampMs, 1);
    }

    public void set(@NotNull String key, int value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs, int stackLevel) {
        long timestamp = timestampMs != null ? timestampMs : System.currentTimeMillis();
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        this.aggregator.getMetricsAggregator().set(key, value, unit, enrichedTags, timestamp, stackLevel, localMetricsAggregator);
    }

    public void set(@NotNull String key, @NotNull String value) {
        this.set(key, value, null, null, null, 1);
    }

    public void set(@NotNull String key, @NotNull String value, @Nullable MeasurementUnit unit) {
        this.set(key, value, unit, null, null, 1);
    }

    public void set(@NotNull String key, @NotNull String value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags) {
        this.set(key, value, unit, tags, null, 1);
    }

    public void set(@NotNull String key, @NotNull String value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs) {
        this.set(key, value, unit, tags, timestampMs, 1);
    }

    public void set(@NotNull String key, @NotNull String value, @Nullable MeasurementUnit unit, @Nullable Map<String, String> tags, @Nullable Long timestampMs, int stackLevel) {
        long timestamp = timestampMs != null ? timestampMs : System.currentTimeMillis();
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        this.aggregator.getMetricsAggregator().set(key, value, unit, enrichedTags, timestamp, stackLevel, localMetricsAggregator);
    }

    public void timing(@NotNull String key, @NotNull Runnable callback) {
        this.timing(key, callback, null, null, 1);
    }

    public void timing(@NotNull String key, @NotNull Runnable callback, @NotNull MeasurementUnit.Duration unit) {
        this.timing(key, callback, unit, null, 1);
    }

    public void timing(@NotNull String key, @NotNull Runnable callback, @NotNull MeasurementUnit.Duration unit, @Nullable Map<String, String> tags) {
        this.timing(key, callback, unit, tags, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timing(@NotNull String key, @NotNull Runnable callback, @Nullable MeasurementUnit.Duration unit, @Nullable Map<String, String> tags, int stackLevel) {
        @NotNull MeasurementUnit.Duration durationUnit = unit != null ? unit : MeasurementUnit.Duration.SECOND;
        @NotNull Map<String, String> enrichedTags = MetricsHelper.mergeTags(tags, this.aggregator.getDefaultTagsForMetrics());
        @Nullable LocalMetricsAggregator localMetricsAggregator = this.aggregator.getLocalMetricsAggregator();
        @Nullable ISpan span = this.aggregator.startSpanForMetric("metric.timing", key);
        if (span != null && tags != null) {
            for (Map.Entry<String, String> entry : tags.entrySet()) {
                span.setTag(entry.getKey(), entry.getValue());
            }
        }
        try {
            this.aggregator.getMetricsAggregator().timing(key, callback, durationUnit, enrichedTags, stackLevel, localMetricsAggregator);
        }
        finally {
            if (span != null) {
                span.finish();
            }
        }
    }

    @ApiStatus.Internal
    public static interface IMetricsInterface {
        @NotNull
        public IMetricsAggregator getMetricsAggregator();

        @Nullable
        public LocalMetricsAggregator getLocalMetricsAggregator();

        @NotNull
        public Map<String, String> getDefaultTagsForMetrics();

        @Nullable
        public ISpan startSpanForMetric(@NotNull String var1, @NotNull String var2);
    }
}

