/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.dataplatform;

import java.time.Instant;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.merlyn.dataplatform.FieldType;
import org.merlyn.dataplatform.ModalityType;
import org.merlyn.dataplatform.OutcomeType;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0010\t\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u000bJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\tJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0010J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u001c\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00000\u0011J\u0016\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u0016\u0010\u0017\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u0014\u0010\u0019\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0011J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0005J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\tR&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/merlyn/dataplatform/EventBuilder;", "", "()V", "data", "", "", "Lkotlin/Pair;", "Lorg/merlyn/dataplatform/FieldType;", "skipMessage", "", "get", "", "set", "key", "value", "", "", "", "setAction", "setAgent", "name", "version", "setClientId", "setEncrypted", "setIntent", "setIntents", "setModalityType", "Lorg/merlyn/dataplatform/ModalityType;", "setOperation", "setOutcomeType", "Lorg/merlyn/dataplatform/OutcomeType;", "shouldSkip", "Companion", "data-platform-api"})
public final class EventBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Pair<FieldType, Object>> data = new LinkedHashMap();
    private boolean skipMessage;

    private EventBuilder() {
    }

    @NotNull
    public final EventBuilder set(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.data.put(key, (Pair<FieldType, Object>)new Pair((Object)FieldType.STRING, (Object)value));
        return this;
    }

    @NotNull
    public final EventBuilder setAction(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.set("action", value);
    }

    @NotNull
    public final EventBuilder setIntent(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.set("intent", value);
    }

    @NotNull
    public final EventBuilder setIntents(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.data.put("intents", (Pair<FieldType, Object>)new Pair((Object)FieldType.STRING_LIST, value));
        return this;
    }

    @NotNull
    public final EventBuilder setModalityType(@NotNull ModalityType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        return this.set("modalityType", value.getText());
    }

    @NotNull
    public final EventBuilder setOutcomeType(@NotNull OutcomeType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        return this.set("outcomeType", value.getText());
    }

    @NotNull
    public final EventBuilder setOperation(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.set("operation", value);
    }

    @NotNull
    public final EventBuilder setAgent(@NotNull String name, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        return this.set("agentName", name).set("agentVersion", version);
    }

    @NotNull
    public final EventBuilder setClientId(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CharSequence charSequence = value;
        Regex regex = new Regex("--");
        int n = 0;
        List parts = regex.split(charSequence, n);
        if (parts.size() == 2) {
            String subId = (String)parts.get(0);
            String sessionId = (String)parts.get(1);
            this.data.put("userId", (Pair<FieldType, Object>)new Pair((Object)FieldType.STRING, (Object)subId));
            if (StringsKt.startsWith$default((String)sessionId, (String)"00000000-0000-0000-1e31-", (boolean)false, (int)2, null)) {
                this.skipMessage = true;
            }
        } else if (parts.size() == 1) {
            this.data.put("userId", (Pair<FieldType, Object>)new Pair((Object)FieldType.STRING, (Object)value));
        }
        return this;
    }

    @NotNull
    public final EventBuilder setEncrypted(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.data.put(key, (Pair<FieldType, Object>)new Pair((Object)FieldType.ENCRYPTED_STRING, (Object)value));
        return this;
    }

    @NotNull
    public final EventBuilder set(@NotNull String key, int value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.data.put(key, (Pair<FieldType, Object>)new Pair((Object)FieldType.INT, (Object)value));
        return this;
    }

    @NotNull
    public final EventBuilder set(@NotNull String key, @NotNull EventBuilder value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.data.put(key, (Pair<FieldType, Object>)new Pair((Object)FieldType.EVENT, (Object)value));
        return this;
    }

    @NotNull
    public final EventBuilder set(@NotNull String key, @NotNull List<EventBuilder> value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.data.put(key, (Pair<FieldType, Object>)new Pair((Object)FieldType.EVENT_LIST, value));
        return this;
    }

    @NotNull
    public final EventBuilder set(@NotNull String key, long value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.data.put(key, (Pair<FieldType, Object>)new Pair((Object)FieldType.LONG, (Object)value));
        return this;
    }

    @NotNull
    public final EventBuilder set(@NotNull String key, boolean value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.data.put(key, (Pair<FieldType, Object>)new Pair((Object)FieldType.BOOLEAN, (Object)value));
        return this;
    }

    @NotNull
    public final Map<String, Pair<FieldType, Object>> get() {
        return MapsKt.toMap(this.data);
    }

    public final boolean shouldSkip() {
        return this.skipMessage;
    }

    @JvmStatic
    @NotNull
    public static final EventBuilder create(@NotNull String type) {
        return Companion.create(type);
    }

    @JvmStatic
    @NotNull
    public static final EventBuilder create(@NotNull String type, @NotNull Instant instant) {
        return Companion.create(type, instant);
    }

    @JvmStatic
    @NotNull
    public static final EventBuilder create(@NotNull String type, @NotNull Instant instant, @NotNull String uuid) {
        return Companion.create(type, instant, uuid);
    }

    @JvmStatic
    @NotNull
    public static final EventBuilder create(@NotNull String type, @NotNull String requestId) {
        return Companion.create(type, requestId);
    }

    @JvmStatic
    @NotNull
    public static final EventBuilder subMessage() {
        return Companion.subMessage();
    }

    public /* synthetic */ EventBuilder(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0006H\u0007J\b\u0010\u000b\u001a\u00020\u0004H\u0007\u00a8\u0006\f"}, d2={"Lorg/merlyn/dataplatform/EventBuilder$Companion;", "", "()V", "create", "Lorg/merlyn/dataplatform/EventBuilder;", "type", "", "instant", "Ljava/time/Instant;", "uuid", "requestId", "subMessage", "data-platform-api"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final EventBuilder create(@NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            EventBuilder event = new EventBuilder(null);
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            event.set("uuid", string);
            event.set("eventTypeId", type);
            event.set("destination", "DATA_PLATFORM");
            event.set("timestamp", Instant.now().toEpochMilli());
            return event;
        }

        @JvmStatic
        @NotNull
        public final EventBuilder create(@NotNull String type, @NotNull Instant instant) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            EventBuilder event = this.create(type);
            event.set("timestamp", instant.toEpochMilli());
            return event;
        }

        @JvmStatic
        @NotNull
        public final EventBuilder create(@NotNull String type, @NotNull Instant instant, @NotNull String uuid) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            EventBuilder event = this.create(type);
            event.set("timestamp", instant.toEpochMilli());
            event.set("uuid", uuid);
            return event;
        }

        @JvmStatic
        @NotNull
        public final EventBuilder create(@NotNull String type, @NotNull String requestId) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)requestId, (String)"requestId");
            EventBuilder event = this.create(type);
            event.set("requestId", requestId);
            return event;
        }

        @JvmStatic
        @NotNull
        public final EventBuilder subMessage() {
            return new EventBuilder(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

