/*
 * Decompiled with CFR 0.152.
 */
package com.lordcodes.turtle;

import com.lordcodes.turtle.Arguments;
import com.lordcodes.turtle.ArgumentsKt;
import com.lordcodes.turtle.Executable;
import com.lordcodes.turtle.ShellCommandNotFoundException;
import com.lordcodes.turtle.ShellExecutableNotFoundException;
import com.lordcodes.turtle.ShellFailedException;
import com.lordcodes.turtle.ShellRunException;
import com.lordcodes.turtle.ShellScript;
import com.lordcodes.turtle.WithArgument;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0086\u0002J\u0017\u0010\r\u001a\u00020\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0086\u0002J\u001d\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J$\u0010\u0018\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00120\u001cJ\u0010\u0010\u001e\u001a\u00020\u00122\b\b\u0002\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010!\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0017\u0010!\u001a\u00020\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005H\u0086\u0002J\u0011\u0010\"\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\u0017\u0010\"\u001a\u00020\u00002\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00100\u0014H\u0086\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lcom/lordcodes/turtle/Command;", "", "executable", "Lcom/lordcodes/turtle/Executable;", "arguments", "Lcom/lordcodes/turtle/Arguments;", "(Lcom/lordcodes/turtle/Executable;Lcom/lordcodes/turtle/Arguments;)V", "getArguments", "()Lcom/lordcodes/turtle/Arguments;", "getExecutable", "()Lcom/lordcodes/turtle/Executable;", "component1", "component2", "contains", "", "withArgument", "Lcom/lordcodes/turtle/WithArgument;", "argument", "", "withArguments", "", "copy", "equals", "other", "executeOrElse", "shellScript", "Lcom/lordcodes/turtle/ShellScript;", "onError", "Lkotlin/Function1;", "", "executeOrThrow", "hashCode", "", "minus", "plus", "quoteArgumentIfNecessary", "toString", "turtle"})
@SourceDebugExtension(value={"SMAP\nCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Command.kt\ncom/lordcodes/turtle/Command\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,201:1\n1083#2,2:202\n*S KotlinDebug\n*F\n+ 1 Command.kt\ncom/lordcodes/turtle/Command\n*L\n160#1:202,2\n*E\n"})
public final class Command {
    @NotNull
    private final Executable executable;
    @NotNull
    private final Arguments arguments;

    public Command(@NotNull Executable executable, @NotNull Arguments arguments) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        this.executable = executable;
        this.arguments = arguments;
    }

    public /* synthetic */ Command(Executable executable, Arguments arguments, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            arguments = new Arguments(CollectionsKt.emptyList());
        }
        this(executable, arguments);
    }

    @NotNull
    public final Executable getExecutable() {
        return this.executable;
    }

    @NotNull
    public final Arguments getArguments() {
        return this.arguments;
    }

    @NotNull
    public final Command plus(@NotNull Arguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return Command.copy$default(this, null, this.arguments.plus(arguments), 1, null);
    }

    @NotNull
    public final Command plus(@NotNull Iterable<? extends WithArgument> withArguments) {
        Intrinsics.checkNotNullParameter(withArguments, (String)"withArguments");
        return Command.copy$default(this, null, this.arguments.plus(withArguments), 1, null);
    }

    @NotNull
    public final Command plus(@NotNull WithArgument withArgument) {
        Intrinsics.checkNotNullParameter((Object)withArgument, (String)"withArgument");
        return Command.copy$default(this, null, this.arguments.plus(withArgument), 1, null);
    }

    @NotNull
    public final Command minus(@NotNull Arguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return Command.copy$default(this, null, this.arguments.minus(arguments), 1, null);
    }

    @NotNull
    public final Command minus(@NotNull Iterable<? extends WithArgument> withArguments) {
        Intrinsics.checkNotNullParameter(withArguments, (String)"withArguments");
        return Command.copy$default(this, null, this.arguments.minus(CollectionsKt.toSet(withArguments)), 1, null);
    }

    @NotNull
    public final Command minus(@NotNull WithArgument withArgument) {
        Intrinsics.checkNotNullParameter((Object)withArgument, (String)"withArgument");
        return Command.copy$default(this, null, this.arguments.minus(withArgument), 1, null);
    }

    public final boolean contains(@NotNull Arguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return this.arguments.containsAll(arguments);
    }

    public final boolean contains(@NotNull Iterable<? extends WithArgument> withArguments) {
        Intrinsics.checkNotNullParameter(withArguments, (String)"withArguments");
        Object[] objectArray = new Object[]{withArguments};
        return this.contains(ArgumentsKt.Arguments(objectArray));
    }

    public final boolean contains(@NotNull String argument) {
        Intrinsics.checkNotNullParameter((Object)argument, (String)"argument");
        return this.contains(new Arguments(CollectionsKt.listOf((Object)argument)));
    }

    public final boolean contains(@NotNull WithArgument withArgument) {
        Intrinsics.checkNotNullParameter((Object)withArgument, (String)"withArgument");
        Object[] objectArray = new Object[]{withArgument};
        return this.contains(ArgumentsKt.Arguments(objectArray));
    }

    @NotNull
    public String toString() {
        return this.executable.getName() + " " + CollectionsKt.joinToString$default((Iterable)this.arguments, (CharSequence)" ", null, null, (int)0, null, (Function1)((Function1)new Function1<String, String>((Object)this){

            @NotNull
            public final String invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return Command.access$quoteArgumentIfNecessary((Command)this.receiver, p0);
            }
        }), (int)30, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String quoteArgumentIfNecessary(String argument) {
        Object object;
        char[] cArray = new char[]{'\''};
        String string = StringsKt.trim((String)argument, (char[])cArray);
        cArray = new char[]{'\"'};
        String string2 = StringsKt.trim((String)string, (char[])cArray);
        cArray = new char[]{'\''};
        String unquoted = StringsKt.trim((String)string2, (char[])cArray);
        String unescaped = StringsKt.replace$default((String)StringsKt.replace$default((String)unquoted, (String)"\\'", (String)"'", (boolean)false, (int)4, null), (String)"\\\"", (String)"\"", (boolean)false, (int)4, null);
        if (!StringsKt.isBlank((CharSequence)unquoted)) {
            boolean bl;
            block3: {
                CharSequence $this$any$iv = unquoted;
                boolean $i$f$any = false;
                for (int i = 0; i < $this$any$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$any$iv.charAt(i);
                    boolean bl2 = false;
                    if (!StringsKt.contains$default((CharSequence)" '\"", (char)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
            if (!bl) {
                object = unescaped;
                return object;
            }
        }
        object = "'" + unescaped + "'";
        return object;
    }

    @NotNull
    public final String executeOrThrow(@NotNull ShellScript shellScript) {
        String string;
        Intrinsics.checkNotNullParameter((Object)shellScript, (String)"shellScript");
        try {
            string = ShellScript.command$default(shellScript, this.executable.getName(), this.arguments, null, 4, null);
        }
        catch (ShellCommandNotFoundException ex) {
            throw new ShellExecutableNotFoundException(this.executable, (Throwable)ex);
        }
        return string;
    }

    public static /* synthetic */ String executeOrThrow$default(Command command, ShellScript shellScript, int n, Object object) {
        if ((n & 1) != 0) {
            shellScript = new ShellScript(null, false, 3, null);
        }
        return command.executeOrThrow(shellScript);
    }

    @NotNull
    public final String executeOrElse(@NotNull ShellScript shellScript, @NotNull Function1<? super Throwable, String> onError) {
        String string;
        Intrinsics.checkNotNullParameter((Object)shellScript, (String)"shellScript");
        Intrinsics.checkNotNullParameter(onError, (String)"onError");
        try {
            string = ShellScript.command$default(shellScript, this.executable.getName(), this.arguments, null, 4, null);
        }
        catch (ShellCommandNotFoundException ex) {
            string = (String)onError.invoke((Object)new ShellExecutableNotFoundException(this.executable, ex.getCause()));
        }
        catch (ShellFailedException ex) {
            string = (String)onError.invoke((Object)ex);
        }
        catch (ShellRunException ex) {
            string = (String)onError.invoke((Object)ex);
        }
        return string;
    }

    public static /* synthetic */ String executeOrElse$default(Command command, ShellScript shellScript, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            shellScript = new ShellScript(null, false, 3, null);
        }
        return command.executeOrElse(shellScript, (Function1<? super Throwable, String>)function1);
    }

    @NotNull
    public final Executable component1() {
        return this.executable;
    }

    @NotNull
    public final Arguments component2() {
        return this.arguments;
    }

    @NotNull
    public final Command copy(@NotNull Executable executable, @NotNull Arguments arguments) {
        Intrinsics.checkNotNullParameter((Object)executable, (String)"executable");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return new Command(executable, arguments);
    }

    public static /* synthetic */ Command copy$default(Command command, Executable executable, Arguments arguments, int n, Object object) {
        if ((n & 1) != 0) {
            executable = command.executable;
        }
        if ((n & 2) != 0) {
            arguments = command.arguments;
        }
        return command.copy(executable, arguments);
    }

    public int hashCode() {
        int result = this.executable.hashCode();
        result = result * 31 + this.arguments.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Command)) {
            return false;
        }
        Command command = (Command)other;
        if (!Intrinsics.areEqual((Object)this.executable, (Object)command.executable)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.arguments, (Object)command.arguments);
    }

    public static final /* synthetic */ String access$quoteArgumentIfNecessary(Command $this, String argument) {
        return $this.quoteArgumentIfNecessary(argument);
    }
}

