/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.timers;

import com.ibm.icu.text.RuleBasedNumberFormat;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u0004H\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/merlyn/timers/OrdinalUtils;", "", "locale", "Lkotlinx/coroutines/flow/StateFlow;", "", "<init>", "(Lkotlinx/coroutines/flow/StateFlow;)V", "getLocale", "()Lkotlinx/coroutines/flow/StateFlow;", "currentRuleBasedFormatLocale", "Lkotlinx/coroutines/flow/MutableStateFlow;", "ruleBasedNumberFormat", "Lcom/ibm/icu/text/RuleBasedNumberFormat;", "replaceOrdinalFormatter", "", "Companion", "timers"})
@SourceDebugExtension(value={"SMAP\nOrdinalUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OrdinalUtils.kt\norg/merlyn/timers/OrdinalUtils\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,75:1\n230#2,5:76\n230#2,5:81\n*S KotlinDebug\n*F\n+ 1 OrdinalUtils.kt\norg/merlyn/timers/OrdinalUtils\n*L\n24#1:76,5\n25#1:81,5\n*E\n"})
public final class OrdinalUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StateFlow<String> locale;
    @NotNull
    private final MutableStateFlow<String> currentRuleBasedFormatLocale;
    @NotNull
    private final MutableStateFlow<RuleBasedNumberFormat> ruleBasedNumberFormat;
    private static OrdinalUtils instance;
    @NotNull
    private static final Regex ordinalIncorrectFormatRegex;

    public OrdinalUtils(@NotNull StateFlow<String> locale) {
        Intrinsics.checkNotNullParameter(locale, (String)"locale");
        this.locale = locale;
        this.currentRuleBasedFormatLocale = StateFlowKt.MutableStateFlow((Object)this.locale.getValue());
        this.ruleBasedNumberFormat = StateFlowKt.MutableStateFlow((Object)new RuleBasedNumberFormat(Locale.forLanguageTag((String)this.locale.getValue()), 2));
    }

    @NotNull
    public final StateFlow<String> getLocale() {
        return this.locale;
    }

    private final void replaceOrdinalFormatter(String locale) {
        String it;
        String nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<String> $this$update$iv = this.currentRuleBasedFormatLocale;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (String)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = locale)));
        $this$update$iv = this.ruleBasedNumberFormat;
        $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (RuleBasedNumberFormat)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = new RuleBasedNumberFormat(Locale.forLanguageTag(locale), 2))));
    }

    static {
        ordinalIncorrectFormatRegex = new Regex("^(\\d+)([\u00ba\u00aa])\\.?$");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\tJ\n\u0010\f\u001a\u00020\t*\u00020\rJ\u0011\u0010\u000e\u001a\u00020\t*\u00020\tH\u0001\u00a2\u0006\u0002\b\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/merlyn/timers/OrdinalUtils$Companion;", "", "<init>", "()V", "instance", "Lorg/merlyn/timers/OrdinalUtils;", "initialize", "locale", "Lkotlinx/coroutines/flow/StateFlow;", "", "replaceLocale", "", "ordinal", "", "fixSpanishFormatting", "fixSpanishFormatting$timers", "ordinalIncorrectFormatRegex", "Lkotlin/text/Regex;", "timers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OrdinalUtils initialize(@NotNull StateFlow<String> locale) {
            Intrinsics.checkNotNullParameter(locale, (String)"locale");
            instance = new OrdinalUtils(locale);
            OrdinalUtils ordinalUtils = instance;
            if (ordinalUtils == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                ordinalUtils = null;
            }
            return ordinalUtils;
        }

        public final void replaceLocale(@NotNull String locale) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            OrdinalUtils ordinalUtils = instance;
            if (ordinalUtils == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                ordinalUtils = null;
            }
            ordinalUtils.replaceOrdinalFormatter(locale);
        }

        @NotNull
        public final String ordinal(int $this$ordinal) {
            OrdinalUtils ordinalUtils;
            OrdinalUtils ordinalUtils2 = instance;
            if (ordinalUtils2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                ordinalUtils2 = null;
            }
            Object object = ordinalUtils2.currentRuleBasedFormatLocale.getValue();
            OrdinalUtils ordinalUtils3 = instance;
            if (ordinalUtils3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                ordinalUtils3 = null;
            }
            if (!Intrinsics.areEqual((Object)object, (Object)ordinalUtils3.getLocale().getValue())) {
                OrdinalUtils ordinalUtils4;
                OrdinalUtils ordinalUtils5 = instance;
                if (ordinalUtils5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                    ordinalUtils5 = null;
                }
                if ((ordinalUtils4 = instance) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                    ordinalUtils4 = null;
                }
                ordinalUtils5.replaceOrdinalFormatter((String)ordinalUtils4.getLocale().getValue());
            }
            if ((ordinalUtils = instance) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"instance");
                ordinalUtils = null;
            }
            String string = ((RuleBasedNumberFormat)ordinalUtils.ruleBasedNumberFormat.getValue()).format((Object)$this$ordinal);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return this.fixSpanishFormatting$timers(string);
        }

        @VisibleForTesting
        @NotNull
        public final String fixSpanishFormatting$timers(@NotNull String $this$fixSpanishFormatting) {
            Intrinsics.checkNotNullParameter((Object)$this$fixSpanishFormatting, (String)"<this>");
            return ordinalIncorrectFormatRegex.containsMatchIn((CharSequence)$this$fixSpanishFormatting) ? ordinalIncorrectFormatRegex.replace((CharSequence)$this$fixSpanishFormatting, "$1.$2") : $this$fixSpanishFormatting;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

