/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.coresdk;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.coresdk.DecodedJwt;
import org.merlyn.desktopapp.coresdk.DecodedJwtImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\u0003J\u0006\u0010\f\u001a\u00020\u0003J\u0006\u0010\r\u001a\u00020\u0003J\u0006\u0010\u000e\u001a\u00020\u0003J\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/merlyn/desktopapp/coresdk/JWTToken;", "", "token", "", "<init>", "(Ljava/lang/String;)V", "getToken", "()Ljava/lang/String;", "jwt", "Lorg/merlyn/desktopapp/coresdk/DecodedJwt;", "getClaim", "claimName", "getSubject", "getExpiration", "getOriginTokenId", "getCognitoClaims", "", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "app"})
@SourceDebugExtension(value={"SMAP\nJWTToken.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JWTToken.kt\norg/merlyn/desktopapp/coresdk/JWTToken\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/JsonKt\n*L\n1#1,60:1\n1#2:61\n222#3:62\n*S KotlinDebug\n*F\n+ 1 JWTToken.kt\norg/merlyn/desktopapp/coresdk/JWTToken\n*L\n30#1:62\n*E\n"})
public final class JWTToken {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String token;
    @NotNull
    private final DecodedJwt jwt;
    private static final Logger logger = LoggerFactory.getLogger(Companion.getClass());

    public JWTToken(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.token = token;
        this.jwt = new DecodedJwtImpl(this.token);
    }

    @NotNull
    public final String getToken() {
        return this.token;
    }

    @NotNull
    public final String getClaim(@NotNull String claimName) {
        String string;
        Intrinsics.checkNotNullParameter((Object)claimName, (String)"claimName");
        JsonElement jsonElement = (JsonElement)this.jwt.getPayload().get((Object)claimName);
        String claimValue = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null;
        CharSequence charSequence = claimValue;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            logger.debug("Failed to get claim " + claimName);
        }
        if ((string = claimValue) == null) {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String getSubject() {
        return this.getClaim("sub");
    }

    @NotNull
    public final String getExpiration() {
        return this.getClaim("exp");
    }

    @NotNull
    public final String getOriginTokenId() {
        return this.getClaim("origin_jti");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getCognitoClaims() {
        Object object;
        block3: {
            block2: {
                void $this$decodeFromJsonElement$iv;
                object = (JsonElement)this.jwt.getPayload().get((Object)"cognito:groups");
                if (object == null || (object = JsonElementKt.getJsonArray((JsonElement)object)) == null) break block2;
                Object it = object;
                boolean bl = false;
                Json json2 = (Json)Json.Default;
                Object json$iv = it;
                boolean $i$f$decodeFromJsonElement = false;
                $this$decodeFromJsonElement$iv.getSerializersModule();
                List list = (List)$this$decodeFromJsonElement$iv.decodeFromJsonElement((DeserializationStrategy)BuiltinSerializersKt.getNullable((KSerializer)new ArrayListSerializer((KSerializer)StringSerializer.INSTANCE)), json$iv);
                object = list;
                if (list != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final String component1() {
        return this.token;
    }

    @NotNull
    public final JWTToken copy(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        return new JWTToken(token);
    }

    public static /* synthetic */ JWTToken copy$default(JWTToken jWTToken, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = jWTToken.token;
        }
        return jWTToken.copy(string);
    }

    @NotNull
    public String toString() {
        return "JWTToken(token=" + this.token + ")";
    }

    public int hashCode() {
        return this.token.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JWTToken)) {
            return false;
        }
        JWTToken jWTToken = (JWTToken)other;
        return Intrinsics.areEqual((Object)this.token, (Object)jWTToken.token);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/merlyn/desktopapp/coresdk/JWTToken$Companion;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

