/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.http;

import io.ktor.client.HttpClient;
import io.ktor.client.HttpClientConfig;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.config.StageConfig;
import org.merlyn.desktopapp.http.OAuth2Helper;
import org.merlyn.desktopapp.http.TokenData;
import org.merlyn.desktopapp.http.TokenResponse;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u000bJ\u000e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u000bH\u0086@\u00a2\u0006\u0002\u0010\u0016J\"\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u001cH\u0082@\u00a2\u0006\u0002\u0010\u001dJ\b\u0010\u001e\u001a\u00020\u000bH\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/merlyn/desktopapp/http/OAuth2Helper;", "", "config", "Lorg/merlyn/desktopapp/config/StageConfig;", "client", "Lio/ktor/client/HttpClient;", "<init>", "(Lorg/merlyn/desktopapp/config/StageConfig;Lio/ktor/client/HttpClient;)V", "charset", "Ljava/nio/charset/Charset;", "contentType", "", "logger", "Lmu/KLogger;", "verifier", "getLoginUrl", "getLogoutUrl", "changeRegion", "", "retrieveDataFromCode", "Lorg/merlyn/desktopapp/http/TokenData;", "code", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "retrieveDataFromRefreshToken", "refreshToken", "getToken", "Lorg/merlyn/desktopapp/http/TokenResponse;", "query", "", "(Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createVerifier", "createChallenge", "app"})
@SourceDebugExtension(value={"SMAP\nOAuth2Helper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OAuth2Helper.kt\norg/merlyn/desktopapp/http/OAuth2Helper\n+ 2 builders.kt\nio/ktor/client/request/BuildersKt\n+ 3 RequestBody.kt\nio/ktor/client/request/RequestBodyKt\n+ 4 TypeInfoJvm.kt\nio/ktor/util/reflect/TypeInfoJvmKt\n+ 5 HttpClientCall.kt\nio/ktor/client/call/HttpClientCallKt\n*L\n1#1,148:1\n233#2:149\n109#2,2:167\n22#2:169\n16#3,4:150\n21#3,10:157\n17#4,3:154\n17#4,3:171\n17#4,3:175\n155#5:170\n155#5:174\n*S KotlinDebug\n*F\n+ 1 OAuth2Helper.kt\norg/merlyn/desktopapp/http/OAuth2Helper\n*L\n107#1:149\n107#1:167,2\n107#1:169\n110#1:150,4\n110#1:157,10\n110#1:154,3\n114#1:171,3\n119#1:175,3\n114#1:170\n119#1:174\n*E\n"})
public final class OAuth2Helper {
    @NotNull
    private final StageConfig config;
    @NotNull
    private final HttpClient client;
    @NotNull
    private final Charset charset;
    @NotNull
    private final String contentType;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final String verifier;

    public OAuth2Helper(@NotNull StageConfig config, @NotNull HttpClient client) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.config = config;
        this.client = client.config(OAuth2Helper::client$lambda$0);
        this.charset = Charsets.UTF_8;
        this.contentType = "content-type";
        this.logger = KotlinLogging.INSTANCE.logger(OAuth2Helper::logger$lambda$0);
        this.verifier = this.createVerifier();
    }

    @NotNull
    public final String getLoginUrl() {
        this.logger.debug(OAuth2Helper::getLoginUrl$lambda$0);
        String challenge = this.createChallenge(this.verifier);
        String encodedRedirectUri = URLEncoder.encode(this.config.getApplicationConfig().getAuthRedirectUrl(), this.charset);
        String encodedScope = URLEncoder.encode(this.config.getApplicationConfig().getAuthScopes(), this.charset);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"response_type", (Object)"code"), TuplesKt.to((Object)"access_type", (Object)"offline"), TuplesKt.to((Object)"protocol", (Object)"oauth2"), TuplesKt.to((Object)"code_challenge_method", (Object)"S256"), TuplesKt.to((Object)"code_challenge", (Object)challenge), TuplesKt.to((Object)"client_id", (Object)this.config.getEnvironmentConfig().getAuthClientId()), TuplesKt.to((Object)"redirect_uri", (Object)encodedRedirectUri), TuplesKt.to((Object)"scope", (Object)encodedScope)};
        Map query = MapsKt.mapOf((Pair[])pairArray);
        String url = "https://" + this.config.getEnvironmentConfig().getAuthDomain() + "/oauth2/authorize?" + CollectionsKt.joinToString$default((Iterable)query.entrySet(), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        this.logger.debug(() -> OAuth2Helper.getLoginUrl$lambda$1(url));
        return url;
    }

    @NotNull
    public final String getLogoutUrl(boolean changeRegion) {
        this.logger.debug(OAuth2Helper::getLogoutUrl$lambda$0);
        String encodedRedirectUri = URLEncoder.encode(this.config.getApplicationConfig().getAuthLogoutRedirectUrl(), this.charset);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"client_id", (Object)this.config.getEnvironmentConfig().getAuthClientId()), TuplesKt.to((Object)"response_type", (Object)"code"), TuplesKt.to((Object)"logout_uri", (Object)encodedRedirectUri), TuplesKt.to((Object)"change_region", (Object)changeRegion)};
        Map query = MapsKt.mapOf((Pair[])pairArray);
        String url = "https://" + this.config.getEnvironmentConfig().getAuthDomain() + "/logout?" + CollectionsKt.joinToString$default((Iterable)query.entrySet(), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        this.logger.debug(() -> OAuth2Helper.getLogoutUrl$lambda$1(url));
        return url;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveDataFromCode(@NotNull String code, @NotNull Continuation<? super TokenData> $completion) {
        if (!($completion instanceof retrieveDataFromCode.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ OAuth2Helper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveDataFromCode(null, (Continuation<? super TokenData>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"authorization_code"), TuplesKt.to((Object)"client_id", (Object)this.config.getEnvironmentConfig().getAuthClientId()), TuplesKt.to((Object)"code_verifier", (Object)this.verifier), TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"redirect_uri", (Object)URLEncoder.encode(this.config.getApplicationConfig().getAuthRedirectUrl(), this.charset))};
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)code);
                $continuation.label = 1;
                v0 = this.getToken(MapsKt.mapOf((Pair[])var4_6), (Continuation<? super TokenResponse>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                code = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                token = (TokenResponse)v0;
                return new TokenData(token.getAccessToken(), token.getRefreshToken(), token.getIdToken());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object retrieveDataFromRefreshToken(@NotNull String refreshToken, @NotNull Continuation<? super TokenData> $completion) {
        if (!($completion instanceof retrieveDataFromRefreshToken.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ OAuth2Helper this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.retrieveDataFromRefreshToken(null, (Continuation<? super TokenData>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_6 = new Pair[]{TuplesKt.to((Object)"grant_type", (Object)"refresh_token"), TuplesKt.to((Object)"client_id", (Object)this.config.getEnvironmentConfig().getAuthClientId()), TuplesKt.to((Object)"code_verifier", (Object)this.verifier), TuplesKt.to((Object)"refresh_token", (Object)refreshToken)};
                $continuation.L$0 = refreshToken;
                $continuation.label = 1;
                v0 = this.getToken(MapsKt.mapOf((Pair[])var4_6), (Continuation<? super TokenResponse>)$continuation);
                if (v0 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl23
            }
            case 1: {
                refreshToken = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl23:
                // 2 sources

                token = (TokenResponse)v0;
                v1 = token.getAccessToken();
                v2 = token.getRefreshToken();
                if (v2 == null) {
                    v2 = refreshToken;
                }
                return new TokenData(v1, v2, token.getIdToken());
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Exception decompiling
     */
    private final Object getToken(Map<String, String> query, Continuation<? super TokenResponse> $completion) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[SWITCH], 7[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final String createVerifier() {
        SecureRandom sr = new SecureRandom();
        byte[] code = new byte[32];
        sr.nextBytes(code);
        String string = Base64.getUrlEncoder().withoutPadding().encodeToString(code);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(...)");
        return string;
    }

    private final String createChallenge(String verifier) {
        byte[] byArray = verifier.getBytes(Charsets.US_ASCII);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(bytes, 0, bytes.length);
        byte[] digest = md.digest();
        String string = org.apache.commons.codec.binary.Base64.encodeBase64URLSafeString((byte[])digest);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeBase64URLSafeString(...)");
        return string;
    }

    private static final Unit client$lambda$0(HttpClientConfig $this$config) {
        Intrinsics.checkNotNullParameter((Object)$this$config, (String)"$this$config");
        $this$config.setExpectSuccess(false);
        return Unit.INSTANCE;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object getLoginUrl$lambda$0() {
        return "Handling get login url function";
    }

    private static final Object getLoginUrl$lambda$1(String $url) {
        return "Generated the following URL for auth: " + $url;
    }

    private static final Object getLogoutUrl$lambda$0() {
        return "Handling get logout url function";
    }

    private static final Object getLogoutUrl$lambda$1(String $url) {
        return "Generated the following URL for logout auth: " + $url;
    }

    private static final Object getToken$lambda$1(Exception $ex) {
        return "Error getting token: " + $ex.getMessage();
    }

    public static final /* synthetic */ Object access$getToken(OAuth2Helper $this, Map query, Continuation $completion) {
        return $this.getToken(query, (Continuation<? super TokenResponse>)$completion);
    }
}

