/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.http.commands.impl;

import ch.qos.logback.classic.Level;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import mu.KLogger;
import mu.KotlinLogging;
import net.logstash.logback.marker.LogstashMarker;
import net.logstash.logback.marker.Markers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.http.commands.CommandHandler;
import org.merlyn.desktopapp.http.commands.UnableToHandleException;
import org.merlyn.desktopapp.http.commands.impl.MetricType;
import org.merlyn.desktopapp.log.LogbackService;
import org.merlyn.desktopapp.log.layout.LogDefinitionsKt;
import org.slf4j.Marker;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0096@\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\n \u0019*\u0004\u0018\u00010\n0\n2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\b\u001a\"\u0012\u0004\u0012\u00020\n\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r\u0012\u0004\u0012\u00020\u000e0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00070\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/merlyn/desktopapp/http/commands/impl/LogBatch;", "Lorg/merlyn/desktopapp/http/commands/CommandHandler;", "logbackService", "Lorg/merlyn/desktopapp/log/LogbackService;", "<init>", "(Lorg/merlyn/desktopapp/log/LogbackService;)V", "ceLogger", "Lmu/KLogger;", "logFunctions", "", "Lch/qos/logback/classic/Level;", "Lkotlin/Function2;", "Lnet/logstash/logback/marker/LogstashMarker;", "", "", "metricLoggers", "Lorg/merlyn/desktopapp/http/commands/impl/MetricType;", "handle", "e", "Lkotlinx/serialization/json/JsonObject;", "(Lkotlinx/serialization/json/JsonObject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isMetric", "logItem", "Lkotlinx/serialization/json/JsonElement;", "getLevelFromChromeExtensionLog", "kotlin.jvm.PlatformType", "element", "app"})
@SourceDebugExtension(value={"SMAP\nLogBatch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LogBatch.kt\norg/merlyn/desktopapp/http/commands/impl/LogBatch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n1869#2,2:82\n*S KotlinDebug\n*F\n+ 1 LogBatch.kt\norg/merlyn/desktopapp/http/commands/impl/LogBatch\n*L\n47#1:82,2\n*E\n"})
public final class LogBatch
implements CommandHandler {
    @NotNull
    private final KLogger ceLogger;
    @NotNull
    private final Map<Level, Function2<LogstashMarker, String, Unit>> logFunctions;
    @NotNull
    private final Map<MetricType, KLogger> metricLoggers;

    public LogBatch(@NotNull LogbackService logbackService) {
        Intrinsics.checkNotNullParameter((Object)logbackService, (String)"logbackService");
        this.ceLogger = KotlinLogging.INSTANCE.logger(logbackService.getChromeExtensionLogger());
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)Level.INFO, (Object)new Function2<Marker, String, Unit>((Object)this.ceLogger){

            public final void invoke(Marker p0, String p1) {
                ((KLogger)this.receiver).info(p0, p1);
            }
        }), TuplesKt.to((Object)Level.WARN, (Object)new Function2<Marker, String, Unit>((Object)this.ceLogger){

            public final void invoke(Marker p0, String p1) {
                ((KLogger)this.receiver).warn(p0, p1);
            }
        }), TuplesKt.to((Object)Level.ERROR, (Object)new Function2<Marker, String, Unit>((Object)this.ceLogger){

            public final void invoke(Marker p0, String p1) {
                ((KLogger)this.receiver).error(p0, p1);
            }
        }), TuplesKt.to((Object)Level.TRACE, (Object)new Function2<Marker, String, Unit>((Object)this.ceLogger){

            public final void invoke(Marker p0, String p1) {
                ((KLogger)this.receiver).trace(p0, p1);
            }
        }), TuplesKt.to((Object)Level.DEBUG, (Object)new Function2<Marker, String, Unit>((Object)this.ceLogger){

            public final void invoke(Marker p0, String p1) {
                ((KLogger)this.receiver).debug(p0, p1);
            }
        })};
        this.logFunctions = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)((Object)MetricType.METRICS_DATA_PLATFORM), (Object)KotlinLogging.INSTANCE.logger(logbackService.getMetricsLogger())), TuplesKt.to((Object)((Object)MetricType.METRICS_ORR), (Object)KotlinLogging.INSTANCE.logger(logbackService.getMetricsLogger()))};
        this.metricLoggers = MapsKt.mapOf((Pair[])pairArray);
    }

    @Override
    @Nullable
    public Object handle(@NotNull JsonObject e, @NotNull Continuation<? super Unit> $completion) {
        JsonElement jsonElement = (JsonElement)e.get((Object)"logs");
        if (jsonElement == null || (jsonElement = JsonElementKt.getJsonArray((JsonElement)jsonElement)) == null) {
            throw new UnableToHandleException("Logs are not is not present in this message");
        }
        JsonElement logs = jsonElement;
        Iterable $this$forEach$iv = (Iterable)logs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsonElement it = (JsonElement)element$iv;
            boolean bl = false;
            MetricType metricType = this.isMetric(it);
            if (metricType != null) {
                JsonElement jsonElement2 = (JsonElement)JsonElementKt.getJsonObject((JsonElement)it).get((Object)"mdc");
                JsonElement metricData = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonObject((JsonElement)jsonElement2)) != null && (jsonElement2 = (JsonElement)jsonElement2.get((Object)"data")) != null ? LogDefinitionsKt.toJsonElement(jsonElement2) : null;
                if (metricData == null) continue;
                KLogger kLogger = this.metricLoggers.get((Object)metricType);
                if (kLogger != null) {
                    kLogger.info(metricData.toString());
                }
                continue;
            }
            Function2<LogstashMarker, String, Unit> function2 = this.logFunctions.get(this.getLevelFromChromeExtensionLog(it));
            if (function2 == null) continue;
            LogstashMarker logstashMarker = Markers.appendRaw((String)"ChromeExtension", (String)it.toString());
            Intrinsics.checkNotNullExpressionValue((Object)logstashMarker, (String)"appendRaw(...)");
            function2.invoke((Object)logstashMarker, null);
        }
        return Unit.INSTANCE;
    }

    private final MetricType isMetric(JsonElement logItem) {
        String string;
        JsonElement jsonElement = (JsonElement)JsonElementKt.getJsonObject((JsonElement)logItem).get((Object)"mdc");
        JsonElement message = jsonElement != null && (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) != null ? (JsonElement)jsonElement.get((Object)"message") : null;
        JsonElement jsonElement2 = message;
        String string2 = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? jsonElement2.getContent() : (string = null);
        if (Intrinsics.areEqual((Object)string, (Object)"METRICS_DATA_PLATFORM")) {
            return MetricType.METRICS_DATA_PLATFORM;
        }
        if (Intrinsics.areEqual((Object)string, (Object)"METRICS_ORR")) {
            return MetricType.METRICS_ORR;
        }
        return null;
    }

    private final Level getLevelFromChromeExtensionLog(JsonElement element) {
        JsonElement jsonElement = (JsonElement)JsonElementKt.getJsonObject((JsonElement)element).get((Object)"level");
        return Level.toLevel(jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null);
    }
}

