/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.storage.credentials.impl;

import com.microsoft.alm.secret.Credential;
import com.microsoft.alm.secret.Secret;
import com.microsoft.alm.storage.windows.CredManagerBackedCredentialStore;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.desktopapp.storage.TokenSecureData;
import org.merlyn.desktopapp.storage.credentials.TokenCredentialsStore;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J&\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u0016J\"\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0002J\"\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u0003H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/merlyn/desktopapp/storage/credentials/impl/WindowsTokenCredentialsStore;", "Lorg/merlyn/desktopapp/storage/credentials/TokenCredentialsStore;", "appName", "", "<init>", "(Ljava/lang/String;)V", "keyAccessToken", "keyRefreshToken", "keyIdToken", "userAccessToken", "userRefreshToken", "userIdToken", "credentialStore", "Lcom/microsoft/alm/storage/windows/CredManagerBackedCredentialStore;", "logger", "Lmu/KLogger;", "get", "Lorg/merlyn/desktopapp/storage/TokenSecureData;", "set", "", "accessToken", "refreshToken", "idToken", "setNullableProperty", "credentialKey", "secretKey", "password", "setProperty", "clearAccessToken", "clear", "app"})
public final class WindowsTokenCredentialsStore
implements TokenCredentialsStore {
    @NotNull
    private final String keyAccessToken;
    @NotNull
    private final String keyRefreshToken;
    @NotNull
    private final String keyIdToken;
    @NotNull
    private final String userAccessToken;
    @NotNull
    private final String userRefreshToken;
    @NotNull
    private final String userIdToken;
    @NotNull
    private final CredManagerBackedCredentialStore credentialStore;
    @NotNull
    private final KLogger logger;

    public WindowsTokenCredentialsStore(@NotNull String appName) {
        Intrinsics.checkNotNullParameter((Object)appName, (String)"appName");
        this.keyAccessToken = appName + "_accessToken";
        this.keyRefreshToken = appName + "_refreshToken";
        this.keyIdToken = appName + "_idToken";
        this.userAccessToken = "accessToken";
        this.userRefreshToken = "refreshToken";
        this.userIdToken = "idToken";
        this.credentialStore = new CredManagerBackedCredentialStore();
        this.logger = KotlinLogging.INSTANCE.logger(WindowsTokenCredentialsStore::logger$lambda$0);
    }

    @Override
    @Nullable
    public TokenSecureData get() {
        Credential credential = (Credential)this.credentialStore.get(this.keyAccessToken);
        String accessToken = credential != null ? credential.Password : null;
        Credential credential2 = (Credential)this.credentialStore.get(this.keyRefreshToken);
        String refreshToken = credential2 != null ? credential2.Password : null;
        Credential credential3 = (Credential)this.credentialStore.get(this.keyIdToken);
        String idToken = credential3 != null ? credential3.Password : null;
        return accessToken != null || refreshToken != null || idToken != null ? new TokenSecureData(accessToken, refreshToken, idToken) : null;
    }

    @Override
    public boolean set(@Nullable String accessToken, @Nullable String refreshToken, @Nullable String idToken) {
        return this.setNullableProperty(this.keyAccessToken, this.userAccessToken, accessToken) && this.setNullableProperty(this.keyRefreshToken, this.userRefreshToken, refreshToken) && this.setNullableProperty(this.keyIdToken, this.userIdToken, idToken);
    }

    private final boolean setNullableProperty(String credentialKey, String secretKey, String password) {
        return password != null ? this.setProperty(credentialKey, secretKey, password) : this.credentialStore.delete(credentialKey);
    }

    private final boolean setProperty(String credentialKey, String secretKey, String password) {
        if (!this.credentialStore.add(credentialKey, (Secret)new Credential(secretKey, password))) {
            this.logger.error(() -> WindowsTokenCredentialsStore.setProperty$lambda$0(credentialKey, secretKey));
            return false;
        }
        return true;
    }

    @Override
    public boolean clearAccessToken() {
        boolean result = this.credentialStore.delete(this.keyAccessToken);
        if (!result) {
            this.logger.error(WindowsTokenCredentialsStore::clearAccessToken$lambda$0);
        }
        return result;
    }

    @Override
    public boolean clear() {
        boolean result;
        boolean bl = result = this.credentialStore.delete(this.keyAccessToken) && this.credentialStore.delete(this.keyRefreshToken) && this.credentialStore.delete(this.keyIdToken);
        if (!result) {
            this.logger.error(WindowsTokenCredentialsStore::clear$lambda$0);
        }
        return result;
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object setProperty$lambda$0(String $credentialKey, String $secretKey) {
        return "Error storing key: " + $credentialKey + " and secret: " + $secretKey + " in the keychain (reason should be in the previous log)";
    }

    private static final Object clearAccessToken$lambda$0() {
        return "Error clearing access token from the keychain (reason should be in the previous log)";
    }

    private static final Object clear$lambda$0() {
        return "Error clearing access, refresh and id tokens from the keychain (reason should be in the previous log)";
    }
}

