/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.desktopapp.storage.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogger;
import mu.KotlinLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\r0\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\tR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/merlyn/desktopapp/storage/database/LoggingEventDatabaseDao;", "", "connection", "Ljava/sql/Connection;", "<init>", "(Ljava/sql/Connection;)V", "logger", "Lmu/KLogger;", "insert", "", "timestamp", "", "entry", "", "queryAll", "", "Lkotlin/Triple;", "limit", "", "delete", "", "id", "vacuumDatabase", "Companion", "app"})
public final class LoggingEventDatabaseDao {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Connection connection;
    @NotNull
    private final KLogger logger;
    @NotNull
    public static final String CREATE_TABLE_SQL = "\n            CREATE TABLE IF NOT EXISTS log (\n                id integer PRIMARY KEY,\n                timestamp integer NOT NULL,\n                entry blob NOT NULL\n            );\n        ";
    @NotNull
    public static final String VACUUM_SQLITE = "VACUUM;";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LoggingEventDatabaseDao(@Nullable Connection connection) {
        this.connection = connection;
        this.logger = KotlinLogging.INSTANCE.logger(LoggingEventDatabaseDao::logger$lambda$0);
        AutoCloseable autoCloseable = this.connection;
        if (autoCloseable != null && (autoCloseable = autoCloseable.createStatement()) != null) {
            AutoCloseable autoCloseable2 = autoCloseable;
            Throwable throwable = null;
            try {
                Boolean bl;
                Statement it = (Statement)autoCloseable2;
                boolean bl2 = false;
                try {
                    bl = it.execute(CREATE_TABLE_SQL);
                }
                catch (SQLException ex) {
                    this.logger.error((Throwable)ex, LoggingEventDatabaseDao::lambda$0$0);
                    bl = Unit.INSTANCE;
                }
                Boolean bl3 = bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void insert(long timestamp, @NotNull byte[] entry) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            try {
                AutoCloseable autoCloseable = this.connection;
                if (autoCloseable == null || (autoCloseable = autoCloseable.prepareStatement("INSERT INTO log (timestamp, entry) VALUES(?, ?);")) == null) break block7;
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    PreparedStatement it = (PreparedStatement)autoCloseable2;
                    boolean bl = false;
                    it.setLong(1, timestamp);
                    it.setBytes(2, entry);
                    Integer n = it.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            }
            catch (SQLException ex) {
                this.logger.error((Throwable)ex, LoggingEventDatabaseDao::insert$lambda$1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Triple<Long, Long, byte[]>> queryAll(int limit) {
        List list;
        List list2;
        if (limit <= 0) {
            return CollectionsKt.emptyList();
        }
        try {
            List list3;
            AutoCloseable autoCloseable = this.connection;
            if (autoCloseable != null && (autoCloseable = autoCloseable.createStatement()) != null) {
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    List list4;
                    Statement it = (Statement)autoCloseable2;
                    boolean bl = false;
                    ResultSet resultSet = it.executeQuery("SELECT id, timestamp, entry FROM log ORDER BY timestamp ASC LIMIT " + limit + ";");
                    List $this$queryAll_u24lambda_u240_u240 = list4 = CollectionsKt.createListBuilder();
                    boolean bl2 = false;
                    while (resultSet.next()) {
                        long id = resultSet.getLong(1);
                        long timestamp = resultSet.getLong(2);
                        byte[] entry = resultSet.getBytes(3);
                        $this$queryAll_u24lambda_u240_u240.add(new Triple((Object)id, (Object)timestamp, (Object)entry));
                    }
                    List list5 = CollectionsKt.build((List)list4);
                    list3 = list5;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            } else {
                list3 = null;
            }
            list2 = list3;
        }
        catch (SQLException ex) {
            this.logger.error((Throwable)ex, LoggingEventDatabaseDao::queryAll$lambda$1);
            list2 = null;
        }
        if ((list = list2) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean delete(long id) {
        Boolean bl;
        try {
            Boolean bl2;
            AutoCloseable autoCloseable = this.connection;
            if (autoCloseable != null && (autoCloseable = autoCloseable.createStatement()) != null) {
                AutoCloseable autoCloseable2 = autoCloseable;
                Throwable throwable = null;
                try {
                    Statement it = (Statement)autoCloseable2;
                    boolean bl3 = false;
                    Boolean bl4 = it.executeUpdate("DELETE FROM log WHERE id = " + id + ";") > 0;
                    bl2 = bl4;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
                }
            } else {
                bl2 = null;
            }
            bl = bl2;
        }
        catch (SQLException ex) {
            this.logger.error((Throwable)ex, LoggingEventDatabaseDao::delete$lambda$1);
            bl = false;
        }
        Boolean bl5 = bl;
        return bl5 != null ? bl5 : false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void vacuumDatabase() {
        AutoCloseable autoCloseable = this.connection;
        if (autoCloseable != null && (autoCloseable = autoCloseable.createStatement()) != null) {
            AutoCloseable autoCloseable2 = autoCloseable;
            Throwable throwable = null;
            try {
                Boolean bl;
                Statement it = (Statement)autoCloseable2;
                boolean bl2 = false;
                try {
                    bl = it.execute(VACUUM_SQLITE);
                }
                catch (SQLException ex) {
                    this.logger.error((Throwable)ex, LoggingEventDatabaseDao::vacuumDatabase$lambda$0$0);
                    bl = Unit.INSTANCE;
                }
                Boolean bl3 = bl;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable);
            }
        }
    }

    private static final Unit logger$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Object lambda$0$0() {
        return "Unable to create emergency logger temporary table";
    }

    private static final Object insert$lambda$1() {
        return "Unable to insert log entry in the database";
    }

    private static final Object queryAll$lambda$1() {
        return "Unable to query log entries in the database";
    }

    private static final Object delete$lambda$1() {
        return "Unable to delete old log entry";
    }

    private static final Object vacuumDatabase$lambda$0$0() {
        return "Unable to vacuum sqlite database";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/merlyn/desktopapp/storage/database/LoggingEventDatabaseDao$Companion;", "", "<init>", "()V", "CREATE_TABLE_SQL", "", "VACUUM_SQLITE", "app"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

