/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.message.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Generated;
import org.merlyn.message.model.MARData;

@Generated(from="MARData", generator="Immutables")
public final class ImmutableMARData
extends MARData {
    private final MARData.Version marVersion;
    private final MARData.Type type;
    private final @Nullable String clientId;
    private final @Nullable String subject;
    private final @Nullable String agentName;
    private final @Nullable String agentVersion;
    private final @Nullable String tabId;

    private ImmutableMARData(MARData.Version marVersion, MARData.Type type, @Nullable String clientId, @Nullable String subject, @Nullable String agentName, @Nullable String agentVersion, @Nullable String tabId) {
        this.marVersion = marVersion;
        this.type = type;
        this.clientId = clientId;
        this.subject = subject;
        this.agentName = agentName;
        this.agentVersion = agentVersion;
        this.tabId = tabId;
    }

    @Override
    @JsonProperty(value="marVersion")
    public MARData.Version marVersion() {
        return this.marVersion;
    }

    @Override
    @JsonProperty(value="type")
    public MARData.Type type() {
        return this.type;
    }

    @Override
    @JsonProperty(value="clientId")
    public @Nullable String clientId() {
        return this.clientId;
    }

    @Override
    @JsonProperty(value="subject")
    public @Nullable String subject() {
        return this.subject;
    }

    @Override
    @JsonProperty(value="agentName")
    public @Nullable String agentName() {
        return this.agentName;
    }

    @Override
    @JsonProperty(value="agentVersion")
    public @Nullable String agentVersion() {
        return this.agentVersion;
    }

    @Override
    @JsonProperty(value="tabId")
    public @Nullable String tabId() {
        return this.tabId;
    }

    public final ImmutableMARData withMarVersion(MARData.Version value) {
        MARData.Version newValue = Objects.requireNonNull(value, "marVersion");
        if (this.marVersion == newValue) {
            return this;
        }
        return new ImmutableMARData(newValue, this.type, this.clientId, this.subject, this.agentName, this.agentVersion, this.tabId);
    }

    public final ImmutableMARData withType(MARData.Type value) {
        MARData.Type newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new ImmutableMARData(this.marVersion, newValue, this.clientId, this.subject, this.agentName, this.agentVersion, this.tabId);
    }

    public final ImmutableMARData withClientId(@Nullable String value) {
        if (Objects.equals(this.clientId, value)) {
            return this;
        }
        return new ImmutableMARData(this.marVersion, this.type, value, this.subject, this.agentName, this.agentVersion, this.tabId);
    }

    public final ImmutableMARData withSubject(@Nullable String value) {
        if (Objects.equals(this.subject, value)) {
            return this;
        }
        return new ImmutableMARData(this.marVersion, this.type, this.clientId, value, this.agentName, this.agentVersion, this.tabId);
    }

    public final ImmutableMARData withAgentName(@Nullable String value) {
        if (Objects.equals(this.agentName, value)) {
            return this;
        }
        return new ImmutableMARData(this.marVersion, this.type, this.clientId, this.subject, value, this.agentVersion, this.tabId);
    }

    public final ImmutableMARData withAgentVersion(@Nullable String value) {
        if (Objects.equals(this.agentVersion, value)) {
            return this;
        }
        return new ImmutableMARData(this.marVersion, this.type, this.clientId, this.subject, this.agentName, value, this.tabId);
    }

    public final ImmutableMARData withTabId(@Nullable String value) {
        if (Objects.equals(this.tabId, value)) {
            return this;
        }
        return new ImmutableMARData(this.marVersion, this.type, this.clientId, this.subject, this.agentName, this.agentVersion, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMARData && this.equalTo(0, (ImmutableMARData)another);
    }

    private boolean equalTo(int synthetic, ImmutableMARData another) {
        return this.marVersion.equals((Object)another.marVersion) && this.type.equals((Object)another.type) && Objects.equals(this.clientId, another.clientId) && Objects.equals(this.subject, another.subject) && Objects.equals(this.agentName, another.agentName) && Objects.equals(this.agentVersion, another.agentVersion) && Objects.equals(this.tabId, another.tabId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.marVersion.hashCode();
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.clientId);
        h += (h << 5) + Objects.hashCode(this.subject);
        h += (h << 5) + Objects.hashCode(this.agentName);
        h += (h << 5) + Objects.hashCode(this.agentVersion);
        h += (h << 5) + Objects.hashCode(this.tabId);
        return h;
    }

    public String toString() {
        return "MARData{marVersion=" + this.marVersion + ", type=" + this.type + ", clientId=" + this.clientId + ", subject=" + this.subject + ", agentName=" + this.agentName + ", agentVersion=" + this.agentVersion + ", tabId=" + this.tabId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableMARData fromJson(Json json) {
        Builder builder = ImmutableMARData.builder();
        if (json.marVersion != null) {
            builder.marVersion(json.marVersion);
        }
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.clientId != null) {
            builder.clientId(json.clientId);
        }
        if (json.subject != null) {
            builder.subject(json.subject);
        }
        if (json.agentName != null) {
            builder.agentName(json.agentName);
        }
        if (json.agentVersion != null) {
            builder.agentVersion(json.agentVersion);
        }
        if (json.tabId != null) {
            builder.tabId(json.tabId);
        }
        return builder.build();
    }

    public static ImmutableMARData copyOf(MARData instance) {
        if (instance instanceof ImmutableMARData) {
            return (ImmutableMARData)instance;
        }
        return ImmutableMARData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MARData", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_MAR_VERSION = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        private MARData.Version marVersion;
        private MARData.Type type;
        private @Nullable String clientId;
        private @Nullable String subject;
        private @Nullable String agentName;
        private @Nullable String agentVersion;
        private @Nullable String tabId;

        private Builder() {
        }

        public final Builder from(MARData instance) {
            String tabIdValue;
            String agentVersionValue;
            String agentNameValue;
            String subjectValue;
            Objects.requireNonNull(instance, "instance");
            this.marVersion(instance.marVersion());
            this.type(instance.type());
            @Nullable String clientIdValue = instance.clientId();
            if (clientIdValue != null) {
                this.clientId(clientIdValue);
            }
            if ((subjectValue = instance.subject()) != null) {
                this.subject(subjectValue);
            }
            if ((agentNameValue = instance.agentName()) != null) {
                this.agentName(agentNameValue);
            }
            if ((agentVersionValue = instance.agentVersion()) != null) {
                this.agentVersion(agentVersionValue);
            }
            if ((tabIdValue = instance.tabId()) != null) {
                this.tabId(tabIdValue);
            }
            return this;
        }

        @JsonProperty(value="marVersion")
        public final Builder marVersion(MARData.Version marVersion) {
            this.marVersion = Objects.requireNonNull(marVersion, "marVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="type")
        public final Builder type(MARData.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="clientId")
        public final Builder clientId(@Nullable String clientId) {
            this.clientId = clientId;
            return this;
        }

        @JsonProperty(value="subject")
        public final Builder subject(@Nullable String subject) {
            this.subject = subject;
            return this;
        }

        @JsonProperty(value="agentName")
        public final Builder agentName(@Nullable String agentName) {
            this.agentName = agentName;
            return this;
        }

        @JsonProperty(value="agentVersion")
        public final Builder agentVersion(@Nullable String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        @JsonProperty(value="tabId")
        public final Builder tabId(@Nullable String tabId) {
            this.tabId = tabId;
            return this;
        }

        public ImmutableMARData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMARData(this.marVersion, this.type, this.clientId, this.subject, this.agentName, this.agentVersion, this.tabId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("marVersion");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build MARData, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MARData", generator="Immutables")
    static final class Json
    extends MARData {
        MARData.Version marVersion;
        MARData.Type type;
        @Nullable String clientId;
        @Nullable String subject;
        @Nullable String agentName;
        @Nullable String agentVersion;
        @Nullable String tabId;

        Json() {
        }

        @JsonProperty(value="marVersion")
        public void setMarVersion(MARData.Version marVersion) {
            this.marVersion = marVersion;
        }

        @JsonProperty(value="type")
        public void setType(MARData.Type type) {
            this.type = type;
        }

        @JsonProperty(value="clientId")
        public void setClientId(@Nullable String clientId) {
            this.clientId = clientId;
        }

        @JsonProperty(value="subject")
        public void setSubject(@Nullable String subject) {
            this.subject = subject;
        }

        @JsonProperty(value="agentName")
        public void setAgentName(@Nullable String agentName) {
            this.agentName = agentName;
        }

        @JsonProperty(value="agentVersion")
        public void setAgentVersion(@Nullable String agentVersion) {
            this.agentVersion = agentVersion;
        }

        @JsonProperty(value="tabId")
        public void setTabId(@Nullable String tabId) {
            this.tabId = tabId;
        }

        @Override
        public MARData.Version marVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MARData.Type type() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable String clientId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable String subject() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable String agentName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable String agentVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public @Nullable String tabId() {
            throw new UnsupportedOperationException();
        }
    }
}

