/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.message.model;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;
import org.merlyn.message.model.ImmutableMARData;
import org.merlyn.message.model.MARParserException;

@JsonSerialize(as=ImmutableMARData.class)
@JsonDeserialize(as=ImmutableMARData.class)
@Value.Immutable
public abstract class MARData {
    public abstract Version marVersion();

    public abstract Type type();

    public abstract @Nullable String clientId();

    public abstract @Nullable String subject();

    public abstract @Nullable String agentName();

    public abstract @Nullable String agentVersion();

    public abstract @Nullable String tabId();

    public static enum Version {
        V1;


        public static Version fromString(String value) {
            if (value.equals("mar1")) {
                return V1;
            }
            throw new MARParserException("Unable to parse MAR version: " + value);
        }
    }

    public static enum Type {
        WEB,
        CLIENT,
        SUB,
        CLOUD;


        public static Type fromString(String value) {
            switch (value) {
                case "client": {
                    return CLIENT;
                }
                case "cloud": {
                    return CLOUD;
                }
                case "web": {
                    return WEB;
                }
                case "sub": {
                    return SUB;
                }
            }
            throw new MARParserException("Unable to parse type: " + value);
        }
    }
}

