/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.fxviews.ftue;

import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.merlyn.sharedui.res.Colors;
import org.merlyn.sharedui.res.ColorsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0005J\b\u0010\u000f\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/merlyn/sharedui/fxviews/ftue/FtuePagerIndicator;", "Ljavafx/scene/layout/HBox;", "<init>", "()V", "maxIndicatorCount", "", "circleCount", "pageCount", "selectedIdx", "selectedCircleIdx", "setPageCount", "", "count", "setSelection", "idx", "setIndicatorScaling", "IndicatorDot", "sharedui"})
@SourceDebugExtension(value={"SMAP\nFtuePagerIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FtuePagerIndicator.kt\norg/merlyn/sharedui/fxviews/ftue/FtuePagerIndicator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1#2:90\n*E\n"})
public final class FtuePagerIndicator
extends HBox {
    private final int maxIndicatorCount;
    private int circleCount;
    private int pageCount;
    private int selectedIdx = -1;
    private int selectedCircleIdx = -1;

    public FtuePagerIndicator() {
        this.maxIndicatorCount = 4;
        this.setPrefHeight(10.0);
        this.setMaxHeight(10.0);
        this.setSpacing(10.0);
        this.setAlignment(Pos.CENTER);
    }

    public final void setPageCount(int count) {
        this.pageCount = count;
        this.circleCount = RangesKt.coerceAtMost((int)this.pageCount, (int)this.maxIndicatorCount);
        boolean isAdd = this.getChildren().size() <= this.circleCount;
        int n = Math.abs(this.circleCount - this.getChildren().size());
        for (int i = 0; i < n; ++i) {
            int it = i;
            boolean bl = false;
            Object object = isAdd ? Boolean.valueOf(this.getChildren().add((Object)new IndicatorDot())) : this.getChildren().remove(0);
        }
        this.setSelection(this.selectedIdx);
    }

    public final void setSelection(int idx) {
        int n;
        Node it;
        if (this.pageCount <= 0) {
            return;
        }
        if (!(0 <= idx ? idx < this.pageCount : false)) {
            return;
        }
        this.selectedIdx = idx;
        ObservableList observableList = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getChildren(...)");
        Node node = (Node)CollectionsKt.getOrNull((List)((List)observableList), (int)this.selectedCircleIdx);
        if (node != null) {
            it = node;
            boolean bl = false;
            ((IndicatorDot)it).setActive(false);
        }
        if (this.selectedIdx == 0) {
            n = 0;
        } else if (this.selectedIdx == this.pageCount - 1) {
            n = this.circleCount - 1;
        } else if (this.pageCount <= this.maxIndicatorCount) {
            n = this.selectedIdx;
        } else {
            int brackets = this.pageCount / (this.maxIndicatorCount - 2);
            n = (this.selectedIdx - 1) / brackets + 1;
        }
        this.selectedCircleIdx = n;
        ObservableList observableList2 = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList2, (String)"getChildren(...)");
        Node node2 = (Node)CollectionsKt.getOrNull((List)((List)observableList2), (int)this.selectedCircleIdx);
        if (node2 != null) {
            it = node2;
            boolean bl = false;
            ((IndicatorDot)it).setActive(true);
        }
        this.setIndicatorScaling();
    }

    private final void setIndicatorScaling() {
        boolean isLeftSmall = this.selectedIdx > 1;
        boolean isRightSmall = this.pageCount - this.selectedIdx > 2;
        ((Node)this.getChildren().get(0)).setScaleX(isLeftSmall ? 0.7 : 1.0);
        ((Node)this.getChildren().get(0)).setScaleY(isLeftSmall ? 0.7 : 1.0);
        ObservableList observableList = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getChildren(...)");
        ((Node)CollectionsKt.last((List)((List)observableList))).setScaleX(isRightSmall ? 0.7 : 1.0);
        ObservableList observableList2 = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList2, (String)"getChildren(...)");
        ((Node)CollectionsKt.last((List)((List)observableList2))).setScaleY(isRightSmall ? 0.7 : 1.0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R$\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/merlyn/sharedui/fxviews/ftue/FtuePagerIndicator$IndicatorDot;", "Ljavafx/scene/shape/Circle;", "<init>", "()V", "value", "", "isActive", "()Z", "setActive", "(Z)V", "sharedui"})
    private static final class IndicatorDot
    extends Circle {
        private boolean isActive;

        public IndicatorDot() {
            super(5.0);
            this.setFill((Paint)Colors.INSTANCE.getWhite24Color());
        }

        public final boolean isActive() {
            return this.isActive;
        }

        public final void setActive(boolean value) {
            this.isActive = value;
            this.setFill(value ? (Paint)ColorsKt.toColor("#FFFFFF") : (Paint)Colors.INSTANCE.getWhite24Color());
        }
    }
}

