/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.fxviews.widget;

import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.Pane;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.core.spacecontextservice.model.LocalizationContext;
import org.merlyn.sharedui.fxviews.anims.WidgetShowHideAnimation;
import org.merlyn.sharedui.fxviews.models.WidgetState;
import org.merlyn.sharedui.fxviews.utils.MeasurementUtilsKt;
import org.merlyn.sharedui.fxviews.utils.SoloMeasurable;
import org.merlyn.sharedui.fxviews.widget.ToolbarPane;
import org.merlyn.sharedui.fxviews.widget.WidgetListener;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u008d\u0001\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00126\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\t\u00126\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'H\u0002J\u000e\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u001fJ\b\u0010*\u001a\u00020\u000fH\u0002J\u0010\u0010+\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020\u001fH\u0002J\u0010\u0010,\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u001fH\u0002J\u0016\u0010-\u001a\u00020\u000f2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020/R>\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0010\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\"\u00a8\u00061"}, d2={"Lorg/merlyn/sharedui/fxviews/widget/WidgetContainerPane;", "Ljavafx/scene/layout/AnchorPane;", "Lorg/merlyn/sharedui/fxviews/utils/SoloMeasurable;", "localizationContextFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lorg/merlyn/core/spacecontextservice/model/LocalizationContext;", "viewModelScope", "Lkotlinx/coroutines/CoroutineScope;", "onResizeRequest", "Lkotlin/Function2;", "", "Lkotlin/ParameterName;", "name", "w", "h", "", "onContainerSizeChange", "<init>", "(Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "value", "Lorg/merlyn/sharedui/fxviews/widget/WidgetListener;", "listener", "getListener", "()Lorg/merlyn/sharedui/fxviews/widget/WidgetListener;", "setListener", "(Lorg/merlyn/sharedui/fxviews/widget/WidgetListener;)V", "options", "Lorg/merlyn/sharedui/fxviews/widget/ToolbarPane;", "optionAnimation", "Lorg/merlyn/sharedui/fxviews/anims/WidgetShowHideAnimation;", "lastState", "Lorg/merlyn/sharedui/fxviews/models/WidgetState;", "calculatedWidth", "getCalculatedWidth", "()D", "calculatedHeight", "getCalculatedHeight", "setAnchors", "node", "Ljavafx/scene/Node;", "setWidgetState", "widgetState", "onRecalculateSize", "onContentSizeChanged", "calculateHeightFromState", "setUserLoginStatus", "isLoggedIn", "", "isUserSubscriptionValid", "sharedui"})
public final class WidgetContainerPane
extends AnchorPane
implements SoloMeasurable {
    @NotNull
    private final Function2<Double, Double, Unit> onResizeRequest;
    @NotNull
    private final Function2<Double, Double, Unit> onContainerSizeChange;
    @Nullable
    private WidgetListener listener;
    @NotNull
    private final ToolbarPane options;
    @NotNull
    private final WidgetShowHideAnimation optionAnimation;
    @NotNull
    private WidgetState lastState;

    public WidgetContainerPane(@NotNull StateFlow<LocalizationContext> localizationContextFlow, @NotNull CoroutineScope viewModelScope, @NotNull Function2<? super Double, ? super Double, Unit> onResizeRequest, @NotNull Function2<? super Double, ? super Double, Unit> onContainerSizeChange) {
        Intrinsics.checkNotNullParameter(localizationContextFlow, (String)"localizationContextFlow");
        Intrinsics.checkNotNullParameter((Object)viewModelScope, (String)"viewModelScope");
        Intrinsics.checkNotNullParameter(onResizeRequest, (String)"onResizeRequest");
        Intrinsics.checkNotNullParameter(onContainerSizeChange, (String)"onContainerSizeChange");
        this.onResizeRequest = onResizeRequest;
        this.onContainerSizeChange = onContainerSizeChange;
        this.options = new ToolbarPane(localizationContextFlow, viewModelScope);
        this.optionAnimation = new WidgetShowHideAnimation((Pane)this.options, (Function0<Unit>)((Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                WidgetContainerPane.access$onRecalculateSize((WidgetContainerPane)this.receiver);
            }
        }));
        this.lastState = new WidgetState(false, false, 2, null);
        this.setBackground(Background.EMPTY);
        this.options.setVisible(false);
        this.setAnchors((Node)this.options);
        this.options.widthProperty().addListener((arg_0, arg_1, arg_2) -> WidgetContainerPane._init_$lambda$1((arg_0, arg_1, arg_2) -> WidgetContainerPane._init_$lambda$0(this, arg_0, arg_1, arg_2), arg_0, arg_1, arg_2));
        this.getChildren().add((Object)this.options);
    }

    @Nullable
    public final WidgetListener getListener() {
        return this.listener;
    }

    public final void setListener(@Nullable WidgetListener value) {
        this.listener = value;
        this.options.setListener(value);
    }

    @Override
    public double getCalculatedWidth() {
        double w = MeasurementUtilsKt.calculateWidth((Pane)this.options);
        return !(w == 0.0) ? w + 16.0 : 0.0;
    }

    @Override
    public double getCalculatedHeight() {
        boolean componentCount = MeasurementUtilsKt.calculateHeight$default((Pane)this.options, 0.0, 1, null) > 0.0;
        double h = MeasurementUtilsKt.calculateHeight$default((Pane)this.options, 0.0, 1, null);
        return h + (double)componentCount * 16.0;
    }

    private final void setAnchors(Node node) {
        AnchorPane.setTopAnchor((Node)node, (Double)0.0);
        AnchorPane.setRightAnchor((Node)node, (Double)16.0);
    }

    public final void setWidgetState(@NotNull WidgetState widgetState) {
        Intrinsics.checkNotNullParameter((Object)widgetState, (String)"widgetState");
        boolean isContainerResize = false;
        if (this.lastState.isToolbarVisible() != widgetState.isToolbarVisible()) {
            this.optionAnimation.start(widgetState.isToolbarVisible());
            isContainerResize = true;
        }
        this.lastState = widgetState;
        if (isContainerResize) {
            this.onContentSizeChanged(widgetState);
        }
    }

    private final void onRecalculateSize() {
        this.onResizeRequest.invoke((Object)this.getCalculatedWidth(), (Object)this.getCalculatedHeight());
    }

    private final void onContentSizeChanged(WidgetState widgetState) {
        this.onContainerSizeChange.invoke((Object)this.getCalculatedWidth(), (Object)this.calculateHeightFromState(widgetState));
    }

    private final double calculateHeightFromState(WidgetState widgetState) {
        return (double)(widgetState.isToolbarVisible() ? 1 : 0) * 88.0;
    }

    public final void setUserLoginStatus(boolean isLoggedIn, boolean isUserSubscriptionValid) {
        this.options.setUserLoginStatus(isLoggedIn, isUserSubscriptionValid);
    }

    private static final Unit _init_$lambda$0(WidgetContainerPane this$0, ObservableValue observableValue, Number number, Number number2) {
        this$0.onRecalculateSize();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$1(Function3 $tmp0, ObservableValue p0, Object p1, Object p2) {
        $tmp0.invoke((Object)p0, p1, p2);
    }

    public static final /* synthetic */ void access$onRecalculateSize(WidgetContainerPane $this) {
        $this.onRecalculateSize();
    }
}

