/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.search;

import javafx.geometry.Rectangle2D;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Screen;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.merlyn.sharedui.annotations.DrawableOverlayScreenKt;
import org.merlyn.sharedui.annotations.DrawingState;
import org.merlyn.sharedui.search.PercentageRect;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\u0004\u001a\u0018\u0010\t\u001a\u00020\n*\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\r\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"DASH_LENGTH", "", "toPercentageRect", "Lorg/merlyn/sharedui/search/PercentageRect;", "Lorg/merlyn/sharedui/annotations/DrawingState;", "screen", "Ljavafx/stage/Screen;", "toRectangle2D", "Ljavafx/geometry/Rectangle2D;", "drawDashed", "", "Ljavafx/scene/canvas/GraphicsContext;", "draw", "Lkotlin/Function0;", "sharedui"})
public final class SpotlightOverlayScreenKt {
    private static final double DASH_LENGTH = 10.0;

    @NotNull
    public static final PercentageRect toPercentageRect(@NotNull DrawingState $this$toPercentageRect, @NotNull Screen screen) {
        Intrinsics.checkNotNullParameter((Object)$this$toPercentageRect, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
        Pair<Double, Double> pair = DrawableOverlayScreenKt.toScreenOffset(screen);
        double offsetX = ((Number)pair.component1()).doubleValue();
        double offsetY = ((Number)pair.component2()).doubleValue();
        double x = $this$toPercentageRect.getMinX() + offsetX;
        double y = $this$toPercentageRect.getMinY() + offsetY;
        double w = $this$toPercentageRect.getWidth();
        double h = $this$toPercentageRect.getHeight();
        return new PercentageRect(x / screen.getBounds().getWidth(), y / screen.getBounds().getHeight(), w / screen.getBounds().getWidth(), h / screen.getBounds().getHeight());
    }

    @NotNull
    public static final Rectangle2D toRectangle2D(@NotNull DrawingState $this$toRectangle2D) {
        Intrinsics.checkNotNullParameter((Object)$this$toRectangle2D, (String)"<this>");
        return new Rectangle2D($this$toRectangle2D.getMinX(), $this$toRectangle2D.getMinY(), $this$toRectangle2D.getWidth(), $this$toRectangle2D.getHeight());
    }

    public static final void drawDashed(@NotNull GraphicsContext $this$drawDashed, @NotNull Function0<Unit> draw) {
        Intrinsics.checkNotNullParameter((Object)$this$drawDashed, (String)"<this>");
        Intrinsics.checkNotNullParameter(draw, (String)"draw");
        double[] dArray = new double[]{10.0, 10.0};
        $this$drawDashed.setLineDashes(dArray);
        $this$drawDashed.setStroke((Paint)Color.WHITE);
        $this$drawDashed.setLineDashOffset(0.0);
        draw.invoke();
        $this$drawDashed.setStroke((Paint)Color.BLACK);
        $this$drawDashed.setLineDashOffset(10.0);
        draw.invoke();
    }
}

