/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.diagnostics.checkers;

import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.json.JsonElementBuildersKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonObjectBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.diagnostics.Checker;
import org.merlyn.diagnostics.CheckerKt;
import org.merlyn.diagnostics.checkers.DongleChecker;
import org.merlyn.diagnostics.checkers.DongleData;
import org.merlyn.diagnostics.checkers.DongleProvider;
import org.merlyn.diagnostics.models.CheckResult;
import org.merlyn.diagnostics.models.CheckerConfig;
import org.merlyn.diagnostics.models.CheckerMessages;
import org.merlyn.diagnostics.models.Help;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/merlyn/diagnostics/checkers/DongleChecker;", "Lorg/merlyn/diagnostics/Checker;", "dongleProvider", "Lorg/merlyn/diagnostics/checkers/DongleProvider;", "<init>", "(Lorg/merlyn/diagnostics/checkers/DongleProvider;)V", "check", "Lorg/merlyn/diagnostics/models/CheckResult;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configuration", "Lorg/merlyn/diagnostics/models/CheckerConfig;", "diagnostics"})
@SourceDebugExtension(value={"SMAP\nDongleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DongleChecker.kt\norg/merlyn/diagnostics/checkers/DongleChecker\n+ 2 JsonElementBuilders.kt\nkotlinx/serialization/json/JsonElementBuildersKt\n*L\n1#1,79:1\n28#2,4:80\n28#2,4:84\n*S KotlinDebug\n*F\n+ 1 DongleChecker.kt\norg/merlyn/diagnostics/checkers/DongleChecker\n*L\n57#1:80,4\n67#1:84,4\n*E\n"})
public final class DongleChecker
implements Checker {
    @NotNull
    private final DongleProvider dongleProvider;

    public DongleChecker(@NotNull DongleProvider dongleProvider) {
        Intrinsics.checkNotNullParameter((Object)dongleProvider, (String)"dongleProvider");
        this.dongleProvider = dongleProvider;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public Object check(@NotNull Continuation<? super CheckResult> $completion) {
        if (!($completion instanceof check.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ DongleChecker this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.check((Continuation<? super CheckResult>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.dongleProvider.provide((Continuation<? super DongleData>)$continuation);
                if (v0 == var10_4) {
                    return var10_4;
                }
                ** GOTO lbl20
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl20:
                // 2 sources

                dongle = (DongleData)v0;
                connected = dongle.getConnected();
                mac = dongle.getMacAddress();
                firmware = dongle.getFirmwareVersion();
                hardware = dongle.getHardwareVersion();
                var7_10 = new String[]{"Dongle is connected: " + CheckerKt.yesOrNo(connected != false), "Dongle MAC: " + CheckerKt.dashesIfNoValue(mac), "Dongle firmware version: " + CheckerKt.dashesIfNoValue(firmware), "Dongle hardware version: " + CheckerKt.dashesIfNoValue(hardware)};
                return new CheckResult(connected != false, 0, CollectionsKt.listOf((Object[])var7_10));
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CheckerConfig configuration() {
        void $this$configuration_u24lambda_u241;
        JsonObjectBuilder $this$configuration_u24lambda_u240;
        JsonObjectBuilder builder$iv;
        Object[] objectArray = CollectionsKt.listOf((Object)"Dongle is not connected, check that permissions have been granted");
        CheckerMessages checkerMessages = new CheckerMessages("Dongle is connected", (List<String>)objectArray, "Checking dongle connection");
        objectArray = new Help[2];
        boolean $i$f$buildJsonObject = false;
        JsonObjectBuilder jsonObjectBuilder = builder$iv = new JsonObjectBuilder();
        String string = "link";
        int n = 0;
        Object[] objectArray2 = objectArray;
        CheckerMessages checkerMessages2 = checkerMessages;
        boolean bl = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$configuration_u24lambda_u240, (String)"url", (String)"https://merlynorigin.zendesk.com/hc/en-gb/articles/23288676848404-Troubleshooting-Guide");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$configuration_u24lambda_u240, (String)"title", (String)"Troubleshooting guide for Merlyn Origin");
        Unit unit = Unit.INSTANCE;
        JsonObject jsonObject = builder$iv.build();
        String string2 = string;
        objectArray2[n] = new Help(string2, jsonObject);
        $i$f$buildJsonObject = false;
        $this$configuration_u24lambda_u240 = builder$iv = new JsonObjectBuilder();
        string = "link";
        n = 1;
        objectArray2 = objectArray;
        boolean bl2 = false;
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$configuration_u24lambda_u241, (String)"url", (String)"https://merlynorigin.zendesk.com/hc/en-gb/articles/27022145097748-Quick-Start-Guide-for-Teachers");
        JsonElementBuildersKt.put((JsonObjectBuilder)$this$configuration_u24lambda_u241, (String)"title", (String)"Teacher guide for Merlyn Origin");
        unit = Unit.INSTANCE;
        JsonObject jsonObject2 = builder$iv.build();
        String string3 = string;
        objectArray2[n] = new Help(string3, jsonObject2);
        List list = CollectionsKt.listOf((Object[])objectArray);
        CheckerMessages checkerMessages3 = checkerMessages2;
        return new CheckerConfig(checkerMessages3, list);
    }
}

