/*
 * Decompiled with CFR 0.152.
 */
package com.macasaet.fernet;

import com.macasaet.fernet.Key;
import com.macasaet.fernet.PayloadValidationException;
import com.macasaet.fernet.Token;
import com.macasaet.fernet.TokenValidationException;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAmount;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Validator<T> {
    default public Clock getClock() {
        return Clock.tickSeconds(ZoneOffset.UTC);
    }

    default public TemporalAmount getTimeToLive() {
        return Duration.ofSeconds(60L);
    }

    default public TemporalAmount getMaxClockSkew() {
        return Duration.ofSeconds(60L);
    }

    default public Predicate<T> getObjectValidator() {
        return payload -> true;
    }

    public Function<byte[], T> getTransformer();

    default public T validateAndDecrypt(Key key, Token token) {
        Instant now = Instant.now(this.getClock());
        byte[] plainText = token.validateAndDecrypt(key, now.minus(this.getTimeToLive()), now.plus(this.getMaxClockSkew()));
        T object = this.getTransformer().apply(plainText);
        if (!this.getObjectValidator().test(object)) {
            int i = plainText.length;
            while (--i >= 0) {
                plainText[i] = 0;
            }
            throw new PayloadValidationException("Invalid Fernet token payload.");
        }
        return object;
    }

    default public T validateAndDecrypt(Collection<? extends Key> keys, Token token) {
        Key key = keys.parallelStream().filter(token::isValidSignature).findFirst().orElseThrow(() -> new TokenValidationException("Encryption key not found."));
        return this.validateAndDecrypt(key, token);
    }
}

