/*
 * Decompiled with CFR 0.152.
 */
package org.merlyn.sharedui.annotations;

import java.util.Collection;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.Separator;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.merlyn.sharedui.annotations.DrawingTool;
import org.merlyn.sharedui.fxviews.utils.MeasurementUtilsKt;
import org.merlyn.sharedui.fxviews.widget.AnnotationToolButton;
import org.merlyn.sharedui.fxviews.widget.ColorSelectionButton;
import org.merlyn.sharedui.fxviews.widget.DrawingToolButton;
import org.merlyn.sharedui.res.ImageResources;
import org.merlyn.sharedui.utils.FxViewUtilsKt;
import org.merlyn.sharedui.viewmodels.usecases.AnnotationPenColor;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u00b5\u0001\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u0012\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\r\u0012\u0016\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\u000f\u0012\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012\u0012\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u0011j\u0004\u0018\u0001`\u0014\u0012\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u0011j\u0004\u0018\u0001`\u0016\u0012\u0010\u0010\u0017\u001a\f\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\u0005J\u000e\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 J\u001a\u0010!\u001a\u00020\f*\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u001f\u001a\u00020\tH\u0002J\u0012\u0010$\u001a\u00020\f*\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0012\u0010%\u001a\u00020\f*\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0012\u0010&\u001a\u00020\f*\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0012\u0010'\u001a\u00020\f*\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0012\u0010(\u001a\u00020\f*\b\u0012\u0004\u0012\u00020#0\"H\u0002J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0006H\u0002R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001bR\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bj\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u0011j\u0004\u0018\u0001`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u0011j\u0004\u0018\u0001`\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\f\u0018\u00010\u0011j\u0004\u0018\u0001`\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0017\u001a\f\u0012\u0004\u0012\u00020\f0\u0011j\u0002`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/merlyn/sharedui/annotations/DrawingControlsPane;", "Ljavafx/scene/layout/HBox;", "drawingTools", "", "Lkotlin/Pair;", "Lorg/merlyn/sharedui/annotations/DrawingTool;", "", "colors", "", "Lorg/merlyn/sharedui/viewmodels/usecases/AnnotationPenColor;", "setPaintColor", "Lkotlin/Function1;", "", "Lorg/merlyn/sharedui/annotations/SetPaintColorOp;", "selectDrawingTool", "Lorg/merlyn/sharedui/annotations/SelectDrawingToolOp;", "undo", "Lkotlin/Function0;", "Lorg/merlyn/sharedui/annotations/UndoOp;", "redo", "Lorg/merlyn/sharedui/annotations/RedoOp;", "clear", "Lorg/merlyn/sharedui/annotations/ClearOp;", "close", "Lorg/merlyn/sharedui/annotations/CloseOp;", "<init>", "(Ljava/util/List;[Lorg/merlyn/sharedui/viewmodels/usecases/AnnotationPenColor;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "[Lorg/merlyn/sharedui/viewmodels/usecases/AnnotationPenColor;", "setSelectedDrawingTool", "drawingTool", "setSelectedColor", "color", "Ljavafx/scene/paint/Color;", "addSetPaintColor", "", "Ljavafx/scene/Node;", "addSeparator", "addDrawingStrategySection", "addUndoRedoSection", "addClearButton", "addCloseButton", "iconImage", "Ljavafx/scene/image/Image;", "resource", "sharedui"})
@SourceDebugExtension(value={"SMAP\nDrawingControlsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawingControlsPane.kt\norg/merlyn/sharedui/annotations/DrawingControlsPane\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,169:1\n13472#2,2:170\n37#3:172\n36#3,3:173\n1869#4,2:176\n1869#4,2:178\n1869#4,2:181\n1#5:180\n*S KotlinDebug\n*F\n+ 1 DrawingControlsPane.kt\norg/merlyn/sharedui/annotations/DrawingControlsPane\n*L\n54#1:170,2\n68#1:172\n68#1:173,3\n95#1:176,2\n103#1:178,2\n123#1:181,2\n*E\n"})
public final class DrawingControlsPane
extends HBox {
    @NotNull
    private final List<Pair<DrawingTool, String>> drawingTools;
    @Nullable
    private final AnnotationPenColor[] colors;
    @NotNull
    private final Function1<AnnotationPenColor, Unit> setPaintColor;
    @NotNull
    private final Function1<DrawingTool, Unit> selectDrawingTool;
    @Nullable
    private final Function0<Unit> undo;
    @Nullable
    private final Function0<Unit> redo;
    @Nullable
    private final Function0<Unit> clear;
    @NotNull
    private final Function0<Unit> close;

    /*
     * WARNING - void declaration
     */
    public DrawingControlsPane(@NotNull List<? extends Pair<? extends DrawingTool, String>> drawingTools, @Nullable AnnotationPenColor[] colors, @NotNull Function1<? super AnnotationPenColor, Unit> setPaintColor, @NotNull Function1<? super DrawingTool, Unit> selectDrawingTool, @Nullable Function0<Unit> undo, @Nullable Function0<Unit> redo, @Nullable Function0<Unit> clear, @NotNull Function0<Unit> close) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter(drawingTools, (String)"drawingTools");
        Intrinsics.checkNotNullParameter(setPaintColor, (String)"setPaintColor");
        Intrinsics.checkNotNullParameter(selectDrawingTool, (String)"selectDrawingTool");
        Intrinsics.checkNotNullParameter(close, (String)"close");
        this.drawingTools = drawingTools;
        this.colors = colors;
        this.setPaintColor = setPaintColor;
        this.selectDrawingTool = selectDrawingTool;
        this.undo = undo;
        this.redo = redo;
        this.clear = clear;
        this.close = close;
        BackgroundFill[] backgroundFillArray = CollectionsKt.createListBuilder();
        List $this$_init__u24lambda_u241 = backgroundFillArray;
        boolean bl = false;
        if (this.colors != null) {
            AnnotationPenColor[] $this$forEach$iv = this.colors;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                AnnotationPenColor element$iv;
                AnnotationPenColor it = element$iv = $this$forEach$iv[i];
                boolean bl2 = false;
                this.addSetPaintColor($this$_init__u24lambda_u241, it);
            }
        }
        if (this.colors != null) {
            this.addSeparator($this$_init__u24lambda_u241);
        }
        this.addDrawingStrategySection($this$_init__u24lambda_u241);
        this.addSeparator($this$_init__u24lambda_u241);
        if (this.undo != null || this.redo != null) {
            this.addUndoRedoSection($this$_init__u24lambda_u241);
        }
        if (this.clear != null) {
            this.addClearButton($this$_init__u24lambda_u241);
        }
        this.addCloseButton($this$_init__u24lambda_u241);
        backgroundFillArray = CollectionsKt.build((List)backgroundFillArray);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        Object[] controlPills = thisCollection$iv.toArray(new Node[0]);
        ObservableList observableList = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getChildren(...)");
        CollectionsKt.addAll((Collection)((Collection)observableList), (Object[])controlPills);
        this.setSpacing(8.0);
        this.setPadding(new Insets(8.0));
        backgroundFillArray = new BackgroundFill[1];
        Stop[] stopArray = new Stop[]{new Stop(0.0, Color.web((String)"#2B5D7E")), new Stop(1.0, Color.web((String)"#28347C"))};
        backgroundFillArray[0] = new BackgroundFill((Paint)new LinearGradient(0.0, 0.0, 1.0, 0.0, true, CycleMethod.NO_CYCLE, stopArray), new CornerRadii(16.0, 16.0, 16.0, 16.0, false), Insets.EMPTY);
        this.setBackground(new Background(backgroundFillArray));
        this.setMaxWidth(MeasurementUtilsKt.calculateWidth((Pane)this));
        this.setMaxHeight(MeasurementUtilsKt.calculateHeight$default((Pane)this, 0.0, 1, null));
    }

    public final void setSelectedDrawingTool(@NotNull DrawingTool drawingTool) {
        Intrinsics.checkNotNullParameter((Object)((Object)drawingTool), (String)"drawingTool");
        ObservableList observableList = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getChildren(...)");
        Iterable $this$forEach$iv = (Iterable)observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            if (!(it instanceof DrawingToolButton)) continue;
            ((DrawingToolButton)it).setSelected(drawingTool == ((DrawingToolButton)it).getDrawingTool());
        }
    }

    public final void setSelectedColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        ObservableList observableList = this.getChildren();
        Intrinsics.checkNotNullExpressionValue((Object)observableList, (String)"getChildren(...)");
        Iterable $this$forEach$iv = (Iterable)observableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            if (!(it instanceof ColorSelectionButton)) continue;
            ((ColorSelectionButton)it).setSelected(Intrinsics.areEqual((Object)color, (Object)((ColorSelectionButton)it).getColor()));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addSetPaintColor(List<Node> $this$addSetPaintColor, AnnotationPenColor color) {
        void $this$addSetPaintColor_u24lambda_u245;
        ColorSelectionButton colorSelectionButton;
        ColorSelectionButton colorSelectionButton2 = colorSelectionButton = new ColorSelectionButton(color.getValue(), 40.0, 40.0);
        List<Node> list = $this$addSetPaintColor;
        boolean bl = false;
        FxViewUtilsKt.onClick((Node)$this$addSetPaintColor_u24lambda_u245, (Function0<Unit>)((Function0)() -> DrawingControlsPane.addSetPaintColor$lambda$5$lambda$4(this, color)));
        list.add((Node)colorSelectionButton);
    }

    private final void addSeparator(List<Node> $this$addSeparator) {
        Separator separator = new Separator(Orientation.VERTICAL);
        $this$addSeparator.add((Node)separator);
    }

    /*
     * WARNING - void declaration
     */
    private final void addDrawingStrategySection(List<Node> $this$addDrawingStrategySection) {
        Iterable $this$forEach$iv = this.drawingTools;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$addDrawingStrategySection_u24lambda_u248_u24lambda_u247;
            DrawingToolButton drawingToolButton;
            Pair pair = (Pair)element$iv;
            boolean bl = false;
            DrawingTool drawingTool = (DrawingTool)((Object)pair.component1());
            String imageResourceId = (String)pair.component2();
            DrawingToolButton drawingToolButton2 = drawingToolButton = new DrawingToolButton(drawingTool, this.iconImage(imageResourceId));
            List<Node> list = $this$addDrawingStrategySection;
            boolean bl2 = false;
            FxViewUtilsKt.onClick((Node)$this$addDrawingStrategySection_u24lambda_u248_u24lambda_u247, (Function0<Unit>)((Function0)() -> DrawingControlsPane.addDrawingStrategySection$lambda$8$lambda$7$lambda$6(this, drawingTool)));
            list.add((Node)drawingToolButton);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addUndoRedoSection(List<Node> $this$addUndoRedoSection) {
        block1: {
            void $this$addUndoRedoSection_u24lambda_u2414_u24lambda_u2413;
            AnnotationToolButton $this$addUndoRedoSection_u24lambda_u2411_u24lambda_u2410;
            List<Node> list;
            AnnotationToolButton annotationToolButton;
            Function0<Unit> function0 = this.undo;
            if (function0 != null) {
                Function0<Unit> undo = function0;
                boolean bl = false;
                AnnotationToolButton annotationToolButton2 = annotationToolButton = new AnnotationToolButton(this.iconImage(ImageResources.INSTANCE.getIcAnnotationsUndo()));
                list = $this$addUndoRedoSection;
                boolean bl2 = false;
                FxViewUtilsKt.onClick((Node)$this$addUndoRedoSection_u24lambda_u2411_u24lambda_u2410, (Function0<Unit>)((Function0)() -> DrawingControlsPane.addUndoRedoSection$lambda$11$lambda$10$lambda$9(undo)));
                list.add((Node)annotationToolButton);
            }
            Function0<Unit> function02 = this.redo;
            if (function02 == null) break block1;
            Function0<Unit> redo = function02;
            boolean bl = false;
            $this$addUndoRedoSection_u24lambda_u2411_u24lambda_u2410 = annotationToolButton = new AnnotationToolButton(this.iconImage(ImageResources.INSTANCE.getIcAnnotationsRedo()));
            list = $this$addUndoRedoSection;
            boolean bl3 = false;
            FxViewUtilsKt.onClick((Node)$this$addUndoRedoSection_u24lambda_u2414_u24lambda_u2413, (Function0<Unit>)((Function0)() -> DrawingControlsPane.addUndoRedoSection$lambda$14$lambda$13$lambda$12(redo)));
            list.add((Node)annotationToolButton);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addClearButton(List<Node> $this$addClearButton) {
        void $this$addClearButton_u24lambda_u2416;
        AnnotationToolButton annotationToolButton;
        AnnotationToolButton annotationToolButton2 = annotationToolButton = new AnnotationToolButton(this.iconImage(ImageResources.INSTANCE.getIcAnnotationsClear()));
        List<Node> list = $this$addClearButton;
        boolean bl = false;
        FxViewUtilsKt.onClick((Node)$this$addClearButton_u24lambda_u2416, (Function0<Unit>)((Function0)() -> DrawingControlsPane.addClearButton$lambda$16$lambda$15(this)));
        list.add((Node)annotationToolButton);
    }

    /*
     * WARNING - void declaration
     */
    private final void addCloseButton(List<Node> $this$addCloseButton) {
        void $this$addCloseButton_u24lambda_u2418;
        AnnotationToolButton annotationToolButton;
        AnnotationToolButton annotationToolButton2 = annotationToolButton = new AnnotationToolButton(this.iconImage(ImageResources.INSTANCE.getIcAnnotationsClose()));
        List<Node> list = $this$addCloseButton;
        boolean bl = false;
        FxViewUtilsKt.onClick((Node)$this$addCloseButton_u24lambda_u2418, (Function0<Unit>)((Function0)() -> DrawingControlsPane.addCloseButton$lambda$18$lambda$17(this)));
        list.add((Node)annotationToolButton);
    }

    private final Image iconImage(String resource) {
        return new Image(resource, 40.0, 40.0, true, true);
    }

    private static final Unit addSetPaintColor$lambda$5$lambda$4(DrawingControlsPane this$0, AnnotationPenColor $color) {
        this$0.setPaintColor.invoke((Object)$color);
        return Unit.INSTANCE;
    }

    private static final Unit addDrawingStrategySection$lambda$8$lambda$7$lambda$6(DrawingControlsPane this$0, DrawingTool $drawingTool) {
        this$0.selectDrawingTool.invoke((Object)$drawingTool);
        return Unit.INSTANCE;
    }

    private static final Unit addUndoRedoSection$lambda$11$lambda$10$lambda$9(Function0 $undo) {
        $undo.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit addUndoRedoSection$lambda$14$lambda$13$lambda$12(Function0 $redo) {
        $redo.invoke();
        return Unit.INSTANCE;
    }

    private static final Unit addClearButton$lambda$16$lambda$15(DrawingControlsPane this$0) {
        block0: {
            Function0<Unit> function0 = this$0.clear;
            if (function0 == null) break block0;
            function0.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final Unit addCloseButton$lambda$18$lambda$17(DrawingControlsPane this$0) {
        this$0.close.invoke();
        return Unit.INSTANCE;
    }
}

